/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Logger logger = LoggerFactory.getLogger(QueueingThreadPoolExecutor.class);
    static final int CORE_THREAD_POOL_SIZE = 1;
    private final BlockingQueue<Runnable> taskQueue;
    private Thread queueThread;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Object semaphore = new Object();
    private final String threadPoolName;

    /*
     * WARNING - void declaration
     */
    protected QueueingThreadPoolExecutor(String name, int threadPoolSize) {
        this(name, new CommonThreadFactory((String)var1_1), (int)var2_2, new LinkedTransferQueue<Runnable>(), new QueueingRejectionHandler());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private QueueingThreadPoolExecutor(String threadPoolName, ThreadFactory threadFactory, int threadPoolSize, BlockingQueue<Runnable> taskQueue, RejectedExecutionHandler rejectionHandler) {
        super(1, (int)var3_3, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)var2_2, rejectionHandler);
        void var1_1;
        void var2_2;
        void var3_3;
        this.threadPoolName = var1_1;
        this.taskQueue = taskQueue;
        this.logger.debug("Using {} as taskQueue implementation", (Object)taskQueue.getClass().getCanonicalName());
        this.allowCoreThreadTimeOut(true);
    }

    /*
     * WARNING - void declaration
     */
    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize) {
        void var1_1;
        return QueueingThreadPoolExecutor.createInstance(name, (int)var1_1, new LinkedTransferQueue<Runnable>());
    }

    /*
     * WARNING - void declaration
     */
    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize, BlockingQueue<Runnable> taskQueue) {
        void var2_2;
        void var1_1;
        String string;
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("A thread pool name must be provided!");
        }
        return new QueueingThreadPoolExecutor(name, new CommonThreadFactory(string), (int)var1_1, (BlockingQueue<Runnable>)var2_2, new QueueingRejectionHandler());
    }

    /*
     * WARNING - void declaration
     */
    protected void addToQueue(Runnable runnable) {
        this.lock.readLock().lock();
        if (this.queueThread == null || !this.queueThread.isAlive()) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.queueThread == null || !this.queueThread.isAlive()) {
                    this.logger.info("Thread pool '{}' exhausted, queueing tasks now.", (Object)this.threadPoolName);
                    this.queueThread = this.createNewQueueThread();
                    this.queueThread.start();
                }
                this.lock.readLock().lock();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        try {
            void var1_1;
            this.taskQueue.add((Runnable)var1_1);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        void var2_2;
        Object object;
        super.afterExecute((Runnable)object, (Throwable)var2_2);
        object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
            return;
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.taskQueue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable command) {
        if (this.taskQueue.isEmpty()) {
            super.execute(command);
            return;
        }
        if (command == null) {
            throw new NullPointerException();
        }
        if (!this.isShutdown()) {
            void var1_1;
            this.addToQueue((Runnable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Thread createNewQueueThread() {
        void var1_1;
        Thread thread = this.getThreadFactory().newThread(() -> {
            while (true) {
                Object object;
                if (this.getActiveCount() < this.getMaximumPoolSize()) {
                    try {
                        Runnable runnable = this.taskQueue.poll(2L, TimeUnit.SECONDS);
                        if (runnable != null) {
                            this.logger.debug("Executing queued task of thread pool '{}'.", (Object)this.threadPoolName);
                            QueueingThreadPoolExecutor.super.execute((Runnable)object);
                            continue;
                        }
                        this.lock.writeLock().lock();
                        try {
                            if (!this.taskQueue.isEmpty()) continue;
                            this.queueThread = null;
                            break;
                        }
                        finally {
                            this.lock.writeLock().unlock();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    object = this.semaphore;
                    synchronized (object) {
                        this.semaphore.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.logger.debug("Queue for thread pool '{}' fully processed - terminating queue thread.", (Object)this.threadPoolName);
        });
        thread.setName(this.threadPoolName + "-queue");
        return var1_1;
    }

    private static class CommonThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String name;

        /*
         * WARNING - void declaration
         */
        public CommonThreadFactory(String name) {
            void var1_1;
            this.name = var1_1;
            this.group = Thread.currentThread().getThreadGroup();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Thread newThread(Runnable r) {
            void var1_1;
            Thread t = new Thread(this.group, r, this.name + "-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return var1_1;
        }
    }

    private static class QueueingRejectionHandler
    extends ThreadPoolExecutor.DiscardPolicy {
        private QueueingRejectionHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                void var1_1;
                QueueingThreadPoolExecutor queueingThreadPoolExecutor;
                queueingThreadPoolExecutor = queueingThreadPoolExecutor;
                queueingThreadPoolExecutor.addToQueue((Runnable)var1_1);
            }
        }
    }
}

