/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Reader;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONTokener;
import org.json.XML;

public class XMLTokener
extends JSONTokener {
    public static final HashMap<String, Character> entity = new HashMap<String, Character>(8);

    /*
     * WARNING - void declaration
     */
    public XMLTokener(Reader r) {
        super((Reader)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public XMLTokener(String s) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String nextCDATA() throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (this.more()) {
            void var2_1;
            void var1_2;
            char c = this.next();
            sb.append(c);
            int i = sb.length() - 3;
            if (i < 0 || sb.charAt(i) != ']' || sb.charAt(i + 1) != ']' || sb.charAt(i + 2) != '>') continue;
            sb.setLength((int)var1_2);
            return var2_1.toString();
        }
        throw this.syntaxError("Unclosed CDATA");
    }

    public Object nextContent() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XML.LT;
        }
        StringBuilder sb = new StringBuilder();
        while (c != '\u0000') {
            if (c == '<') {
                this.back();
                return sb.toString().trim();
            }
            if (c == '&') {
                sb.append(this.nextEntity(c));
            } else {
                sb.append(c);
            }
            c = this.next();
        }
        return sb.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    public Object nextEntity(char ampersand) throws JSONException {
        void var1_2;
        void var2_3;
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isLetterOrDigit(c = this.next()) || c == '#') {
            sb.append(Character.toLowerCase(c));
        }
        if (var2_3 != 59) {
            throw this.syntaxError("Missing ';' in XML entity: &" + sb);
        }
        String string = var1_2.toString();
        return XMLTokener.unescapeEntity(string);
    }

    /*
     * WARNING - void declaration
     */
    static String unescapeEntity(String e) {
        void var1_2;
        if (e == null || e.isEmpty()) {
            return "";
        }
        if (e.charAt(0) == '#') {
            int cp = e.charAt(1) == 'x' || e.charAt(1) == 'X' ? Integer.parseInt(e.substring(2), 16) : Integer.parseInt(e.substring(1));
            return new String(new int[]{cp}, 0, 1);
        }
        Character knownEntity = entity.get(e);
        if (knownEntity == null) {
            String string;
            return "&" + string + ';';
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object nextMeta() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string");
                } while (c != q);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = this.next())) {
            void var1_1;
            switch (var1_1) {
                case 0: {
                    throw this.syntaxError("Unterminated string");
                }
                case 33: 
                case 34: 
                case 39: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                StringBuilder sb = new StringBuilder();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string");
                    }
                    if (c == q) {
                        return sb.toString();
                    }
                    if (c == '&') {
                        sb.append(this.nextEntity(c));
                        continue;
                    }
                    sb.append(c);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(c);
            c = this.next();
            if (Character.isWhitespace(c)) {
                return sb.toString();
            }
            switch (c) {
                case '\u0000': {
                    return sb.toString();
                }
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return sb.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipPast(String to) {
        char c;
        int i;
        int offset = 0;
        int length = to.length();
        char[] circle = new char[length];
        for (i = 0; i < length; ++i) {
            c = this.next();
            if (c == '\u0000') {
                return;
            }
            circle[i] = c;
        }
        while (true) {
            void var2_6;
            int j = offset;
            boolean b = true;
            for (i = 0; i < length; ++i) {
                if (circle[j] != to.charAt(i)) {
                    b = false;
                    break;
                }
                if (++j < length) continue;
                j -= length;
            }
            if (b) {
                return;
            }
            c = this.next();
            if (c == '\u0000') {
                return;
            }
            circle[offset] = var2_6;
            if (++offset < length) continue;
            offset -= length;
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

