/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLParserConfiguration;
import org.json.XMLTokener;
import org.json.XMLXsiTypeConverter;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');
    public static final String NULL_ATTR = "xsi:nil";
    public static final String TYPE_ATTR = "xsi:type";

    private static Iterable<Integer> codePointIterator(String string) {
        String string2;
        return new Iterable<Integer>(){

            @Override
            public final Iterator<Integer> iterator() {
                return new Iterator<Integer>(this){
                    private int nextIndex = 0;
                    private int length;
                    final /* synthetic */ 1 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.length = this.this$0.string2.length();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextIndex < this.length;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Integer next() {
                        void var1_1;
                        int result = this.this$0.string2.codePointAt(this.nextIndex);
                        this.nextIndex += Character.charCount(result);
                        return (int)var1_1;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(String string) {
        void var1_1;
        Iterator<Integer> iterator;
        StringBuilder sb = new StringBuilder(string.length());
        iterator = XML.codePointIterator((String)((Object)iterator)).iterator();
        block7: while (iterator.hasNext()) {
            void var2_2;
            int cp = (Integer)iterator.next();
            switch (cp) {
                case 38: {
                    sb.append("&amp;");
                    continue block7;
                }
                case 60: {
                    sb.append("&lt;");
                    continue block7;
                }
                case 62: {
                    sb.append("&gt;");
                    continue block7;
                }
                case 34: {
                    sb.append("&quot;");
                    continue block7;
                }
                case 39: {
                    sb.append("&apos;");
                    continue block7;
                }
            }
            if (XML.mustEscape(cp)) {
                sb.append("&#x");
                sb.append(Integer.toHexString(cp));
                sb.append(';');
                continue;
            }
            sb.appendCodePoint((int)var2_2);
        }
        return var1_1.toString();
    }

    private static boolean mustEscape(int cp) {
        int n;
        return Character.isISOControl(cp) && cp != 9 && cp != 10 && cp != 13 || (cp < 32 || cp > 55295) && (cp < 57344 || cp > 65533) && (cp < 65536 || n > 0x10FFFF);
    }

    /*
     * WARNING - void declaration
     */
    public static String unescape(String string) {
        void var1_1;
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            void var4_4;
            char c = string.charAt(i);
            if (c == '&') {
                int semic = string.indexOf(59, i);
                if (semic > i) {
                    String entity = string.substring(i + 1, semic);
                    sb.append(XMLTokener.unescapeEntity(entity));
                    i += entity.length() + 1;
                    continue;
                }
                sb.append((char)var4_4);
                continue;
            }
            sb.append((char)var4_4);
        }
        return var1_1.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int length = string.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean parse(XMLTokener x, JSONObject context, String name, XMLParserConfiguration config, int currentNestingDepth) throws JSONException {
        XMLTokener xMLTokener;
        void var1_1;
        String string;
        Object token = x.nextToken();
        if (token == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token = x.nextToken();
                if ("CDATA".equals(token) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate(config.getcDataTagName(), string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i;
                    continue;
                }
                if (token != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            void c;
            token = x.nextToken();
            if (c == null) {
                throw x.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(c)) {
                throw x.syntaxError("Mismatched " + (String)c + " and " + token);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonObject = new JSONObject();
        boolean nilAttributeFound = false;
        XMLXsiTypeConverter<?> xmlXsiTypeConverter = null;
        while (true) {
            if (token == null) {
                token = x.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x.nextToken();
            if (token == EQ) {
                token = x.nextToken();
                if (!(token instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                if (config.isConvertNilAttributeToNull() && NULL_ATTR.equals(string) && Boolean.parseBoolean((String)token)) {
                    nilAttributeFound = true;
                } else if (config.getXsiTypeMap() != null && !config.getXsiTypeMap().isEmpty() && TYPE_ATTR.equals(string)) {
                    xmlXsiTypeConverter = config.getXsiTypeMap().get(token);
                } else if (!nilAttributeFound) {
                    jsonObject.accumulate(string, config.isKeepStrings() ? (String)token : XML.stringToValue((String)token));
                }
                token = null;
                continue;
            }
            jsonObject.accumulate(string, "");
        }
        if (token == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (config.getForceList().contains(tagName)) {
                if (nilAttributeFound) {
                    var1_1.append(tagName, JSONObject.NULL);
                } else if (jsonObject.length() > 0) {
                    var1_1.append(tagName, jsonObject);
                } else {
                    var1_1.put(tagName, new JSONArray());
                }
            } else if (nilAttributeFound) {
                var1_1.accumulate(tagName, JSONObject.NULL);
            } else if (jsonObject.length() > 0) {
                var1_1.accumulate(tagName, jsonObject);
            } else {
                var1_1.accumulate(tagName, "");
            }
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    if (xmlXsiTypeConverter != null) {
                        jsonObject.accumulate(config.getcDataTagName(), XML.stringToValue(string, xmlXsiTypeConverter));
                        continue;
                    }
                    jsonObject.accumulate(config.getcDataTagName(), config.isKeepStrings() ? string : XML.stringToValue(string));
                    continue;
                }
                if (token != LT) continue;
                if (currentNestingDepth == config.getMaxNestingDepth()) {
                    throw x.syntaxError("Maximum nesting depth of " + config.getMaxNestingDepth() + " reached");
                }
                if (XML.parse(x, jsonObject, tagName, config, currentNestingDepth + 1)) break;
            }
            if (config.getForceList().contains(tagName)) {
                if (jsonObject.length() == 0) {
                    var1_1.put(tagName, new JSONArray());
                } else if (jsonObject.length() == 1 && jsonObject.opt(config.getcDataTagName()) != null) {
                    var1_1.append(tagName, jsonObject.opt(config.getcDataTagName()));
                } else {
                    var1_1.append(tagName, jsonObject);
                }
            } else if (jsonObject.length() == 0) {
                var1_1.accumulate(tagName, "");
            } else if (jsonObject.length() == 1 && jsonObject.opt(config.getcDataTagName()) != null) {
                void var3_5;
                var1_1.accumulate(tagName, jsonObject.opt(var3_5.getcDataTagName()));
            } else {
                void var2_3;
                var1_1.accumulate(tagName, var2_3);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }

    /*
     * WARNING - void declaration
     */
    public static Object stringToValue(String string, XMLXsiTypeConverter<?> typeConverter) {
        String string2;
        if (typeConverter != null) {
            void var1_1;
            return var1_1.convert(string);
        }
        return XML.stringToValue(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object stringToValue(String string) {
        String string2;
        void var1_1;
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        char initial = string.charAt(0);
        if (initial >= '0' && initial <= '9' || var1_1 == 45) {
            try {
                return XML.stringToNumber(string);
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static Number stringToNumber(String val) throws NumberFormatException {
        String string;
        char initial = val.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            void var2_5;
            BigInteger bi;
            char at1;
            void d2;
            if (XML.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double d2 = Double.valueOf(val);
                        if (d2.isNaN() || d2.isInfinite()) {
                            throw new NumberFormatException("val [" + val + "] is not a valid number.");
                        }
                        return d2;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new NumberFormatException("val [" + val + "] is not a valid number.");
                    }
                }
            }
            if (d2 == 48 && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            } else if (d2 == 45 && val.length() > 2) {
                void var1_1;
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && var1_1 <= 57) {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger(val)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return var2_5;
        }
        throw new NumberFormatException("val [" + string + "] is not a valid number.");
    }

    private static boolean isDecimalNotation(String val) {
        String string;
        return val.indexOf(46) >= 0 || val.indexOf(101) >= 0 || val.indexOf(69) >= 0 || "-0".equals(string);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return XML.toJSONObject(string, XMLParserConfiguration.ORIGINAL);
    }

    public static JSONObject toJSONObject(Reader reader) throws JSONException {
        return XML.toJSONObject(reader, XMLParserConfiguration.ORIGINAL);
    }

    public static JSONObject toJSONObject(Reader reader, boolean keepStrings) throws JSONException {
        Reader reader2;
        if (keepStrings) {
            return XML.toJSONObject(reader, XMLParserConfiguration.KEEP_STRINGS);
        }
        return XML.toJSONObject(reader2, XMLParserConfiguration.ORIGINAL);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject toJSONObject(Reader reader, XMLParserConfiguration config) throws JSONException {
        void var2_2;
        JSONObject jo = new JSONObject();
        XMLTokener x = new XMLTokener(reader);
        while (x.more()) {
            x.skipPast("<");
            if (!x.more()) continue;
            XML.parse(x, jo, null, config, 0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        void var1_1;
        String string2;
        return XML.toJSONObject((Reader)new StringReader(string2), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject toJSONObject(String string, XMLParserConfiguration config) throws JSONException {
        void var1_1;
        String string2;
        return XML.toJSONObject((Reader)new StringReader(string2), (XMLParserConfiguration)var1_1);
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null, XMLParserConfiguration.ORIGINAL);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, String tagName) {
        void var1_1;
        return XML.toString(object, (String)var1_1, XMLParserConfiguration.ORIGINAL);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, String tagName, XMLParserConfiguration config) throws JSONException {
        void var2_2;
        void var1_1;
        return XML.toString(object, (String)var1_1, (XMLParserConfiguration)var2_2, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static String toString(Object object, String tagName, XMLParserConfiguration config, int indentFactor, int indent) throws JSONException {
        void var3_3;
        void var1_1;
        Object object2;
        Object string;
        Object ja;
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append(XML.indent(indent));
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
                if (indentFactor > 0) {
                    sb.append("\n");
                    indent += indentFactor;
                }
            }
            JSONObject jo = (JSONObject)object;
            for (String key : jo.keySet()) {
                void jaLength2;
                Object val;
                int i;
                Object value = jo.opt(key);
                if (value == null) {
                    value = "";
                } else if (value.getClass().isArray()) {
                    value = new JSONArray(value);
                }
                if (key.equals(config.getcDataTagName())) {
                    if (value instanceof JSONArray) {
                        ja = (JSONArray)value;
                        int jaLength2 = ((JSONArray)ja).length();
                        for (i = 0; i < jaLength2; ++i) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            val = ((JSONArray)ja).opt(i);
                            sb.append(XML.escape(val.toString()));
                        }
                        continue;
                    }
                    sb.append(XML.escape(jaLength2.toString()));
                    continue;
                }
                if (jaLength2 instanceof JSONArray) {
                    ja = (JSONArray)jaLength2;
                    int jaLength3 = ((JSONArray)ja).length();
                    for (i = 0; i < jaLength3; ++i) {
                        val = ((JSONArray)ja).opt(i);
                        if (val instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toString(val, null, config, indentFactor, indent));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toString(val, key, config, indentFactor, indent));
                    }
                    continue;
                }
                if ("".equals(jaLength2)) {
                    sb.append(XML.indent(indent));
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    if (indentFactor <= 0) continue;
                    sb.append("\n");
                    continue;
                }
                sb.append(XML.toString(jaLength2, key, config, indentFactor, indent));
            }
            if (tagName != null) {
                sb.append(XML.indent(indent - indentFactor));
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
                if (indentFactor > 0) {
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        if (ja != null && (ja instanceof JSONArray || ja.getClass().isArray())) {
            ja = ja.getClass().isArray() ? new JSONArray(ja) : (JSONArray)ja;
            int jaLength = ((JSONArray)ja).length();
            for (int i = 0; i < jaLength; ++i) {
                Object val = ((JSONArray)ja).opt(i);
                sb.append(XML.toString(val, tagName == null ? "array" : tagName, config, indentFactor, indent));
            }
            return sb.toString();
        }
        Object object3 = string = ja == null ? "null" : XML.escape(ja.toString());
        if (tagName == null) {
            return XML.indent(indent) + "\"" + (String)string + "\"" + (indentFactor > 0 ? "\n" : "");
        }
        if (((String)string).length() == 0) {
            return XML.indent(indent) + "<" + tagName + "/>" + (indentFactor > 0 ? "\n" : "");
        }
        return XML.indent(indent) + "<" + tagName + ">" + (String)object2 + "</" + (String)var1_1 + ">" + (var3_3 > 0 ? "\n" : "");
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, int indentFactor) {
        void var1_1;
        return XML.toString(object, null, XMLParserConfiguration.ORIGINAL, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, String tagName, int indentFactor) {
        void var2_2;
        void var1_1;
        return XML.toString(object, (String)var1_1, XMLParserConfiguration.ORIGINAL, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, String tagName, XMLParserConfiguration config, int indentFactor) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        return XML.toString(object, (String)var1_1, (XMLParserConfiguration)var2_2, (int)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final String indent(int indent) {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return var1_1.toString();
    }
}

