/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class JSONWriter {
    private static final int maxdepth = 200;
    private boolean comma = false;
    protected char mode = (char)105;
    private final JSONObject[] stack = new JSONObject[200];
    private int top = 0;
    protected Appendable writer;

    /*
     * WARNING - void declaration
     */
    public JSONWriter(Appendable w) {
        void var1_1;
        this.writer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter append(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.append(',');
                }
                this.writer.append(string);
            }
            catch (IOException e) {
                void var1_2;
                throw new JSONException((Throwable)var1_2);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter end(char m, char c) throws JSONException {
        if (this.mode != m) {
            throw new JSONException(m == 'a' ? "Misplaced endArray." : "Misplaced endObject.");
        }
        this.pop(m);
        try {
            void var2_3;
            this.writer.append((char)var2_3);
        }
        catch (IOException e) {
            void var1_2;
            throw new JSONException((Throwable)var1_2);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter key(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                void var1_1;
                JSONObject topObject = this.stack[this.top - 1];
                if (topObject.has(string)) {
                    throw new JSONException("Duplicate key \"" + string + "\"");
                }
                topObject.put(string, true);
                if (this.comma) {
                    this.writer.append(',');
                }
                this.writer.append(JSONObject.quote((String)var1_1));
                this.writer.append(':');
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                void var2_3;
                throw new JSONException((Throwable)var2_3);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JSONObject());
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    /*
     * WARNING - void declaration
     */
    private void pop(char c) throws JSONException {
        void var1_1;
        if (this.top <= 0) {
            throw new JSONException("Nesting error.");
        }
        int n = this.stack[this.top - 1] == null ? 97 : 107;
        if (n != var1_1) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    /*
     * WARNING - void declaration
     */
    private void push(JSONObject jo) throws JSONException {
        void var1_1;
        if (this.top >= 200) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = jo;
        this.mode = (char)(var1_1 == null ? 97 : 107);
        ++this.top;
    }

    public static String valueToString(Object value) throws JSONException {
        Object object;
        Object map;
        Object numberAsString;
        Object object2;
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                object2 = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (object2 != null) {
                return object2;
            }
            throw new JSONException("Bad value from toJSONString: " + (String)object2);
        }
        if (object2 instanceof Number) {
            numberAsString = JSONObject.numberToString((Number)object2);
            if (JSONObject.NUMBER_PATTERN.matcher((CharSequence)numberAsString).matches()) {
                return numberAsString;
            }
            return JSONObject.quote((String)numberAsString);
        }
        if (numberAsString instanceof Boolean || numberAsString instanceof JSONObject || numberAsString instanceof JSONArray) {
            return numberAsString.toString();
        }
        if (numberAsString instanceof Map) {
            map = (Map)numberAsString;
            return new JSONObject((Map<?, ?>)map).toString();
        }
        if (map instanceof Collection) {
            Object coll = (Collection)map;
            return new JSONArray((Collection<?>)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        if (object instanceof Enum) {
            return JSONObject.quote(((Enum)object).name());
        }
        return JSONObject.quote(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(boolean b) throws JSONException {
        void var1_1;
        return this.append(var1_1 != false ? "true" : "false");
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(double d) throws JSONException {
        void var1_1;
        return this.value((Object)((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(long l) throws JSONException {
        void var1_1;
        return this.append(Long.toString((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(Object object) throws JSONException {
        void var1_1;
        return this.append(JSONWriter.valueToString(var1_1));
    }
}

