/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    private long character;
    private boolean eof;
    private long index;
    private long line;
    private char previous;
    private final Reader reader;
    private boolean usePrevious;
    private long characterPreviousLine;

    /*
     * WARNING - void declaration
     */
    public JSONTokener(Reader reader) {
        void var1_1;
        this.reader = reader.markSupported() ? reader : new BufferedReader((Reader)var1_1);
        this.eof = false;
        this.usePrevious = false;
        this.previous = '\u0000';
        this.index = 0L;
        this.character = 1L;
        this.characterPreviousLine = 0L;
        this.line = 1L;
    }

    /*
     * WARNING - void declaration
     */
    public JSONTokener(InputStream inputStream) {
        this(new InputStreamReader((InputStream)var1_1, Charset.forName("UTF-8")));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONTokener(String s) {
        this(new StringReader((String)var1_1));
        void var1_1;
    }

    public void back() throws JSONException {
        if (this.usePrevious || this.index <= 0L) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        this.decrementIndexes();
        this.usePrevious = true;
        this.eof = false;
    }

    private void decrementIndexes() {
        --this.index;
        if (this.previous == '\r' || this.previous == '\n') {
            --this.line;
            this.character = this.characterPreviousLine;
            return;
        }
        if (this.character > 0L) {
            --this.character;
        }
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            char c2;
            return c2 - 87;
        }
        return -1;
    }

    public boolean end() {
        return this.eof && !this.usePrevious;
    }

    /*
     * WARNING - void declaration
     */
    public boolean more() throws JSONException {
        if (this.usePrevious) {
            return true;
        }
        try {
            this.reader.mark(1);
        }
        catch (IOException e) {
            throw new JSONException("Unable to preserve stream position", e);
        }
        try {
            if (this.reader.read() <= 0) {
                this.eof = true;
                return false;
            }
            this.reader.reset();
        }
        catch (IOException e) {
            void var1_2;
            throw new JSONException("Unable to read the next character from the stream", (Throwable)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public char next() throws JSONException {
        void var1_1;
        int c;
        if (this.usePrevious) {
            this.usePrevious = false;
            c = this.previous;
        } else {
            try {
                c = this.reader.read();
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
        }
        if (c <= 0) {
            this.eof = true;
            return '\u0000';
        }
        this.incrementIndexes(c);
        this.previous = (char)var1_1;
        return this.previous;
    }

    protected char getPrevious() {
        return this.previous;
    }

    /*
     * WARNING - void declaration
     */
    private void incrementIndexes(int c) {
        if (c > 0) {
            void var1_1;
            ++this.index;
            if (c == 13) {
                ++this.line;
                this.characterPreviousLine = this.character;
                this.character = 0L;
                return;
            }
            if (var1_1 == 10) {
                if (this.previous != '\r') {
                    ++this.line;
                    this.characterPreviousLine = this.character;
                }
                this.character = 0L;
                return;
            }
            ++this.character;
        }
    }

    /*
     * WARNING - void declaration
     */
    public char next(char c) throws JSONException {
        void var2_2;
        char n = this.next();
        if (n != c) {
            void var1_1;
            if (n > '\u0000') {
                throw this.syntaxError("Expected '" + c + "' and instead saw '" + n + "'");
            }
            throw this.syntaxError("Expected '" + (char)var1_1 + "' and instead saw ''");
        }
        return (char)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String next(int n) throws JSONException {
        void var2_2;
        if (n == 0) {
            return "";
        }
        char[] chars = new char[n];
        for (int pos = 0; pos < n; ++pos) {
            chars[pos] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String((char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public char nextClean() throws JSONException {
        void var1_1;
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String nextString(char quote) throws JSONException {
        StringBuilder sb = new StringBuilder();
        block15: while (true) {
            void var2_4;
            void var1_1;
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block15;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block15;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block15;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block15;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block15;
                        }
                        case 'u': {
                            try {
                                sb.append((char)Integer.parseInt(this.next(4), 16));
                                continue block15;
                            }
                            catch (NumberFormatException e) {
                                void var1_2;
                                throw this.syntaxError("Illegal escape.", (Throwable)var1_2);
                            }
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block15;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c == var1_1) {
                return sb.toString();
            }
            sb.append((char)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String nextTo(char delimiter) throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            void var3_3;
            char c;
            if ((c = this.next()) == delimiter || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append((char)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String nextTo(String delimiters) throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            void var2_3;
            char c;
            if (delimiters.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append((char)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object nextValue() throws JSONException {
        void var1_1;
        char c = this.nextClean();
        switch (c) {
            case '{': {
                this.back();
                try {
                    return new JSONObject(this);
                }
                catch (StackOverflowError e) {
                    throw new JSONException("JSON Array or Object depth too large to process.", e);
                }
            }
            case '[': {
                this.back();
                try {
                    return new JSONArray(this);
                }
                catch (StackOverflowError e) {
                    void var1_3;
                    throw new JSONException("JSON Array or Object depth too large to process.", (Throwable)var1_3);
                }
            }
        }
        return this.nextSimpleValue((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Object nextSimpleValue(char c) {
        void var1_2;
        void var2_3;
        String string;
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
        }
        StringBuilder sb = new StringBuilder();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        if (!this.eof) {
            this.back();
        }
        if ("".equals(string = var2_3.toString().trim())) {
            throw this.syntaxError("Missing value");
        }
        return JSONObject.stringToValue((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public char skipTo(char to) throws JSONException {
        void var2_6;
        try {
            char c;
            long startIndex = this.index;
            long startCharacter = this.character;
            long startLine = this.line;
            this.reader.mark(1000000);
            do {
                if ((c = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = startIndex;
                this.character = startCharacter;
                this.line = startLine;
                return '\u0000';
            } while (c != to);
            this.reader.mark(1);
        }
        catch (IOException exception) {
            void var3_3;
            throw new JSONException((Throwable)var3_3);
        }
        this.back();
        return (char)var2_6;
    }

    /*
     * WARNING - void declaration
     */
    public JSONException syntaxError(String message) {
        void var1_1;
        return new JSONException((String)var1_1 + this.toString());
    }

    /*
     * WARNING - void declaration
     */
    public JSONException syntaxError(String message, Throwable causedBy) {
        void var2_2;
        void var1_1;
        return new JSONException((String)var1_1 + this.toString(), (Throwable)var2_2);
    }

    public String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

