/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONPointerException;

public class JSONPointer {
    private static final String ENCODING = "utf-8";
    private final List<String> refTokens;

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    public JSONPointer(String pointer) {
        String refs;
        if (pointer == null) {
            throw new NullPointerException("pointer cannot be null");
        }
        if (pointer.isEmpty() || pointer.equals("#")) {
            this.refTokens = Collections.emptyList();
            return;
        }
        if (pointer.startsWith("#/")) {
            refs = pointer.substring(2);
            try {
                refs = URLDecoder.decode(refs, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (refs.startsWith("/")) {
            refs = refs.substring(1);
        } else {
            throw new IllegalArgumentException("a JSON pointer should start with '/' or '#/'");
        }
        this.refTokens = new ArrayList<String>();
        int slashIdx = -1;
        do {
            void var3_6;
            void token2;
            int prevSlashIdx;
            if ((prevSlashIdx = slashIdx + 1) == (slashIdx = refs.indexOf(47, prevSlashIdx)) || prevSlashIdx == refs.length()) {
                this.refTokens.add("");
                continue;
            }
            if (slashIdx >= 0) {
                String token2 = refs.substring(prevSlashIdx, slashIdx);
                this.refTokens.add(JSONPointer.unescape(token2));
                continue;
            }
            String token2 = refs.substring((int)token2);
            this.refTokens.add(JSONPointer.unescape((String)var3_6));
        } while (slashIdx >= 0);
    }

    /*
     * WARNING - void declaration
     */
    public JSONPointer(List<String> refTokens) {
        void var1_1;
        this.refTokens = new ArrayList<String>((Collection<String>)var1_1);
    }

    private static String unescape(String token) {
        return token.replace("~1", "/").replace("~0", "~");
    }

    /*
     * WARNING - void declaration
     */
    public Object queryFrom(Object document) throws JSONPointerException {
        void var1_1;
        if (this.refTokens.isEmpty()) {
            return document;
        }
        for (String token : this.refTokens) {
            void var3_3;
            Object current;
            if (current instanceof JSONObject) {
                current = ((JSONObject)current).opt(JSONPointer.unescape(token));
                continue;
            }
            if (current instanceof JSONArray) {
                current = JSONPointer.readByIndexToken(current, token);
                continue;
            }
            throw new JSONPointerException(String.format("value [%s] is not an array or object therefore its key %s cannot be resolved", current, var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Object readByIndexToken(Object current, String indexToken) throws JSONPointerException {
        try {
            int index = Integer.parseInt(indexToken);
            Object currentArr = (JSONArray)current;
            if (index >= ((JSONArray)currentArr).length()) {
                throw new JSONPointerException(String.format("index %s is out of bounds - the array has %d elements", indexToken, ((JSONArray)currentArr).length()));
            }
            try {
                return ((JSONArray)currentArr).get(index);
            }
            catch (JSONException e) {
                void var0_1;
                throw new JSONPointerException("Error reading value at index position " + index, (Throwable)var0_1);
            }
        }
        catch (NumberFormatException e) {
            void var2_4;
            void var1_2;
            throw new JSONPointerException(String.format("%s is not an array index", var1_2), (Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder rval = new StringBuilder("");
        for (String token : this.refTokens) {
            void var3_3;
            rval.append('/').append(JSONPointer.escape((String)var3_3));
        }
        return var1_1.toString();
    }

    private static String escape(String token) {
        return token.replace("~", "~0").replace("/", "~1");
    }

    /*
     * WARNING - void declaration
     */
    public String toURIFragment() {
        try {
            StringBuilder rval = new StringBuilder("#");
            for (String token : this.refTokens) {
                void var3_4;
                rval.append('/').append(URLEncoder.encode((String)var3_4, ENCODING));
            }
            return rval.toString();
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public static class Builder {
        private final List<String> refTokens = new ArrayList<String>();

        public JSONPointer build() {
            return new JSONPointer(this.refTokens);
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(String token) {
            void var1_1;
            if (token == null) {
                throw new NullPointerException("token cannot be null");
            }
            this.refTokens.add((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(int arrayIndex) {
            void var1_1;
            this.refTokens.add(String.valueOf((int)var1_1));
            return this;
        }
    }
}

