/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONPointer;
import org.json.JSONPointerException;
import org.json.JSONPropertyIgnore;
import org.json.JSONPropertyName;
import org.json.JSONString;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class JSONObject {
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");
    private final Map<String, Object> map;
    public static final Object NULL = new Null();

    public Class<? extends Map> getMapType() {
        return this.map.getClass();
    }

    public JSONObject() {
        this.map = new HashMap<String, Object>();
    }

    public JSONObject(JSONObject jo, String ... names) {
        this(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONTokener x) throws JSONException {
        this();
        void var1_1;
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            String key = x.nextSimpleValue(c).toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (key != null) {
                if (this.opt(key) != null) {
                    throw x.syntaxError("Duplicate key \"" + key + "\"");
                }
                Object value = x.nextValue();
                if (value != null) {
                    void var2_3;
                    void var3_4;
                    this.put((String)var3_4, var2_3);
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    if (x.end()) {
                        throw x.syntaxError("A JSONObject text must end with '}'");
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw var1_1.syntaxError("Expected a ',' or '}'");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Map<?, ?> m) {
        Iterator iterator;
        if (m == null) {
            this.map = new HashMap<String, Object>();
            return;
        }
        this.map = new HashMap<String, Object>(m.size());
        for (Map.Entry e : iterator.entrySet()) {
            void var3_3;
            void var2_2;
            if (e.getKey() == null) {
                throw new NullPointerException("Null key.");
            }
            Object value = e.getValue();
            if (value == null) continue;
            JSONObject.testValidity(value);
            this.map.put(String.valueOf(var2_2.getKey()), JSONObject.wrap(var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object bean) {
        this();
        void var1_1;
        this.populateMap(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject(Object bean, Set<Object> objectsRecord) {
        this();
        void var2_2;
        void var1_1;
        this.populateMap(var1_1, (Set<Object>)var2_2);
    }

    public JSONObject(Object object, String ... names) {
        this(names.length);
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                this.putOpt(name, c.getField(name).get(object));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String source) throws JSONException {
        this(new JSONTokener((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String baseName, Locale locale) throws JSONException {
        this();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, Thread.currentThread().getContextClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            void var3_3;
            String key = keys.nextElement();
            if (key == null) continue;
            String[] path = key.split("\\.");
            int last = path.length - 1;
            JSONObject target = this;
            for (int i = 0; i < last; ++i) {
                String segment = path[i];
                JSONObject nextTarget = target.optJSONObject(segment);
                if (nextTarget == null) {
                    nextTarget = new JSONObject();
                    target.put(segment, nextTarget);
                }
                target = nextTarget;
            }
            target.put(path[last], bundle.getString((String)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected JSONObject(int initialCapacity) {
        void var1_1;
        this.map = new HashMap<String, Object>((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            void var2_2;
            void var3_3;
            void var1_1;
            this.put((String)var1_1, new JSONArray().put(var3_3).put(var2_2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            void var2_2;
            void var3_3;
            this.put(key, ((JSONArray)var3_3).put(var2_2));
        } else {
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "JSONArray", null, null);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static String doubleToString(double d) {
        void var0_1;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object get(String key) throws JSONException {
        void var2_2;
        if (key == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key);
        if (object == null) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] not found.");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) throws JSONException {
        void var3_3;
        E val = this.optEnum(clazz, key);
        if (val == null) {
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException(key, "enum of type " + JSONObject.quote(var1_1.getSimpleName()), this.opt((String)var2_2), null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "Boolean", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger getBigInteger(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        BigInteger ret = JSONObject.objectToBigInteger(object, null);
        if (ret != null) {
            void var3_3;
            return var3_3;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "BigInteger", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getBigDecimal(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        BigDecimal ret = JSONObject.objectToBigDecimal(object, null);
        if (ret != null) {
            void var3_3;
            return var3_3;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "BigDecimal", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "double", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "float", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Number getNumber(String key) throws JSONException {
        Object object = this.get(key);
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            return JSONObject.stringToNumber(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "number", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "int", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "JSONArray", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "JSONObject", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONObject.wrongValueFormatException((String)var1_1, "long", var2_2, (Throwable)var3_3);
        }
    }

    public static String[] getNames(JSONObject jo) {
        JSONObject jSONObject;
        if (jo.isEmpty()) {
            return null;
        }
        return jo.keySet().toArray(new String[jSONObject.length()]);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getNames(Object object) {
        void var2_2;
        if (object == null) {
            return null;
        }
        Field[] fields = (object = object.getClass()).getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String key) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        throw JSONObject.wrongValueFormatException((String)var1_1, "string", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean has(String key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject increment(String key) throws JSONException {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof BigInteger) {
            this.put(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof Float) {
            this.put(key, ((Float)value).floatValue() + 1.0f);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof BigDecimal) {
            void var2_2;
            this.put(key, ((BigDecimal)var2_2).add(BigDecimal.ONE));
        } else {
            void var1_1;
            throw new JSONException("Unable to increment [" + JSONObject.quote((String)var1_1) + "].");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(String key) {
        void var1_1;
        return NULL.equals(this.opt((String)var1_1));
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    protected Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public int length() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JSONArray names() {
        if (this.map.isEmpty()) {
            return null;
        }
        return new JSONArray((Collection<?>)this.map.keySet());
    }

    public static String numberToString(Number number) throws JSONException {
        Object object;
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        Object string = number.toString();
        if (((String)string).indexOf(46) > 0 && ((String)string).indexOf(101) < 0 && ((String)string).indexOf(69) < 0) {
            while (((String)string).endsWith("0")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
            if (((String)string).endsWith(".")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(String key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.map.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key) {
        void var2_2;
        void var1_1;
        return this.optEnum((Class<E>)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key, E defaultValue) {
        try {
            void var2_2;
            void var1_1;
            Object val = this.opt(key);
            if (NULL.equals(val)) {
                return defaultValue;
            }
            if (((Class)clazz).isAssignableFrom(val.getClass())) {
                clazz = (Enum)val;
                return (E)clazz;
            }
            return (E)Enum.valueOf(var1_1, var2_2.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
        catch (NullPointerException nullPointerException) {
            void var3_3;
            return var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String key) {
        void var1_1;
        return this.optBoolean((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String key, boolean defaultValue) {
        Object val = this.opt(key);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            void var3_3;
            return (Boolean)var3_3;
        }
        try {
            void var1_1;
            return this.getBoolean((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean optBooleanObject(String key) {
        void var1_1;
        return this.optBooleanObject((String)var1_1, Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    public Boolean optBooleanObject(String key, Boolean defaultValue) {
        Object val = this.opt(key);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            void var3_3;
            return (boolean)((Boolean)var3_3);
        }
        try {
            void var1_1;
            return this.getBoolean((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal optBigDecimal(String key, BigDecimal defaultValue) {
        void var2_2;
        Object object;
        object = this.opt((String)object);
        return JSONObject.objectToBigDecimal(object, (BigDecimal)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static BigDecimal objectToBigDecimal(Object val, BigDecimal defaultValue) {
        void var1_1;
        return JSONObject.objectToBigDecimal(val, (BigDecimal)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    static BigDecimal objectToBigDecimal(Object val, BigDecimal defaultValue, boolean exact) {
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof BigInteger) {
            return new BigDecimal((BigInteger)val);
        }
        if (val instanceof Double || val instanceof Float) {
            void var2_2;
            if (!JSONObject.numberIsFinite((Number)val)) {
                return defaultValue;
            }
            if (var2_2 != false) {
                return new BigDecimal(((Number)val).doubleValue());
            }
            return new BigDecimal(val.toString());
        }
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            return new BigDecimal(((Number)val).longValue());
        }
        try {
            Object object;
            return new BigDecimal(object.toString());
        }
        catch (Exception exception) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger optBigInteger(String key, BigInteger defaultValue) {
        void var2_2;
        Object object;
        object = this.opt((String)object);
        return JSONObject.objectToBigInteger(object, (BigInteger)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static BigInteger objectToBigInteger(Object val, BigInteger defaultValue) {
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).toBigInteger();
        }
        if (val instanceof Double || val instanceof Float) {
            if (!JSONObject.numberIsFinite((Number)val)) {
                return defaultValue;
            }
            return new BigDecimal(((Number)val).doubleValue()).toBigInteger();
        }
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        try {
            Object object;
            Object valStr = val.toString();
            if (JSONObject.isDecimalNotation((String)valStr)) {
                return new BigDecimal((String)valStr).toBigInteger();
            }
            return new BigInteger((String)object);
        }
        catch (Exception exception) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String key) {
        void var1_1;
        return this.optDouble((String)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String key, double defaultValue) {
        void var1_1;
        Number val = this.optNumber(key);
        if (val == null) {
            void var2_2;
            return (double)var2_2;
        }
        return var1_1.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public Double optDoubleObject(String key) {
        void var1_1;
        return this.optDoubleObject((String)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public Double optDoubleObject(String key, Double defaultValue) {
        void var1_1;
        Number val = this.optNumber(key);
        if (val == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public float optFloat(String key) {
        void var1_1;
        return this.optFloat((String)var1_1, Float.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public float optFloat(String key, float defaultValue) {
        void var1_1;
        Number val = this.optNumber(key);
        if (val == null) {
            void var2_3;
            return (float)var2_3;
        }
        float f = var1_1.floatValue();
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public Float optFloatObject(String key) {
        void var1_1;
        return this.optFloatObject((String)var1_1, Float.valueOf(Float.NaN));
    }

    /*
     * WARNING - void declaration
     */
    public Float optFloatObject(String key, Float defaultValue) {
        Float f;
        Number val = this.optNumber(key);
        if (val == null) {
            void var2_2;
            return var2_2;
        }
        f = Float.valueOf(((Number)f).floatValue());
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String key) {
        void var1_1;
        return this.optInt((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String key, int defaultValue) {
        void var1_1;
        Number val = this.optNumber(key, null);
        if (val == null) {
            void var2_2;
            return (int)var2_2;
        }
        return var1_1.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public Integer optIntegerObject(String key) {
        void var1_1;
        return this.optIntegerObject((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public Integer optIntegerObject(String key, Integer defaultValue) {
        void var1_1;
        Number val = this.optNumber(key, null);
        if (val == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(String key) {
        void var1_1;
        return this.optJSONArray((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(String key, JSONArray defaultValue) {
        void var2_2;
        Object object = this.opt(key);
        if (object instanceof JSONArray) {
            void var1_1;
            return (JSONArray)var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(String key) {
        void var1_1;
        return this.optJSONObject((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(String key, JSONObject defaultValue) {
        void var2_2;
        Object object = this.opt(key);
        if (object instanceof JSONObject) {
            void var1_1;
            return (JSONObject)var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String key) {
        void var1_1;
        return this.optLong((String)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String key, long defaultValue) {
        void var1_1;
        Number val = this.optNumber(key, null);
        if (val == null) {
            void var2_2;
            return (long)var2_2;
        }
        return var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public Long optLongObject(String key) {
        void var1_1;
        return this.optLongObject((String)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public Long optLongObject(String key, Long defaultValue) {
        void var1_1;
        Number val = this.optNumber(key, null);
        if (val == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public Number optNumber(String key) {
        void var1_1;
        return this.optNumber((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public Number optNumber(String key, Number defaultValue) {
        Object val = this.opt(key);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        try {
            void var1_1;
            return JSONObject.stringToNumber(var1_1.toString());
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String key) {
        void var1_1;
        return this.optString((String)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String key, String defaultValue) {
        void var1_1;
        Object object = this.opt(key);
        if (NULL.equals(object)) {
            void var2_2;
            return var2_2;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void populateMap(Object bean) {
        void var1_1;
        this.populateMap(var1_1, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private void populateMap(Object bean, Set<Object> objectsRecord) {
        Method[] methodArray;
        Class<?> klass = bean.getClass();
        int n = klass.getClassLoader() != null ? 1 : 0;
        Method[] methodArray2 = n != 0 ? klass.getMethods() : methodArray.getDeclaredMethods();
        methodArray = methodArray2;
        methodArray = methodArray2;
        n = methodArray2.length;
        for (int i = 0; i < n; ++i) {
            String key;
            Method method = methodArray[i];
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.getParameterTypes().length != 0 || method.isBridge() || method.getReturnType() == Void.TYPE || !JSONObject.isValidMethodName(method.getName()) || (key = JSONObject.getKeyNameFromMethod(method)) == null || key.isEmpty()) continue;
            try {
                Object result = method.invoke(bean, new Object[0]);
                if (result == null) continue;
                if (objectsRecord.contains(result)) {
                    throw JSONObject.recursivelyDefinedObjectException(key);
                }
                objectsRecord.add(result);
                JSONObject.testValidity(result);
                this.map.put(key, JSONObject.wrap(result, objectsRecord));
                objectsRecord.remove(result);
                if (!(result instanceof Closeable)) continue;
                try {
                    ((Closeable)result).close();
                }
                catch (IOException iOException) {}
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private static boolean isValidMethodName(String name) {
        String string;
        return !"getClass".equals(name) && !"getDeclaringClass".equals(string);
    }

    /*
     * WARNING - void declaration
     */
    private static String getKeyNameFromMethod(Method method) {
        String string;
        String key;
        void var1_1;
        int forcedNameDepth;
        int ignoreDepth = JSONObject.getAnnotationDepth(method, JSONPropertyIgnore.class);
        if (ignoreDepth > 0 && ((forcedNameDepth = JSONObject.getAnnotationDepth(method, JSONPropertyName.class)) < 0 || var1_1 <= forcedNameDepth)) {
            return null;
        }
        JSONPropertyName annotation = JSONObject.getAnnotation(method, JSONPropertyName.class);
        if (annotation != null && annotation.value() != null && !annotation.value().isEmpty()) {
            void var2_3;
            return var2_3.value();
        }
        String name = method.getName();
        if (name.startsWith("get") && name.length() > 3) {
            key = name.substring(3);
        } else if (key.startsWith("is") && key.length() > 2) {
            key = key.substring(2);
        } else {
            return null;
        }
        if (key.length() == 0 || Character.isLowerCase(key.charAt(0))) {
            return null;
        }
        if (key.length() == 1) {
            key = key.toLowerCase(Locale.ROOT);
        } else if (!Character.isUpperCase(key.charAt(1))) {
            key = key.substring(0, 1).toLowerCase(Locale.ROOT) + key.substring(1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Annotation> A getAnnotation(Method m, Class<A> annotationClass) {
        if (m == null || annotationClass == null) {
            return null;
        }
        if (m.isAnnotationPresent(annotationClass)) {
            return m.getAnnotation(annotationClass);
        }
        Class<?> c = m.getDeclaringClass();
        if (c.getSuperclass() == null) {
            return null;
        }
        for (Class<?> i : c.getInterfaces()) {
            try {
                Method method = i.getMethod(m.getName(), m.getParameterTypes());
                return JSONObject.getAnnotation(method, annotationClass);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            void var1_1;
            Method method;
            void var2_2;
            return JSONObject.getAnnotation(var2_2.getSuperclass().getMethod(m.getName(), method.getParameterTypes()), var1_1);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int getAnnotationDepth(Method m, Class<? extends Annotation> annotationClass) {
        if (m == null || annotationClass == null) {
            return -1;
        }
        if (m.isAnnotationPresent(annotationClass)) {
            return 1;
        }
        Class<?> c = m.getDeclaringClass();
        if (c.getSuperclass() == null) {
            return -1;
        }
        for (GenericDeclaration i : c.getInterfaces()) {
            try {
                i = i.getMethod(m.getName(), m.getParameterTypes());
                int d = JSONObject.getAnnotationDepth((Method)i, annotationClass);
                if (d <= 0) continue;
                return d + 1;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            void var1_1;
            Method method;
            void var2_2;
            int d = JSONObject.getAnnotationDepth(var2_2.getSuperclass().getMethod(m.getName(), method.getParameterTypes()), (Class<? extends Annotation>)var1_1);
            if (d > 0) {
                void var3_4;
                return (int)(var3_4 + true);
            }
            return -1;
        }
        catch (SecurityException securityException) {
            return -1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, var2_2 != false ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Collection<?> value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, new JSONArray((Collection<?>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, double value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, (Object)((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, float value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, Float.valueOf((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, int value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, (Object)((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, long value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, (Object)((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Map<?, ?> value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, new JSONObject((Map<?, ?>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            void var2_2;
            JSONObject.testValidity(value);
            this.map.put(key, var2_2);
        } else {
            void var1_1;
            this.remove((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            void var2_2;
            void var1_1;
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            return this.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            void var2_2;
            void var1_1;
            return this.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Object query(String jsonPointer) {
        void var1_1;
        return this.query(new JSONPointer((String)var1_1));
    }

    public Object query(JSONPointer jsonPointer) {
        return jsonPointer.queryFrom(this);
    }

    /*
     * WARNING - void declaration
     */
    public Object optQuery(String jsonPointer) {
        void var1_1;
        return this.optQuery(new JSONPointer((String)var1_1));
    }

    public Object optQuery(JSONPointer jsonPointer) {
        try {
            return jsonPointer.queryFrom(this);
        }
        catch (JSONPointerException jSONPointerException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        try {
            void var1_1;
            String string2;
            return JSONObject.quote(string2, (Writer)var1_1).toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Writer quote(String string, Writer w) throws IOException {
        void var1_1;
        if (string == null || string.isEmpty()) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    void var2_6;
                    if (c >= ' ' && (c < '\u0080' || c >= '\u00a0') && (c < '\u2000' || c >= '\u2100')) break;
                    w.write("\\u");
                    String hhhh = Integer.toHexString(c);
                    w.write("0000", 0, 4 - hhhh.length());
                    w.write((String)var2_6);
                    continue block9;
                }
            }
            w.write(c);
        }
        w.write(34);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(String key) {
        void var1_1;
        return this.map.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean similar(Object other) {
        if (!(other instanceof JSONObject)) {
            return false;
        }
        try {
            if (!this.keySet().equals(((JSONObject)other).keySet())) {
                return false;
            }
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                void var3_3;
                Object valueOther;
                String name = entry.getKey();
                Object valueThis = entry.getValue();
                if (valueThis == (valueOther = ((JSONObject)other).get(name))) continue;
                if (valueThis == null) {
                    return false;
                }
                if (!(valueThis instanceof JSONObject ? !((JSONObject)valueThis).similar(valueOther) : (valueThis instanceof JSONArray ? !((JSONArray)valueThis).similar(valueOther) : (valueThis instanceof Number && valueOther instanceof Number ? !JSONObject.isNumberSimilar((Number)valueThis, (Number)valueOther) : (valueThis instanceof JSONString && valueOther instanceof JSONString ? !((JSONString)valueThis).toJSONString().equals(((JSONString)valueOther).toJSONString()) : !var3_3.equals(valueOther)))))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean isNumberSimilar(Number l22, Number r) {
        void var1_2;
        Number number;
        Number l22;
        if (!JSONObject.numberIsFinite(l22) || !JSONObject.numberIsFinite(r)) {
            return false;
        }
        if (l22.getClass().equals(r.getClass()) && l22 instanceof Comparable) {
            int l22 = ((Comparable)((Object)l22)).compareTo(r);
            return l22 == 0;
        }
        Number lBigDecimal = JSONObject.objectToBigDecimal(l22, null, false);
        BigDecimal rBigDecimal = JSONObject.objectToBigDecimal(r, null, false);
        if (lBigDecimal == null || rBigDecimal == null) {
            return false;
        }
        return ((BigDecimal)number).compareTo((BigDecimal)var1_2) == 0;
    }

    private static boolean numberIsFinite(Number n) {
        Number number;
        if (n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            return false;
        }
        return !(n instanceof Float) || !((Float)n).isInfinite() && !((Float)number).isNaN();
    }

    protected static boolean isDecimalNotation(String val) {
        String string;
        return val.indexOf(46) >= 0 || val.indexOf(101) >= 0 || val.indexOf(69) >= 0 || "-0".equals(string);
    }

    /*
     * WARNING - void declaration
     */
    protected static Number stringToNumber(String input) throws NumberFormatException {
        String string;
        char initial;
        String val = input;
        if (val.startsWith(".")) {
            val = "0" + val;
        }
        if (val.startsWith("-.")) {
            val = "-0." + val.substring(2);
        }
        if ((initial = val.charAt(0)) >= '0' && initial <= '9' || initial == '-') {
            void var3_6;
            void var1_1;
            BigInteger bi;
            char at1;
            if (JSONObject.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double d = Double.valueOf(val);
                        if (d.isNaN() || d.isInfinite()) {
                            throw new NumberFormatException("val [" + input + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new NumberFormatException("val [" + input + "] is not a valid number.");
                    }
                }
            }
            val = JSONObject.removeLeadingZerosOfNumber(input);
            char d = val.charAt(0);
            if (d == '0' && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new NumberFormatException("val [" + input + "] is not a valid number.");
                }
            } else if (d == '-' && val.length() > 2) {
                void var2_2;
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && var2_2 <= 57) {
                    throw new NumberFormatException("val [" + input + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger((String)var1_1)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return var3_6;
        }
        throw new NumberFormatException("val [" + string + "] is not a valid number.");
    }

    public static Object stringToValue(String string) {
        String string2;
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return NULL;
        }
        if (JSONObject.potentialNumber(string)) {
            try {
                return JSONObject.stringToNumber(string);
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    private static boolean potentialNumber(String value) {
        String string;
        if (value == null || value.isEmpty()) {
            return false;
        }
        String string2 = string;
        return JSONObject.potentialPositiveNumberStartingAtIndex(string2, string2.charAt(0) == '-' ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean potentialPositiveNumberStartingAtIndex(String value, int index) {
        void var1_1;
        String string;
        if (index >= value.length()) {
            return false;
        }
        String string2 = string;
        return JSONObject.digitAtIndex(string2, string2.charAt(index) == '.' ? index + 1 : var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean digitAtIndex(String value, int index) {
        void var1_1;
        String string;
        if (index >= value.length()) {
            return false;
        }
        return value.charAt(index) >= '0' && string.charAt((int)var1_1) <= '9';
    }

    public static void testValidity(Object o) throws JSONException {
        Object object;
        if (o instanceof Number && !JSONObject.numberIsFinite((Number)object)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        void var2_2;
        if (names == null || names.isEmpty()) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return var2_2;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentFactor) throws JSONException {
        void var1_1;
        void var2_2;
        StringWriter w = new StringWriter();
        return this.write((Writer)var2_2, (int)var1_1, 0).toString();
    }

    public static String valueToString(Object value) throws JSONException {
        return JSONWriter.valueToString(value);
    }

    public static Object wrap(Object object) {
        return JSONObject.wrap(object, null);
    }

    /*
     * WARNING - void declaration
     */
    private static Object wrap(Object object, Set<Object> objectsRecord) {
        try {
            Object object2;
            void var2_4;
            if (NULL.equals(object)) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal || object instanceof Enum) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new JSONArray(coll);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JSONObject(map);
            }
            Package objectPackage = object.getClass().getPackage();
            String objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || var2_4.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            if (objectsRecord != null) {
                void var1_1;
                return new JSONObject(object, (Set<Object>)var1_1);
            }
            return new JSONObject(object2);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            throw jSONException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer) throws JSONException {
        void var1_1;
        return this.write((Writer)var1_1, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        Writer writer2;
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                void var0_1;
                throw new JSONException((Throwable)var0_1);
            }
            writer2.write(o != null ? o.toString() : JSONObject.quote(value.toString()));
        } else if (value instanceof Number) {
            String numberAsString = JSONObject.numberToString((Number)value);
            if (NUMBER_PATTERN.matcher(numberAsString).matches()) {
                writer2.write(numberAsString);
            } else {
                JSONObject.quote(numberAsString, writer2);
            }
        } else if (value instanceof Boolean) {
            writer2.write(value.toString());
        } else if (value instanceof Enum) {
            writer2.write(JSONObject.quote(((Enum)value).name()));
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer2, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer2, indentFactor, indent);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            new JSONObject(map).write(writer2, indentFactor, indent);
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            new JSONArray(coll).write(writer2, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            void var3_4;
            void var2_3;
            new JSONArray(value).write(writer2, (int)var2_3, (int)var3_4);
        } else {
            void var1_2;
            JSONObject.quote(var1_2.toString(), writer2);
        }
        return writer2;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            void var1_1;
            void entry2;
            boolean needsComma = false;
            int length = this.length();
            writer.write(123);
            if (length == 1) {
                Map.Entry<String, Object> entry2 = this.entrySet().iterator().next();
                String key = entry2.getKey();
                writer.write(JSONObject.quote(key));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                try {
                    JSONObject.writeValue(writer, entry2.getValue(), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONObject value for key: " + key, e);
                }
            }
            if (entry2 != false) {
                void var3_4;
                void var2_3;
                int newIndent = indent + indentFactor;
                for (Map.Entry<String, Object> entry3 : this.entrySet()) {
                    if (needsComma) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newIndent);
                    String key22 = entry3.getKey();
                    writer.write(JSONObject.quote(key22));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    try {
                        JSONObject.writeValue(writer, entry3.getValue(), indentFactor, newIndent);
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new JSONException("Unable to write JSONObject value for key: " + key22, (Throwable)var1_2);
                    }
                    boolean key22 = true;
                }
                if (var2_3 > 0) {
                    var1_1.write(10);
                }
                JSONObject.indent((Writer)var1_1, (int)var3_4);
            }
            var1_1.write(125);
            return var1_1;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> toMap() {
        void var1_1;
        HashMap results = new HashMap();
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            void var3_3;
            Object value = entry.getValue() == null || NULL.equals(entry.getValue()) ? null : (entry.getValue() instanceof JSONObject ? ((JSONObject)entry.getValue()).toMap() : (entry.getValue() instanceof JSONArray ? ((JSONArray)entry.getValue()).toList() : entry.getValue()));
            results.put(var3_3.getKey(), (Map<String, Object>)value);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static JSONException wrongValueFormatException(String key, String valueType, Object value, Throwable cause) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (value == null) {
            return new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a " + valueType + " (null).", cause);
        }
        if (value instanceof Map || value instanceof Iterable || value instanceof JSONObject) {
            return new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a " + valueType + " (" + value.getClass() + ").", cause);
        }
        return new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a " + (String)var1_1 + " (" + value.getClass() + " : " + var2_2 + ").", (Throwable)var3_3);
    }

    private static JSONException recursivelyDefinedObjectException(String key) {
        String string;
        return new JSONException("JavaBean object contains recursively defined member variable of key " + JSONObject.quote(string));
    }

    /*
     * WARNING - void declaration
     */
    private static String removeLeadingZerosOfNumber(String value) {
        void var1_1;
        int counter;
        if (value.equals("-")) {
            return value;
        }
        boolean negativeFirstChar = value.charAt(0) == '-';
        int n = counter = negativeFirstChar ? 1 : 0;
        while (counter < value.length()) {
            if (value.charAt(counter) != '0') {
                if (negativeFirstChar) {
                    return "-".concat(value.substring(counter));
                }
                return value.substring(counter);
            }
            ++counter;
        }
        if (var1_1 != false) {
            return "-0";
        }
        return "0";
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object object) {
            void var1_1;
            return object == null || var1_1 == this;
        }

        public final int hashCode() {
            return 0;
        }

        public final String toString() {
            return "null";
        }
    }
}

