/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONPointer;
import org.json.JSONPointerException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONArray
implements Iterable<Object> {
    private final ArrayList<Object> myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        char nextChar = x.nextClean();
        if (nextChar == '\u0000') {
            throw x.syntaxError("Expected a ',' or ']'");
        }
        if (nextChar != ']') {
            void var1_1;
            x.back();
            block5: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.myArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case '\u0000': {
                        throw x.syntaxError("Expected a ',' or ']'");
                    }
                    case ',': {
                        void var2_2;
                        nextChar = x.nextClean();
                        if (nextChar == '\u0000') {
                            throw x.syntaxError("Expected a ',' or ']'");
                        }
                        if (var2_2 == 93) {
                            return;
                        }
                        x.back();
                        continue block5;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw var1_1.syntaxError("Expected a ',' or ']'");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(String source) throws JSONException {
        this(new JSONTokener((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Collection<?> collection) {
        void var1_1;
        if (collection == null) {
            this.myArrayList = new ArrayList();
            return;
        }
        this.myArrayList = new ArrayList(collection.size());
        this.addAll((Collection<?>)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Iterable<?> iter) {
        this();
        void var1_1;
        if (iter == null) {
            return;
        }
        this.addAll((Iterable<?>)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(JSONArray array) {
        void var1_1;
        if (array == null) {
            this.myArrayList = new ArrayList();
            return;
        }
        this.myArrayList = new ArrayList<Object>(var1_1.myArrayList);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object array) throws JSONException {
        this();
        void var1_1;
        if (!array.getClass().isArray()) {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
        this.addAll(var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(int initialCapacity) throws JSONException {
        void var1_1;
        if (initialCapacity < 0) {
            throw new JSONException("JSONArray initial capacity cannot be negative.");
        }
        this.myArrayList = new ArrayList((int)var1_1);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.myArrayList.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public Object get(int index) throws JSONException {
        void var2_2;
        Object object = this.opt(index);
        if (object == null) {
            void var1_1;
            throw new JSONException("JSONArray[" + (int)var1_1 + "] not found.");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int index) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(index);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw JSONArray.wrongValueFormatException((int)var1_1, "boolean", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "double", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "float", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Number getNumber(int index) throws JSONException {
        Object object = this.get(index);
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            return JSONObject.stringToNumber(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "number", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E getEnum(Class<E> clazz, int index) throws JSONException {
        void var3_3;
        E val = this.optEnum(clazz, index);
        if (val == null) {
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException(index, "enum of type " + JSONObject.quote(var1_1.getSimpleName()), this.opt((int)var2_2), null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getBigDecimal(int index) throws JSONException {
        void var3_3;
        Object object = this.get(index);
        BigDecimal val = JSONObject.objectToBigDecimal(object, null);
        if (val == null) {
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "BigDecimal", var2_2, null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger getBigInteger(int index) throws JSONException {
        void var3_3;
        Object object = this.get(index);
        BigInteger val = JSONObject.objectToBigInteger(object, null);
        if (val == null) {
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "BigInteger", var2_2, null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "int", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(int index) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONArray.wrongValueFormatException((int)var1_1, "JSONArray", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(int index) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONArray.wrongValueFormatException((int)var1_1, "JSONObject", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception e) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw JSONArray.wrongValueFormatException((int)var1_1, "long", var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getString(int index) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.get(index);
        if (object instanceof String) {
            return (String)object;
        }
        throw JSONArray.wrongValueFormatException((int)var1_1, "String", var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(int index) {
        void var1_1;
        return JSONObject.NULL.equals(this.opt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String join(String separator) throws JSONException {
        void var3_3;
        int len = this.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(JSONObject.valueToString(this.myArrayList.get(0)));
        for (int i = 1; i < len; ++i) {
            sb.append(separator).append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return var3_3.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public void clear() {
        this.myArrayList.clear();
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(int index) {
        void var1_1;
        if (index < 0 || index >= this.length()) {
            return null;
        }
        return this.myArrayList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index) {
        void var1_1;
        return this.optBoolean((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            void var1_1;
            return this.getBoolean((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean optBooleanObject(int index) {
        void var1_1;
        return this.optBooleanObject((int)var1_1, Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    public Boolean optBooleanObject(int index, Boolean defaultValue) {
        try {
            void var1_1;
            return this.getBoolean((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index) {
        void var1_1;
        return this.optDouble((int)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index, double defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return (double)var2_3;
        }
        double d = var1_2.doubleValue();
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public Double optDoubleObject(int index) {
        void var1_1;
        return this.optDoubleObject((int)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public Double optDoubleObject(int index, Double defaultValue) {
        Double d;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return var2_3;
        }
        d = (double)d;
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public float optFloat(int index) {
        void var1_1;
        return this.optFloat((int)var1_1, Float.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public float optFloat(int index, float defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_4;
            return (float)var2_4;
        }
        float f = var1_2.floatValue();
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public Float optFloatObject(int index) {
        void var1_1;
        return this.optFloatObject((int)var1_1, Float.valueOf(Float.NaN));
    }

    /*
     * WARNING - void declaration
     */
    public Float optFloatObject(int index, Float defaultValue) {
        Float f;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return var2_3;
        }
        f = Float.valueOf(((Number)f).floatValue());
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index) {
        void var1_1;
        return this.optInt((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index, int defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return (int)var2_3;
        }
        return var1_2.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public Integer optIntegerObject(int index) {
        void var1_1;
        return this.optIntegerObject((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public Integer optIntegerObject(int index, Integer defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return var2_3;
        }
        return var1_2.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E optEnum(Class<E> clazz, int index) {
        void var2_2;
        void var1_1;
        return this.optEnum((Class<E>)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Enum<E>> E optEnum(Class<E> clazz, int index, E defaultValue) {
        try {
            void var2_3;
            void var1_1;
            Object val = this.opt(index);
            if (JSONObject.NULL.equals(val)) {
                return defaultValue;
            }
            if (((Class)clazz).isAssignableFrom(val.getClass())) {
                clazz = (Enum)val;
                return (E)clazz;
            }
            return (E)Enum.valueOf(var1_1, var2_3.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
        catch (NullPointerException nullPointerException) {
            void var3_4;
            return var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger optBigInteger(int index, BigInteger defaultValue) {
        void var2_3;
        void var1_1;
        Object object = this.opt((int)var1_1);
        return JSONObject.objectToBigInteger(object, (BigInteger)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal optBigDecimal(int index, BigDecimal defaultValue) {
        void var2_3;
        void var1_1;
        Object object = this.opt((int)var1_1);
        return JSONObject.objectToBigDecimal(object, (BigDecimal)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(int index) {
        void var1_1;
        return this.optJSONArray((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(int index, JSONArray defaultValue) {
        void var2_3;
        Object object = this.opt(index);
        if (object instanceof JSONArray) {
            void var1_2;
            return (JSONArray)var1_2;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(int index) {
        void var1_1;
        return this.optJSONObject((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(int index, JSONObject defaultValue) {
        void var2_3;
        Object object = this.opt(index);
        if (object instanceof JSONObject) {
            void var1_2;
            return (JSONObject)var1_2;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index) {
        void var1_1;
        return this.optLong((int)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index, long defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return (long)var2_3;
        }
        return var1_2.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public Long optLongObject(int index) {
        void var1_1;
        return this.optLongObject((int)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public Long optLongObject(int index, Long defaultValue) {
        void var1_2;
        Number val = this.optNumber(index, null);
        if (val == null) {
            void var2_3;
            return var2_3;
        }
        return var1_2.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public Number optNumber(int index) {
        void var1_1;
        return this.optNumber((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public Number optNumber(int index, Number defaultValue) {
        void var2_3;
        Object val = this.opt(index);
        if (JSONObject.NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        if (val instanceof String) {
            try {
                void var1_2;
                return JSONObject.stringToNumber((String)var1_2);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index) {
        void var1_1;
        return this.optString((int)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index, String defaultValue) {
        void var1_2;
        Object object = this.opt(index);
        if (JSONObject.NULL.equals(object)) {
            void var2_3;
            return var2_3;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(boolean value) {
        void var1_1;
        return this.put(var1_1 != false ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Collection<?> value) {
        void var1_1;
        return this.put(new JSONArray((Collection<?>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(double value) throws JSONException {
        void var1_1;
        return this.put((Object)((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(float value) throws JSONException {
        void var1_1;
        return this.put(Float.valueOf((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int value) {
        void var1_1;
        return this.put((Object)((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(long value) {
        void var1_1;
        return this.put((Object)((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Map<?, ?> value) {
        void var1_1;
        return this.put(new JSONObject((Map<?, ?>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Object value) {
        void var1_1;
        JSONObject.testValidity(value);
        this.myArrayList.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, var2_2 != false ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Collection<?> value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, new JSONArray((Collection<?>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, double value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, float value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, Float.valueOf((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, int value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, long value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Map<?, ?> value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new JSONObject((Map<?, ?>)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Object value) throws JSONException {
        void var2_2;
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            JSONObject.testValidity(value);
            this.myArrayList.set(index, value);
            return this;
        }
        if (index == this.length()) {
            return this.put(value);
        }
        this.myArrayList.ensureCapacity(index + 1);
        while (index != this.length()) {
            this.myArrayList.add(JSONObject.NULL);
        }
        return this.put(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray putAll(Collection<?> collection) {
        void var1_1;
        this.addAll((Collection<?>)var1_1, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray putAll(Iterable<?> iter) {
        void var1_1;
        this.addAll((Iterable<?>)var1_1, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray putAll(JSONArray array) {
        void var1_1;
        this.myArrayList.addAll(var1_1.myArrayList);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray putAll(Object array) throws JSONException {
        void var1_1;
        this.addAll(var1_1, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Object query(String jsonPointer) {
        void var1_1;
        return this.query(new JSONPointer((String)var1_1));
    }

    public Object query(JSONPointer jsonPointer) {
        return jsonPointer.queryFrom(this);
    }

    /*
     * WARNING - void declaration
     */
    public Object optQuery(String jsonPointer) {
        void var1_1;
        return this.optQuery(new JSONPointer((String)var1_1));
    }

    public Object optQuery(JSONPointer jsonPointer) {
        try {
            return jsonPointer.queryFrom(this);
        }
        catch (JSONPointerException jSONPointerException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(int index) {
        if (index >= 0 && index < this.length()) {
            void var1_1;
            return this.myArrayList.remove((int)var1_1);
        }
        return null;
    }

    public boolean similar(Object other) {
        if (!(other instanceof JSONArray)) {
            return false;
        }
        int len = this.length();
        if (len != ((JSONArray)other).length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Object valueOther;
            Object valueThis = this.myArrayList.get(i);
            if (valueThis == (valueOther = ((JSONArray)other).myArrayList.get(i))) continue;
            if (valueThis == null) {
                return false;
            }
            if (!(valueThis instanceof JSONObject ? !((JSONObject)valueThis).similar(valueOther) : (valueThis instanceof JSONArray ? !((JSONArray)valueThis).similar(valueOther) : (valueThis instanceof Number && valueOther instanceof Number ? !JSONObject.isNumberSimilar((Number)valueThis, (Number)valueOther) : (valueThis instanceof JSONString && valueOther instanceof JSONString ? !((JSONString)valueThis).toJSONString().equals(((JSONString)valueOther).toJSONString()) : !valueThis.equals(valueOther)))))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        void var2_2;
        if (names == null || names.isEmpty() || this.isEmpty()) {
            return null;
        }
        JSONObject jo = new JSONObject(names.length());
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return var2_2;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentFactor) throws JSONException {
        void var1_1;
        void var2_2;
        StringWriter sw = new StringWriter();
        return this.write((Writer)var2_2, (int)var1_1, 0).toString();
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer) throws JSONException {
        void var1_1;
        return this.write((Writer)var1_1, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            void var1_1;
            boolean needsComma = false;
            int length = this.length();
            writer.write(91);
            if (length == 1) {
                try {
                    JSONObject.writeValue(writer, this.myArrayList.get(0), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONArray value at index: 0", e);
                }
            }
            if (length != 0) {
                void var3_4;
                void var2_3;
                int newIndent = indent + indentFactor;
                for (int i = 0; i < length; ++i) {
                    if (needsComma) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newIndent);
                    try {
                        JSONObject.writeValue(writer, this.myArrayList.get(i), indentFactor, newIndent);
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new JSONException("Unable to write JSONArray value at index: " + i, (Throwable)var1_2);
                    }
                    needsComma = true;
                }
                if (var2_3 > 0) {
                    var1_1.write(10);
                }
                JSONObject.indent((Writer)var1_1, (int)var3_4);
            }
            var1_1.write(93);
            return var1_1;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> toList() {
        void var1_1;
        ArrayList<Object> results = new ArrayList<Object>(this.myArrayList.size());
        for (Object element : this.myArrayList) {
            void var3_3;
            if (element == null || JSONObject.NULL.equals(element)) {
                results.add(null);
                continue;
            }
            if (element instanceof JSONArray) {
                results.add(((JSONArray)element).toList());
                continue;
            }
            if (element instanceof JSONObject) {
                results.add(((JSONObject)element).toMap());
                continue;
            }
            results.add(var3_3);
        }
        return var1_1;
    }

    public boolean isEmpty() {
        return this.myArrayList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void addAll(Collection<?> collection, boolean wrap) {
        Iterator iterator;
        this.myArrayList.ensureCapacity(this.myArrayList.size() + collection.size());
        if (wrap) {
            collection = collection.iterator();
            while (collection.hasNext()) {
                Object o = collection.next();
                this.put(JSONObject.wrap(o));
            }
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_4;
            Object o = iterator.next();
            this.put(var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addAll(Iterable<?> iter, boolean wrap) {
        Iterator iterator;
        if (wrap) {
            iter = iter.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                this.put(JSONObject.wrap(o));
            }
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_4;
            Object o = iterator.next();
            this.put(var2_4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void addAll(Object array, boolean wrap) throws JSONException {
        void var2_2;
        if (array.getClass().isArray()) {
            int i;
            int length = Array.getLength(array);
            this.myArrayList.ensureCapacity(this.myArrayList.size() + length);
            if (wrap) {
                i = 0;
                while (true) {
                    if (i >= length) {
                        return;
                    }
                    this.put(JSONObject.wrap(Array.get(array, i)));
                    ++i;
                }
            }
            i = 0;
            while (true) {
                if (i >= length) {
                    return;
                }
                this.put(Array.get(array, i));
                ++i;
            }
        }
        if (array instanceof JSONArray) {
            this.myArrayList.addAll(((JSONArray)array).myArrayList);
            return;
        }
        if (array instanceof Collection) {
            this.addAll((Collection)array, (boolean)var2_2);
            return;
        }
        if (array instanceof Iterable) {
            void var1_1;
            this.addAll((Iterable)var1_1, (boolean)var2_2);
            return;
        }
        throw new JSONException("JSONArray initial value should be a string or collection or array.");
    }

    /*
     * WARNING - void declaration
     */
    private static JSONException wrongValueFormatException(int idx, String valueType, Object value, Throwable cause) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        if (value == null) {
            return new JSONException("JSONArray[" + idx + "] is not a " + valueType + " (null).", cause);
        }
        if (value instanceof Map || value instanceof Iterable || value instanceof JSONObject) {
            return new JSONException("JSONArray[" + idx + "] is not a " + valueType + " (" + value.getClass() + ").", cause);
        }
        return new JSONException("JSONArray[" + n + "] is not a " + (String)var1_1 + " (" + value.getClass() + " : " + var2_2 + ").", (Throwable)var3_3);
    }
}

