/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public class DefaultLoggingEventBuilder
implements CallerBoundaryAware,
LoggingEventBuilder {
    static String DLEB_FQCN = DefaultLoggingEventBuilder.class.getName();
    protected DefaultLoggingEvent loggingEvent;
    protected Logger logger;

    /*
     * WARNING - void declaration
     */
    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        void var1_1;
        void var2_2;
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent((Level)var2_2, (Logger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        void var1_1;
        this.loggingEvent.addMarker((Marker)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder setCause(Throwable t) {
        void var1_1;
        this.loggingEvent.setThrowable((Throwable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder addArgument(Object p) {
        void var1_1;
        this.loggingEvent.addArgument(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        void var1_1;
        this.loggingEvent.addArgument(var1_1.get());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder addKeyValue(String key, Object value) {
        void var2_2;
        void var1_1;
        this.loggingEvent.addKeyValue((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> value) {
        void var2_2;
        void var1_1;
        this.loggingEvent.addKeyValue((String)var1_1, var2_2.get());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCallerBoundary(String fqcn) {
        void var1_1;
        this.loggingEvent.setCallerBoundary((String)var1_1);
    }

    @Override
    public void log() {
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder setMessage(String message) {
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1.get());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message) {
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object arg) {
        void var2_2;
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1);
        this.loggingEvent.addArgument(var2_2);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object arg0, Object arg1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1);
        this.loggingEvent.addArgument(var2_2);
        this.loggingEvent.addArgument(var3_3);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object ... args) {
        void var2_2;
        void var1_1;
        this.loggingEvent.setMessage((String)var1_1);
        this.loggingEvent.addArguments((Object[])var2_2);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<String> messageSupplier) {
        void var1_1;
        if (messageSupplier == null) {
            this.log((String)null);
            return;
        }
        this.log((String)var1_1.get());
    }

    /*
     * WARNING - void declaration
     */
    protected void log(LoggingEvent aLoggingEvent) {
        void var1_1;
        if (aLoggingEvent.getCallerBoundary() == null) {
            this.setCallerBoundary(DLEB_FQCN);
        }
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(aLoggingEvent);
            return;
        }
        if (this.logger instanceof LocationAwareLogger) {
            DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
            defaultLoggingEventBuilder.logViaLocationAwareLoggerAPI((LocationAwareLogger)defaultLoggingEventBuilder.logger, aLoggingEvent);
            return;
        }
        this.logViaPublicSLF4JLoggerAPI((LoggingEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logViaLocationAwareLoggerAPI(LocationAwareLogger locationAwareLogger, LoggingEvent aLoggingEvent) {
        void var2_2;
        void var3_3;
        void var1_1;
        aLoggingEvent.getMessage();
        aLoggingEvent.getMarkers();
        String mergedMessage = this.mergeMarkersAndKeyValuePairsAndMessage(aLoggingEvent);
        var1_1.log(null, aLoggingEvent.getCallerBoundary(), aLoggingEvent.getLevel().toInt(), (String)var3_3, aLoggingEvent.getArgumentArray(), var2_2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    private void logViaPublicSLF4JLoggerAPI(LoggingEvent aLoggingEvent) {
        void var1_1;
        Object[] argArray = aLoggingEvent.getArgumentArray();
        int argLen = argArray == null ? 0 : argArray.length;
        Throwable t = aLoggingEvent.getThrowable();
        int tLen = t == null ? 0 : 1;
        Object[] combinedArguments = new Object[argLen + tLen];
        if (argArray != null) {
            System.arraycopy(argArray, 0, combinedArguments, 0, argLen);
        }
        if (t != null) {
            combinedArguments[var3_3] = t;
        }
        String mergedMessage = this.mergeMarkersAndKeyValuePairsAndMessage(aLoggingEvent);
        switch (var1_1.getLevel()) {
            case TRACE: {
                this.logger.trace(mergedMessage, combinedArguments);
                return;
            }
            case DEBUG: {
                this.logger.debug(mergedMessage, combinedArguments);
                return;
            }
            case INFO: {
                this.logger.info(mergedMessage, combinedArguments);
                return;
            }
            case WARN: {
                this.logger.warn(mergedMessage, combinedArguments);
                return;
            }
            case ERROR: {
                void var2_2;
                this.logger.error((String)var2_2, combinedArguments);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String mergeMarkersAndKeyValuePairsAndMessage(LoggingEvent aLoggingEvent) {
        void var2_2;
        String string;
        StringBuilder sb = this.mergeMarkers(aLoggingEvent.getMarkers(), null);
        sb = this.mergeKeyValuePairs(aLoggingEvent.getKeyValuePairs(), sb);
        string = this.mergeMessage(string.getMessage(), (StringBuilder)var2_2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder mergeMarkers(List<Marker> markerList, StringBuilder sb) {
        void var2_2;
        Iterator iterator;
        if (markerList == null || markerList.isEmpty()) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Marker marker = (Marker)iterator.next();
            sb.append(var3_3);
            sb.append(' ');
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder mergeKeyValuePairs(List<KeyValuePair> keyValuePairList, StringBuilder sb) {
        void var2_2;
        Iterator iterator;
        if (keyValuePairList == null || keyValuePairList.isEmpty()) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            sb.append(kvp.key);
            sb.append('=');
            sb.append(var3_3.value);
            sb.append(' ');
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String mergeMessage(String msg, StringBuilder sb) {
        void var1_1;
        if (sb != null) {
            void var2_2;
            sb.append(msg);
            return var2_2.toString();
        }
        return var1_1;
    }
}

