/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOP_FallbackServiceProvider;
import org.slf4j.helpers.Reporter;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.slf4j.helpers.Util;
import org.slf4j.spi.SLF4JServiceProvider;

public final class LoggerFactory {
    static final String CODES_PREFIX = "https://www.slf4j.org/codes.html";
    static final String NO_PROVIDERS_URL = "https://www.slf4j.org/codes.html#noProviders";
    static final String IGNORED_BINDINGS_URL = "https://www.slf4j.org/codes.html#ignoredBindings";
    static final String MULTIPLE_BINDINGS_URL = "https://www.slf4j.org/codes.html#multiple_bindings";
    static final String VERSION_MISMATCH = "https://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "https://www.slf4j.org/codes.html#substituteLogger";
    static final String LOGGER_NAME_MISMATCH_URL = "https://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String REPLAY_URL = "https://www.slf4j.org/codes.html#replay";
    static final String UNSUCCESSFUL_INIT_URL = "https://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also https://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String CONNECTED_WITH_MSG = "Connected with provider of type [";
    public static final String PROVIDER_PROPERTY_KEY = "slf4j.provider";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITIALIZATION = 1;
    static final int FAILED_INITIALIZATION = 2;
    static final int SUCCESSFUL_INITIALIZATION = 3;
    static final int NOP_FALLBACK_INITIALIZATION = 4;
    static volatile int INITIALIZATION_STATE = 0;
    static final SubstituteServiceProvider SUBST_PROVIDER = new SubstituteServiceProvider();
    static final NOP_FallbackServiceProvider NOP_FALLBACK_SERVICE_PROVIDER = new NOP_FallbackServiceProvider();
    static final String DETECT_LOGGER_NAME_MISMATCH_PROPERTY = "slf4j.detectLoggerNameMismatch";
    static final String JAVA_VENDOR_PROPERTY = "java.vendor.url";
    static boolean DETECT_LOGGER_NAME_MISMATCH = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    static volatile SLF4JServiceProvider PROVIDER;
    private static final String[] API_COMPATIBILITY_LIST;
    private static final String STATIC_LOGGER_BINDER_PATH = "org/slf4j/impl/StaticLoggerBinder.class";

    /*
     * WARNING - void declaration
     */
    static List<SLF4JServiceProvider> findServiceProviders() {
        void var0;
        ArrayList<SLF4JServiceProvider> providerList = new ArrayList<SLF4JServiceProvider>();
        Object classLoaderOfLoggerFactory = LoggerFactory.class.getClassLoader();
        SLF4JServiceProvider explicitProvider = LoggerFactory.loadExplicitlySpecified((ClassLoader)classLoaderOfLoggerFactory);
        if (explicitProvider != null) {
            void var2_2;
            providerList.add((SLF4JServiceProvider)var2_2);
            return providerList;
        }
        classLoaderOfLoggerFactory = LoggerFactory.getServiceLoader((ClassLoader)classLoaderOfLoggerFactory);
        Iterator<SLF4JServiceProvider> iterator = ((ServiceLoader)classLoaderOfLoggerFactory).iterator();
        while (iterator.hasNext()) {
            LoggerFactory.safelyInstantiate(providerList, iterator);
        }
        return var0;
    }

    private static ServiceLoader<SLF4JServiceProvider> getServiceLoader(ClassLoader classLoaderOfLoggerFactory) {
        Object object;
        Object serviceLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            serviceLoader = ServiceLoader.load(SLF4JServiceProvider.class, classLoaderOfLoggerFactory);
        } else {
            serviceLoader = () -> LoggerFactory.lambda$getServiceLoader$0((ClassLoader)serviceLoader);
            serviceLoader = AccessController.doPrivileged(serviceLoader);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void safelyInstantiate(List<SLF4JServiceProvider> providerList, Iterator<SLF4JServiceProvider> iterator) {
        try {
            List<SLF4JServiceProvider> list;
            SLF4JServiceProvider provider = iterator.next();
            list.add(provider);
            return;
        }
        catch (ServiceConfigurationError e) {
            void var1_2;
            Reporter.error("A service provider failed to instantiate:\n" + var1_2.getMessage());
            return;
        }
    }

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void bind() {
        try {
            Collection<Object> providersList = LoggerFactory.findServiceProviders();
            LoggerFactory.reportMultipleBindingAmbiguity(providersList);
            if (providersList != null && !providersList.isEmpty()) {
                PROVIDER = providersList.get(0);
                PROVIDER.initialize();
                INITIALIZATION_STATE = 3;
                LoggerFactory.reportActualBinding(providersList);
            } else {
                INITIALIZATION_STATE = 4;
                Reporter.warn("No SLF4J providers were found.");
                Reporter.warn("Defaulting to no-operation (NOP) logger implementation");
                Reporter.warn("See https://www.slf4j.org/codes.html#noProviders for further details.");
                providersList = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
                LoggerFactory.reportIgnoredStaticLoggerBinders(providersList);
            }
            LoggerFactory.postBindCleanUp();
            return;
        }
        catch (Exception exception) {
            void var0_1;
            Exception e = exception;
            LoggerFactory.failedBinding(exception);
            throw new IllegalStateException("Unexpected initialization failure", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static SLF4JServiceProvider loadExplicitlySpecified(ClassLoader classLoader) {
        GenericDeclaration genericDeclaration;
        String explicitlySpecified = System.getProperty(PROVIDER_PROPERTY_KEY);
        if (explicitlySpecified == null || explicitlySpecified.isEmpty()) {
            return null;
        }
        try {
            String string = String.format("Attempting to load provider \"%s\" specified via \"%s\" system property", explicitlySpecified, PROVIDER_PROPERTY_KEY);
            Reporter.info(string);
            genericDeclaration = ((ClassLoader)((Object)genericDeclaration)).loadClass(explicitlySpecified);
            genericDeclaration = genericDeclaration.getConstructor(new Class[0]);
            genericDeclaration = ((Constructor)genericDeclaration).newInstance(new Object[0]);
            return (SLF4JServiceProvider)((Object)genericDeclaration);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            genericDeclaration = String.format("Failed to instantiate the specified SLF4JServiceProvider (%s)", explicitlySpecified);
            Reporter.error((String)((Object)genericDeclaration), e);
            return null;
        }
        catch (ClassCastException e) {
            void var2_4;
            void var1_1;
            genericDeclaration = String.format("Specified SLF4JServiceProvider (%s) does not implement SLF4JServiceProvider interface", var1_1);
            Reporter.error((String)((Object)genericDeclaration), (Throwable)var2_4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void reportIgnoredStaticLoggerBinders(Set<URL> staticLoggerBinderPathSet) {
        Iterator<URL> iterator;
        if (staticLoggerBinderPathSet.isEmpty()) {
            return;
        }
        Reporter.warn("Class path contains SLF4J bindings targeting slf4j-api versions 1.7.x or earlier.");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            URL path = (URL)iterator.next();
            Reporter.warn("Ignoring binding found at [" + var1_1 + "]");
        }
        Reporter.warn("See https://www.slf4j.org/codes.html#ignoredBindings for an explanation.");
    }

    /*
     * WARNING - void declaration
     */
    static Set<URL> findPossibleStaticLoggerBinderPathSet() {
        void var0;
        LinkedHashSet<void> staticLoggerBinderPathSet = new LinkedHashSet<void>();
        try {
            Enumeration<URL> paths;
            ClassLoader loggerFactoryClassLoader = LoggerFactory.class.getClassLoader();
            paths = loggerFactoryClassLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : ((ClassLoader)((Object)paths)).getResources(STATIC_LOGGER_BINDER_PATH);
            while (paths.hasMoreElements()) {
                void var2_3;
                URL path = paths.nextElement();
                staticLoggerBinderPathSet.add(var2_3);
            }
        }
        catch (IOException ioe) {
            void var1_2;
            Reporter.error("Error getting resources from path", (Throwable)var1_2);
        }
        return var0;
    }

    private static void postBindCleanUp() {
        LoggerFactory.fixSubstituteLoggers();
        LoggerFactory.replayEvents();
        SUBST_PROVIDER.getSubstituteLoggerFactory().clear();
    }

    /*
     * WARNING - void declaration
     */
    private static void fixSubstituteLoggers() {
        SubstituteServiceProvider substituteServiceProvider = SUBST_PROVIDER;
        synchronized (substituteServiceProvider) {
            SUBST_PROVIDER.getSubstituteLoggerFactory().postInitialization();
            for (SubstituteLogger substLogger : SUBST_PROVIDER.getSubstituteLoggerFactory().getLoggers()) {
                void var3_4;
                void var2_3;
                Logger logger = LoggerFactory.getLogger(substLogger.getName());
                var2_3.setDelegate((Logger)var3_4);
            }
            return;
        }
    }

    static void failedBinding(Throwable t) {
        Throwable throwable;
        INITIALIZATION_STATE = 2;
        Reporter.error("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static void replayEvents() {
        int n;
        LinkedBlockingQueue<SubstituteLoggingEvent> queue = SUBST_PROVIDER.getSubstituteLoggerFactory().getEventQueue();
        int queueSize = queue.size();
        int count = 0;
        ArrayList eventList = new ArrayList(128);
        while ((n = queue.drainTo(eventList, 128)) != 0) {
            for (SubstituteLoggingEvent event : eventList) {
                LoggerFactory.replaySingleEvent(event);
                if (count++ != 0) continue;
                LoggerFactory.emitReplayOrSubstituionWarning(event, queueSize);
            }
            eventList.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void emitReplayOrSubstituionWarning(SubstituteLoggingEvent event, int queueSize) {
        SubstituteLoggingEvent substituteLoggingEvent;
        if (event.getLogger().isDelegateEventAware()) {
            void var1_1;
            LoggerFactory.emitReplayWarning((int)var1_1);
            return;
        }
        if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.emitSubstitutionWarning();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void replaySingleEvent(SubstituteLoggingEvent event) {
        if (event == null) {
            return;
        }
        SubstituteLogger substLogger = event.getLogger();
        String loggerName = substLogger.getName();
        if (substLogger.isDelegateNull()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substLogger.isDelegateNOP()) {
            if (substLogger.isDelegateEventAware()) {
                if (substLogger.isEnabledForLevel(event.getLevel())) {
                    SubstituteLoggingEvent substituteLoggingEvent;
                    void var1_1;
                    var1_1.log(substituteLoggingEvent);
                    return;
                }
            } else {
                void var2_2;
                Reporter.warn((String)var2_2);
            }
        }
    }

    private static void emitSubstitutionWarning() {
        Reporter.warn("The following set of substitute loggers may have been accessed");
        Reporter.warn("during the initialization phase. Logging calls during this");
        Reporter.warn("phase were not honored. However, subsequent logging calls to these");
        Reporter.warn("loggers will work as normally expected.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void emitReplayWarning(int eventCount) {
        int n;
        Reporter.warn("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Reporter.warn("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#replay");
    }

    /*
     * WARNING - void declaration
     */
    private static final void versionSanityCheck() {
        try {
            void var1_2;
            String requested = PROVIDER.getRequestedApiVersion();
            boolean match = false;
            String[] stringArray = API_COMPATIBILITY_LIST;
            int n = API_COMPATIBILITY_LIST.length;
            for (int i = 0; i < n; ++i) {
                String aAPI_COMPATIBILITY_LIST = stringArray[i];
                if (!requested.startsWith(aAPI_COMPATIBILITY_LIST)) continue;
                match = true;
            }
            if (var1_2 == false) {
                Reporter.warn("The requested version " + requested + " by your slf4j provider is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Reporter.warn("See https://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
            return;
        }
        catch (Throwable e) {
            void var0_1;
            Reporter.error("Unexpected problem occurred during version sanity check", (Throwable)var0_1);
            return;
        }
    }

    private static boolean isAmbiguousProviderList(List<SLF4JServiceProvider> providerList) {
        return providerList.size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    private static void reportMultipleBindingAmbiguity(List<SLF4JServiceProvider> providerList) {
        if (LoggerFactory.isAmbiguousProviderList(providerList)) {
            Iterator<SLF4JServiceProvider> iterator;
            Reporter.warn("Class path contains multiple SLF4J providers.");
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var1_1;
                SLF4JServiceProvider provider = (SLF4JServiceProvider)iterator.next();
                Reporter.warn("Found provider [" + var1_1 + "]");
            }
            Reporter.warn("See https://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static void reportActualBinding(List<SLF4JServiceProvider> providerList) {
        SLF4JServiceProvider sLF4JServiceProvider;
        if (providerList.isEmpty()) {
            throw new IllegalStateException("No providers were found which is impossible after successful initialization.");
        }
        if (LoggerFactory.isAmbiguousProviderList(providerList)) {
            Reporter.info("Actual provider is of type [" + providerList.get(0) + "]");
            return;
        }
        SLF4JServiceProvider provider = providerList.get(0);
        Reporter.debug(CONNECTED_WITH_MSG + sLF4JServiceProvider.getClass().getName() + "]");
    }

    public static Logger getLogger(String name) {
        String string;
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(Class<?> clazz) {
        void var1_1;
        Class<?> clazz2;
        Class<?> autoComputedCallingClass;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (DETECT_LOGGER_NAME_MISMATCH && (autoComputedCallingClass = Util.getCallingClass()) != null && LoggerFactory.nonMatchingClasses(clazz2, autoComputedCallingClass)) {
            void var2_2;
            Reporter.warn(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), var2_2.getName()));
            Reporter.warn("See https://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return var1_1;
    }

    private static boolean nonMatchingClasses(Class<?> clazz, Class<?> autoComputedCallingClass) {
        Class<?> clazz2;
        return !autoComputedCallingClass.isAssignableFrom(clazz2);
    }

    public static ILoggerFactory getILoggerFactory() {
        return LoggerFactory.getProvider().getLoggerFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static SLF4JServiceProvider getProvider() {
        if (INITIALIZATION_STATE == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : org.slf4j.LoggerFactory.class
            if (INITIALIZATION_STATE == 0) {
                INITIALIZATION_STATE = 1;
                LoggerFactory.performInitialization();
            }
            // MONITOREXIT : clazz
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return PROVIDER;
            }
            case 4: {
                return NOP_FALLBACK_SERVICE_PROVIDER;
            }
            case 2: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
            case 1: {
                return SUBST_PROVIDER;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    private static /* synthetic */ ServiceLoader lambda$getServiceLoader$0(ClassLoader classLoaderOfLoggerFactory) {
        ClassLoader classLoader;
        return ServiceLoader.load(SLF4JServiceProvider.class, classLoader);
    }

    static {
        API_COMPATIBILITY_LIST = new String[]{"2.0"};
    }
}

