/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class NativeLongArray {
    private ByteBuffer memory;
    private long memoryAddress;
    private int capacity;
    private int size;

    /*
     * WARNING - void declaration
     */
    NativeLongArray(int capacity) {
        void var1_1;
        this.capacity = ObjectUtil.checkPositive((int)capacity, (String)"capacity");
        this.memory = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity((int)var1_1));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
    }

    private static int idx(int index) {
        return index * Limits.SIZEOF_JLONG;
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * Limits.SIZEOF_JLONG;
    }

    /*
     * WARNING - void declaration
     */
    final void add(long value) {
        this.reallocIfNeeded();
        if (PlatformDependent.hasUnsafe()) {
            NativeLongArray nativeLongArray = this;
            PlatformDependent.putLong((long)nativeLongArray.memoryOffset(nativeLongArray.size), (long)value);
        } else {
            void var1_1;
            this.memory.putLong(NativeLongArray.idx(this.size), (long)var1_1);
        }
        ++this.size;
    }

    final void clear() {
        this.size = 0;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final int size() {
        return this.size;
    }

    final void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.memoryAddress = 0L;
    }

    final long memoryAddress() {
        return this.memoryAddress;
    }

    final long memoryAddressEnd() {
        NativeLongArray nativeLongArray = this;
        return nativeLongArray.memoryOffset(nativeLongArray.size);
    }

    /*
     * WARNING - void declaration
     */
    private long memoryOffset(int index) {
        void var1_1;
        return this.memoryAddress + (long)NativeLongArray.idx((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void reallocIfNeeded() {
        if (this.size == this.capacity) {
            void var1_1;
            void var2_2;
            int newLength = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
            ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity(newLength));
            this.memory.position(0).limit(this.size);
            buffer.put(this.memory);
            buffer.position(0);
            Buffer.free((ByteBuffer)this.memory);
            this.memory = buffer;
            this.memoryAddress = Buffer.memoryAddress((ByteBuffer)var2_2);
            this.capacity = var1_1;
        }
    }

    public final String toString() {
        return "memoryAddress: " + this.memoryAddress + " capacity: " + this.capacity + " size: " + this.size;
    }
}

