/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Map;

public final class KQueueSocketChannelConfig
extends KQueueChannelConfig
implements SocketChannelConfig {
    private volatile boolean allowHalfClosure;
    private volatile boolean tcpFastopen;

    /*
     * WARNING - void declaration
     */
    KQueueSocketChannelConfig(KQueueSocketChannel channel) {
        super((AbstractKQueueChannel)var1_1);
        void var1_1;
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
        this.calculateMaxBytesPerGatheringWrite();
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        KQueueSocketChannelConfig kQueueSocketChannelConfig = this;
        return kQueueSocketChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, KQueueChannelOption.SO_SNDLOWAT, KQueueChannelOption.TCP_NOPUSH});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (option == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (option == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (option == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (option == KQueueChannelOption.SO_SNDLOWAT) {
            return (T)Integer.valueOf(this.getSndLowAt());
        }
        if (option == KQueueChannelOption.TCP_NOPUSH) {
            return (T)Boolean.valueOf(this.isTcpNoPush());
        }
        if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
            return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else if (option == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)value);
        } else if (option == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)value);
        } else if (option == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else if (option == KQueueChannelOption.SO_SNDLOWAT) {
            this.setSndLowAt((Integer)value);
        } else if (option == KQueueChannelOption.TCP_NOPUSH) {
            this.setTcpNoPush((Boolean)value);
        } else if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
            this.setTcpFastOpenConnect((Boolean)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getReceiveBufferSize() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSendBufferSize() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSoLinger() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.getSoLinger();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getTrafficClass() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.getTrafficClass();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isKeepAlive() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.isKeepAlive();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isReuseAddress() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTcpNoDelay() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.isTcpNoDelay();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSndLowAt() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.getSndLowAt();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setSndLowAt(int sndLowAt) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setSndLowAt(sndLowAt);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTcpNoPush() {
        try {
            return ((KQueueSocketChannel)this.channel).socket.isTcpNoPush();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTcpNoPush(boolean tcpNoPush) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setTcpNoPush(tcpNoPush);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setKeepAlive(boolean keepAlive) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setKeepAlive(keepAlive);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setReuseAddress(reuseAddress);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setSendBufferSize(int sendBufferSize) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setSendBufferSize(sendBufferSize);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setSoLinger(int soLinger) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setSoLinger(soLinger);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setTcpNoDelay(tcpNoDelay);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setTrafficClass(int trafficClass) {
        try {
            ((KQueueSocketChannel)this.channel).socket.setTrafficClass(trafficClass);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    public final boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setTcpFastOpenConnect(boolean fastOpenConnect) {
        void var1_1;
        this.tcpFastopen = var1_1;
        return this;
    }

    public final boolean isTcpFastOpenConnect() {
        return this.tcpFastopen;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setRcvAllocTransportProvidesGuess(boolean transportProvidesGuess) {
        void var1_1;
        super.setRcvAllocTransportProvidesGuess((boolean)var1_1);
        return this;
    }

    public final KQueueSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        void var1_1;
        this.allowHalfClosure = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final KQueueSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final KQueueSocketChannelConfig setAutoClose(boolean autoClose) {
        void var1_1;
        super.setAutoClose((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final KQueueSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final KQueueSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KQueueSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void calculateMaxBytesPerGatheringWrite() {
        int newSendBufferSize = this.getSendBufferSize() << 1;
        if (newSendBufferSize > 0) {
            void var1_1;
            this.setMaxBytesPerGatheringWrite((long)var1_1);
        }
    }
}

