/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueSocketChannelConfig;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.IovArray;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public final class KQueueSocketChannel
extends AbstractKQueueStreamChannel
implements SocketChannel {
    private final KQueueSocketChannelConfig config = new KQueueSocketChannelConfig(this);

    public KQueueSocketChannel() {
        super(null, BsdSocket.newSocketStream(), false);
    }

    /*
     * WARNING - void declaration
     */
    public KQueueSocketChannel(InternetProtocolFamily protocol) {
        super(null, BsdSocket.newSocketStream((InternetProtocolFamily)var1_1), false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KQueueSocketChannel(int fd) {
        super(new BsdSocket((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    KQueueSocketChannel(Channel parent, BsdSocket fd, InetSocketAddress remoteAddress) {
        super((Channel)var1_1, (BsdSocket)var2_2, (SocketAddress)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final KQueueSocketChannelConfig config() {
        return this.config;
    }

    public final ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect0(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        void var2_4;
        void var1_1;
        if (this.config.isTcpFastOpenConnect()) {
            ByteBuf initialData;
            ChannelOutboundBuffer outbound = this.unsafe().outboundBuffer();
            outbound.addFlush();
            Object curr = outbound.current();
            if (curr instanceof ByteBuf && (initialData = (ByteBuf)curr).isReadable()) {
                IovArray iov = new IovArray(this.config.getAllocator().directBuffer());
                try {
                    int n;
                    void var3_5;
                    ByteBuf byteBuf = initialData;
                    iov.add(byteBuf, byteBuf.readerIndex(), initialData.readableBytes());
                    int bytesSent = this.socket.connectx((InetSocketAddress)localAddress, (InetSocketAddress)remoteAddress, iov, true);
                    this.writeFilter(true);
                    var3_5.removeBytes((long)Math.abs(bytesSent));
                    n = n > 0 ? 1 : 0;
                    return n != 0;
                }
                finally {
                    iov.release();
                }
            }
        }
        return super.doConnect0((SocketAddress)var1_1, (SocketAddress)var2_4);
    }

    @Override
    protected final AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueSocketChannelUnsafe();
    }

    private final class KQueueSocketChannelUnsafe
    extends AbstractKQueueStreamChannel.KQueueStreamUnsafe {
        private KQueueSocketChannelUnsafe() {
            super(KQueueSocketChannel.this);
        }

        @Override
        protected final Executor prepareToClose() {
            try {
                if (KQueueSocketChannel.this.isOpen() && KQueueSocketChannel.this.config().getSoLinger() > 0) {
                    ((KQueueEventLoop)KQueueSocketChannel.this.eventLoop()).remove(KQueueSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

