/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.kqueue.KQueueServerChannelConfig;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import java.io.IOException;
import java.util.Map;

public class KQueueServerSocketChannelConfig
extends KQueueServerChannelConfig {
    /*
     * WARNING - void declaration
     */
    KQueueServerSocketChannelConfig(KQueueServerSocketChannel channel) {
        super((AbstractKQueueChannel)var1_1);
        void var1_1;
        this.setReuseAddress(true);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        KQueueServerSocketChannelConfig kQueueServerSocketChannelConfig = this;
        return kQueueServerSocketChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{UnixChannelOption.SO_REUSEPORT, KQueueChannelOption.SO_ACCEPTFILTER});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == UnixChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (option == KQueueChannelOption.SO_ACCEPTFILTER) {
            return (T)this.getAcceptFilter();
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == UnixChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)value);
        } else if (option == KQueueChannelOption.SO_ACCEPTFILTER) {
            this.setAcceptFilter((AcceptFilter)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public KQueueServerSocketChannelConfig setReusePort(boolean reusePort) {
        try {
            ((KQueueServerSocketChannel)this.channel).socket.setReusePort(reusePort);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReusePort() {
        try {
            return ((KQueueServerSocketChannel)this.channel).socket.isReusePort();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public KQueueServerSocketChannelConfig setAcceptFilter(AcceptFilter acceptFilter) {
        try {
            ((KQueueServerSocketChannel)this.channel).socket.setAcceptFilter(acceptFilter);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AcceptFilter getAcceptFilter() {
        try {
            return ((KQueueServerSocketChannel)this.channel).socket.getAcceptFilter();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setRcvAllocTransportProvidesGuess(boolean transportProvidesGuess) {
        void var1_1;
        super.setRcvAllocTransportProvidesGuess((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        void var1_1;
        super.setReuseAddress((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        void var1_1;
        super.setReceiveBufferSize((int)var1_1);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setBacklog(int backlog) {
        void var1_1;
        super.setBacklog((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setTcpFastOpen(boolean enableTcpFastOpen) {
        void var1_1;
        super.setTcpFastOpen((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KQueueServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }
}

