/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class KQueueEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueEventLoop.class);
    private static final AtomicIntegerFieldUpdater<KQueueEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueEventLoop.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new IntSupplier(this){
        final /* synthetic */ KQueueEventLoop this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public int get() throws Exception {
            return this.this$0.kqueueWaitNow();
        }
    };
    private final IntObjectMap<AbstractKQueueChannel> channels = new IntObjectHashMap(4096);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    /*
     * WARNING - void declaration
     */
    KQueueEventLoop(EventLoopGroup parent, Executor executor, int maxEvents, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory taskQueueFactory, EventLoopTaskQueueFactory tailTaskQueueFactory) {
        super(parent, (Executor)var2_3, false, KQueueEventLoop.newTaskQueue(taskQueueFactory), KQueueEventLoop.newTaskQueue(tailTaskQueueFactory), rejectedExecutionHandler);
        void var3_4;
        void var2_3;
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)strategy, (String)"strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray((int)var3_4);
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            void var1_2;
            this.cleanup();
            throw new IllegalStateException("kevent failed to add user event with errno: " + (int)(-var1_2));
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        EventLoopTaskQueueFactory eventLoopTaskQueueFactory;
        if (queueFactory == null) {
            return KQueueEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    /*
     * WARNING - void declaration
     */
    final void add(AbstractKQueueChannel ch) {
        void var1_1;
        assert (this.inEventLoop());
        AbstractKQueueChannel old = (AbstractKQueueChannel)((Object)this.channels.put(ch.fd().intValue(), (Object)ch));
        assert (old == null || !var1_1.isOpen());
    }

    /*
     * WARNING - void declaration
     */
    final void evSet(AbstractKQueueChannel ch, short filter, short flags, int fflags) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (this.inEventLoop());
        this.changeList.evSet((AbstractKQueueChannel)var1_1, (short)var2_2, (short)var3_3, fflags);
    }

    /*
     * WARNING - void declaration
     */
    final void remove(AbstractKQueueChannel ch) throws Exception {
        assert (this.inEventLoop());
        int fd = ch.fd().intValue();
        AbstractKQueueChannel old = (AbstractKQueueChannel)((Object)this.channels.remove(fd));
        if (old != null && old != ch) {
            void var3_3;
            void var2_2;
            this.channels.put((int)var2_2, (Object)var3_3);
            assert (!ch.isOpen());
        } else if (ch.isOpen()) {
            void var1_1;
            var1_1.unregisterFilters();
        }
    }

    final IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    protected final void wakeup(boolean inEventLoop) {
        if (!inEventLoop && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    /*
     * WARNING - void declaration
     */
    private int kqueueWait(boolean oldWakeup) throws IOException {
        void var2_3;
        void var1_1;
        if (oldWakeup && this.hasTasks()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = this.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, 86399L);
        int delayNanos = (int)(totalDelay % 1000000000L);
        return this.kqueueWait((int)var1_1, (int)var2_3);
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        void var1_1;
        void var2_2;
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, (int)var2_2);
        this.changeList.clear();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            void var3_3;
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int fd = this.eventList.fd(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && fd == 0);
                continue;
            }
            AbstractKQueueChannel channel = (AbstractKQueueChannel)((Object)this.channels.get(fd));
            if (channel == null) {
                logger.warn("events[{}]=[{}, {}] had no channel!", new Object[]{i, this.eventList.fd(i), filter});
                continue;
            }
            AbstractKQueueChannel.AbstractKQueueUnsafe unsafe = (AbstractKQueueChannel.AbstractKQueueUnsafe)channel.unsafe();
            if (filter == Native.EVFILT_WRITE) {
                unsafe.writeReady();
            } else if (filter == Native.EVFILT_READ) {
                unsafe.readReady(this.eventList.data(i));
            } else if (var3_3 == Native.EVFILT_SOCK && (this.eventList.fflags(i) & Native.NOTE_RDHUP) != 0) {
                unsafe.readEOF();
            }
            if ((flags & Native.EV_EOF) == 0) continue;
            unsafe.readEOF();
        }
    }

    /*
     * Exception decompiling
     */
    protected final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return KQueueEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        int n;
        if (maxPendingTasks == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue((int)n);
    }

    public final int getIoRatio() {
        return this.ioRatio;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIoRatio(int ioRatio) {
        void var1_1;
        if (ioRatio <= 0 || ioRatio > 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = var1_1;
    }

    public final int registeredChannels() {
        return this.channels.size();
    }

    /*
     * WARNING - void declaration
     */
    public final Iterator<Channel> registeredChannelsIterator() {
        void var1_1;
        assert (this.inEventLoop());
        IntObjectMap<AbstractKQueueChannel> ch = this.channels;
        if (ch.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator((Iterable)var1_1.values());
    }

    /*
     * WARNING - void declaration
     */
    protected final void cleanup() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                void var1_1;
                logger.warn("Failed to close the kqueue fd.", (Throwable)var1_1);
            }
            return;
        }
        finally {
            this.changeList.free();
            this.eventList.free();
        }
    }

    private void closeAll() {
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {}
        AbstractKQueueChannel[] abstractKQueueChannelArray = this.channels.values().toArray(new AbstractKQueueChannel[0]);
        AbstractKQueueChannel[] abstractKQueueChannelArray2 = abstractKQueueChannelArray;
        abstractKQueueChannelArray2 = abstractKQueueChannelArray;
        int n = abstractKQueueChannelArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractKQueueChannel ch = abstractKQueueChannelArray2[i];
            ch.unsafe().close(ch.unsafe().voidPromise());
        }
    }

    private static void handleLoopException(Throwable t) {
        Throwable throwable;
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    static {
        KQueue.ensureAvailability();
    }
}

