/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.Buffer;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class KQueueEventArray {
    private static final int KQUEUE_EVENT_SIZE = Native.sizeofKEvent();
    private static final int KQUEUE_IDENT_OFFSET = Native.offsetofKEventIdent();
    private static final int KQUEUE_FILTER_OFFSET = Native.offsetofKEventFilter();
    private static final int KQUEUE_FFLAGS_OFFSET = Native.offsetofKEventFFlags();
    private static final int KQUEUE_FLAGS_OFFSET = Native.offsetofKEventFlags();
    private static final int KQUEUE_DATA_OFFSET = Native.offsetofKeventData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int size;
    private int capacity;

    /*
     * WARNING - void declaration
     */
    KQueueEventArray(int capacity) {
        void var1_1;
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be >= 1 but was " + capacity);
        }
        this.memory = Buffer.allocateDirectWithNativeOrder((int)KQueueEventArray.calculateBufferCapacity(capacity));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
        this.capacity = var1_1;
    }

    final long memoryAddress() {
        return this.memoryAddress;
    }

    final int capacity() {
        return this.capacity;
    }

    final int size() {
        return this.size;
    }

    final void clear() {
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    final void evSet(AbstractKQueueChannel ch, short filter, short flags, int fflags) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.reallocIfNeeded();
        KQueueEventArray.evSet((long)KQueueEventArray.getKEventOffset(this.size++) + this.memoryAddress, var1_1.socket.intValue(), (short)var2_2, (short)var3_3, fflags);
    }

    private void reallocIfNeeded() {
        if (this.size == this.capacity) {
            this.realloc(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void realloc(boolean throwIfFail) {
        int newLength = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
        try {
            ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder((int)KQueueEventArray.calculateBufferCapacity(newLength));
            this.memory.position(0).limit(this.size);
            buffer.put(this.memory);
            buffer.position(0);
            Buffer.free((ByteBuffer)this.memory);
            this.memory = buffer;
            this.memoryAddress = Buffer.memoryAddress((ByteBuffer)buffer);
            return;
        }
        catch (OutOfMemoryError e) {
            if (throwIfFail) {
                void var1_2;
                void var3_5;
                void var2_3;
                OutOfMemoryError error = new OutOfMemoryError("unable to allocate " + (int)var2_3 + " new bytes! Existing capacity is: " + this.capacity);
                error.initCause((Throwable)var3_5);
                throw var1_2;
            }
            return;
        }
    }

    final void free() {
        Buffer.free((ByteBuffer)this.memory);
        KQueueEventArray kQueueEventArray = this;
        this.capacity = 0;
        kQueueEventArray.size = 0;
        kQueueEventArray.memoryAddress = 0L;
    }

    private static int getKEventOffset(int index) {
        return index * KQUEUE_EVENT_SIZE;
    }

    private long getKEventOffsetAddress(int index) {
        return (long)KQueueEventArray.getKEventOffset(index) + this.memoryAddress;
    }

    /*
     * WARNING - void declaration
     */
    private short getShort(int index, int offset) {
        void var2_2;
        void var1_1;
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getShort((long)(this.getKEventOffsetAddress(index) + (long)offset));
        }
        return this.memory.getShort(KQueueEventArray.getKEventOffset((int)var1_1) + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final short flags(int index) {
        void var1_1;
        return this.getShort((int)var1_1, KQUEUE_FLAGS_OFFSET);
    }

    /*
     * WARNING - void declaration
     */
    final short filter(int index) {
        void var1_1;
        return this.getShort((int)var1_1, KQUEUE_FILTER_OFFSET);
    }

    /*
     * WARNING - void declaration
     */
    final short fflags(int index) {
        void var1_1;
        return this.getShort((int)var1_1, KQUEUE_FFLAGS_OFFSET);
    }

    /*
     * WARNING - void declaration
     */
    final int fd(int index) {
        void var1_1;
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getInt((long)(this.getKEventOffsetAddress(index) + (long)KQUEUE_IDENT_OFFSET));
        }
        return this.memory.getInt(KQueueEventArray.getKEventOffset((int)var1_1) + KQUEUE_IDENT_OFFSET);
    }

    /*
     * WARNING - void declaration
     */
    final long data(int index) {
        void var1_1;
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getLong((long)(this.getKEventOffsetAddress(index) + (long)KQUEUE_DATA_OFFSET));
        }
        return this.memory.getLong(KQueueEventArray.getKEventOffset((int)var1_1) + KQUEUE_DATA_OFFSET);
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * KQUEUE_EVENT_SIZE;
    }

    private static native void evSet(long var0, int var2, short var3, short var4, int var5);
}

