/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueDatagramChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainDatagramChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainDatagramPacket;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class KQueueDomainDatagramChannel
extends AbstractKQueueDatagramChannel
implements DomainDatagramChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final KQueueDomainDatagramChannelConfig config = new KQueueDomainDatagramChannelConfig(this);

    public KQueueDomainDatagramChannel() {
        this(BsdSocket.newSocketDomainDgram(), false);
    }

    /*
     * WARNING - void declaration
     */
    public KQueueDomainDatagramChannel(int fd) {
        this(new BsdSocket((int)var1_1), true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KQueueDomainDatagramChannel(BsdSocket socket, boolean active) {
        super(null, (BsdSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public final KQueueDomainDatagramChannelConfig config() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        super.doBind(localAddress);
        this.local = (DomainSocketAddress)var1_1;
        this.active = true;
    }

    @Override
    protected final void doClose() throws Exception {
        super.doClose();
        KQueueDomainDatagramChannel kQueueDomainDatagramChannel = this;
        kQueueDomainDatagramChannel.active = false;
        kQueueDomainDatagramChannel.connected = false;
        this.local = null;
        this.remote = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (super.doConnect(remoteAddress, localAddress)) {
            void var1_1;
            if (localAddress != null) {
                void var2_2;
                this.local = (DomainSocketAddress)var2_2;
            }
            this.remote = (DomainSocketAddress)var1_1;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected final void doDisconnect() throws Exception {
        this.doClose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doWriteMessage(Object msg) throws Exception {
        long writtenBytes;
        DomainSocketAddress remoteAddress;
        ByteBuf data;
        if (msg instanceof AddressedEnvelope) {
            void var3_2;
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (ByteBuf)envelope.content();
            remoteAddress = (DomainSocketAddress)var3_2.recipient();
        } else {
            data = data;
            remoteAddress = null;
        }
        int n = data.readableBytes();
        if (n == 0) {
            return true;
        }
        if (data.hasMemoryAddress()) {
            long memoryAddress = data.memoryAddress();
            writtenBytes = remoteAddress == null ? (long)this.socket.writeAddress(memoryAddress, data.readerIndex(), data.writerIndex()) : (long)this.socket.sendToAddressDomainSocket(memoryAddress, data.readerIndex(), data.writerIndex(), remoteAddress.path().getBytes(CharsetUtil.UTF_8));
        } else if (data.nioBufferCount() > 1) {
            IovArray array = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            ByteBuf byteBuf = data;
            array.add(byteBuf, byteBuf.readerIndex(), data.readableBytes());
            int cnt = array.count();
            assert (cnt != 0);
            writtenBytes = remoteAddress == null ? this.socket.writevAddresses(array.memoryAddress(0), cnt) : (long)this.socket.sendToAddressesDomainSocket(array.memoryAddress(0), cnt, remoteAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            void var1_1;
            ByteBuf byteBuf = data;
            ByteBuffer nioData = byteBuf.internalNioBuffer(byteBuf.readerIndex(), var1_1.readableBytes());
            if (remoteAddress == null) {
                ByteBuffer byteBuffer = nioData;
                writtenBytes = this.socket.write(byteBuffer, byteBuffer.position(), nioData.limit());
            } else {
                void var2_4;
                ByteBuffer byteBuffer = nioData;
                writtenBytes = this.socket.sendToDomainSocket(byteBuffer, byteBuffer.position(), nioData.limit(), var2_4.path().getBytes(CharsetUtil.UTF_8));
            }
        }
        return writtenBytes > 0L;
    }

    /*
     * WARNING - void declaration
     */
    protected final Object filterOutboundMessage(Object msg) {
        void var1_1;
        AddressedEnvelope e;
        if (msg instanceof DomainDatagramPacket) {
            DomainDatagramPacket packet = (DomainDatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                return new DomainDatagramPacket(this.newDirectBuffer(packet, content), (DomainSocketAddress)packet.recipient());
            }
            return msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf)) {
                return this.newDirectBuffer(buf);
            }
            return buf;
        }
        if (msg instanceof AddressedEnvelope && (e = (AddressedEnvelope)msg).content() instanceof ByteBuf && (e.recipient() == null || e.recipient() instanceof DomainSocketAddress)) {
            void var2_4;
            ByteBuf content = (ByteBuf)e.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                void var3_6;
                return new DefaultAddressedEnvelope((Object)this.newDirectBuffer(e, (ByteBuf)var3_6), (SocketAddress)((DomainSocketAddress)e.recipient()));
            }
            return var2_4;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    @Override
    public final boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected final AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDomainDatagramChannelUnsafe();
    }

    public final PeerCredentials peerCredentials() throws IOException {
        return this.socket.getPeerCredentials();
    }

    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    protected final DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class KQueueDomainDatagramChannelUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        /*
         * WARNING - void declaration
         */
        KQueueDomainDatagramChannelUnsafe() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            KQueueDomainDatagramChannelConfig config;
            block16: {
                assert (KQueueDomainDatagramChannel.this.eventLoop().inEventLoop());
                config = KQueueDomainDatagramChannel.this.config();
                if (KQueueDomainDatagramChannel.this.shouldBreakReadReady((ChannelConfig)config)) {
                    this.clearReadFilter0();
                    return;
                }
                ChannelPipeline pipeline = KQueueDomainDatagramChannel.this.pipeline();
                ByteBufAllocator allocator = config.getAllocator();
                allocHandle.reset((ChannelConfig)config);
                this.readReadyBefore();
                Throwable exception = null;
                try {
                    void var3_4;
                    void var1_1;
                    ByteBuf byteBuf = null;
                    try {
                        boolean connected = KQueueDomainDatagramChannel.this.isConnected();
                        do {
                            DomainDatagramPacket packet;
                            byteBuf = allocHandle.allocate(allocator);
                            allocHandle.attemptedBytesRead(byteBuf.writableBytes());
                            if (connected) {
                                allocHandle.lastBytesRead(KQueueDomainDatagramChannel.this.doReadBytes(byteBuf));
                                if (allocHandle.lastBytesRead() <= 0) {
                                    byteBuf.release();
                                    break;
                                }
                                packet = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                            } else {
                                DomainDatagramSocketAddress remoteAddress;
                                if (byteBuf.hasMemoryAddress()) {
                                    remoteAddress = KQueueDomainDatagramChannel.this.socket.recvFromAddressDomainSocket(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                                } else {
                                    ByteBuffer nioData;
                                    ByteBuf byteBuf2 = byteBuf;
                                    ByteBuffer byteBuffer = nioData = byteBuf2.internalNioBuffer(byteBuf2.writerIndex(), byteBuf.writableBytes());
                                    remoteAddress = KQueueDomainDatagramChannel.this.socket.recvFromDomainSocket(byteBuffer, byteBuffer.position(), nioData.limit());
                                }
                                if (remoteAddress == null) {
                                    allocHandle.lastBytesRead(-1);
                                    byteBuf.release();
                                    break;
                                }
                                DomainDatagramSocketAddress localAddress = remoteAddress.localAddress();
                                if (localAddress == null) {
                                    localAddress = (DomainSocketAddress)this.localAddress();
                                }
                                allocHandle.lastBytesRead(remoteAddress.receivedAmount());
                                ByteBuf byteBuf3 = byteBuf;
                                byteBuf3.writerIndex(byteBuf3.writerIndex() + allocHandle.lastBytesRead());
                                packet = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)localAddress, (DomainSocketAddress)remoteAddress);
                            }
                            allocHandle.incMessagesRead(1);
                            this.readPending = false;
                            pipeline.fireChannelRead((Object)packet);
                            byteBuf = null;
                        } while (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                    }
                    catch (Throwable t) {
                        if (byteBuf != null) {
                            byteBuf.release();
                        }
                        exception = t;
                    }
                    var1_1.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (exception == null) break block16;
                    var3_4.fireExceptionCaught(exception);
                }
                catch (Throwable throwable) {
                    void var2_3;
                    this.readReadyFinally((ChannelConfig)var2_3);
                    throw throwable;
                }
            }
            this.readReadyFinally((ChannelConfig)config);
        }
    }
}

