/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueDatagramChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDatagramChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

public final class KQueueDatagramChannel
extends AbstractKQueueDatagramChannel
implements DatagramChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private final KQueueDatagramChannelConfig config = new KQueueDatagramChannelConfig(this);

    public KQueueDatagramChannel() {
        super(null, BsdSocket.newSocketDgram(), false);
    }

    /*
     * WARNING - void declaration
     */
    public KQueueDatagramChannel(InternetProtocolFamily protocol) {
        super(null, BsdSocket.newSocketDgram((InternetProtocolFamily)var1_1), false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KQueueDatagramChannel(int fd) {
        this(new BsdSocket((int)var1_1), true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    KQueueDatagramChannel(BsdSocket socket, boolean active) {
        super(null, (BsdSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            void var1_1;
            NetworkInterface iface = this.config().getNetworkInterface();
            if (iface == null) {
                iface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup((InetAddress)var1_1, iface, null, promise);
        }
        catch (SocketException e) {
            void var2_2;
            void var3_4;
            promise.setFailure((Throwable)var3_4);
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.joinGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)var2_2, (String)"networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (SocketException e) {
            void var2_3;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)var2_2, (String)"networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)var3_3, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)var2_2, (String)"networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (InetAddress)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        try {
            void var2_3;
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), (InetAddress)var2_3, promise);
        }
        catch (Throwable e) {
            void var3_4;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var3_4;
        }
    }

    @Override
    protected final AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDatagramChannelUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        super.doBind((SocketAddress)var1_1);
        this.active = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doWriteMessage(Object msg) throws Exception {
        long writtenBytes;
        InetSocketAddress remoteAddress;
        ByteBuf data;
        if (msg instanceof AddressedEnvelope) {
            void var3_2;
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (ByteBuf)envelope.content();
            remoteAddress = (InetSocketAddress)var3_2.recipient();
        } else {
            data = data;
            remoteAddress = null;
        }
        int n = data.readableBytes();
        if (n == 0) {
            return true;
        }
        if (data.hasMemoryAddress()) {
            long memoryAddress = data.memoryAddress();
            writtenBytes = remoteAddress == null ? (long)this.socket.writeAddress(memoryAddress, data.readerIndex(), data.writerIndex()) : (long)this.socket.sendToAddress(memoryAddress, data.readerIndex(), data.writerIndex(), remoteAddress.getAddress(), remoteAddress.getPort());
        } else if (data.nioBufferCount() > 1) {
            IovArray array = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            ByteBuf byteBuf = data;
            array.add(byteBuf, byteBuf.readerIndex(), data.readableBytes());
            int cnt = array.count();
            assert (cnt != 0);
            writtenBytes = remoteAddress == null ? this.socket.writevAddresses(array.memoryAddress(0), cnt) : (long)this.socket.sendToAddresses(array.memoryAddress(0), cnt, remoteAddress.getAddress(), remoteAddress.getPort());
        } else {
            void var1_1;
            ByteBuf byteBuf = data;
            ByteBuffer nioData = byteBuf.internalNioBuffer(byteBuf.readerIndex(), var1_1.readableBytes());
            if (remoteAddress == null) {
                ByteBuffer byteBuffer = nioData;
                writtenBytes = this.socket.write(byteBuffer, byteBuffer.position(), nioData.limit());
            } else {
                void var2_4;
                ByteBuffer byteBuffer = nioData;
                writtenBytes = this.socket.sendTo(byteBuffer, byteBuffer.position(), nioData.limit(), remoteAddress.getAddress(), var2_4.getPort());
            }
        }
        return writtenBytes > 0L;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        AddressedEnvelope<?, ?> addressedEnvelope;
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            KQueueDatagramChannel.checkUnresolved(packet);
            ByteBuf content = (ByteBuf)packet.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                return new DatagramPacket(this.newDirectBuffer(packet, content), (InetSocketAddress)packet.recipient());
            }
            return msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf)) {
                return this.newDirectBuffer(buf);
            }
            return buf;
        }
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope e = (AddressedEnvelope)msg;
            KQueueDatagramChannel.checkUnresolved(e);
            if (e.content() instanceof ByteBuf && (e.recipient() == null || e.recipient() instanceof InetSocketAddress)) {
                void var2_4;
                ByteBuf content = (ByteBuf)e.content();
                if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                    void var3_6;
                    return new DefaultAddressedEnvelope((Object)this.newDirectBuffer(e, (ByteBuf)var3_6), (SocketAddress)((InetSocketAddress)e.recipient()));
                }
                return var2_4;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    @Override
    public final KQueueDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected final void doDisconnect() throws Exception {
        this.socket.disconnect();
        KQueueDatagramChannel kQueueDatagramChannel = this;
        kQueueDatagramChannel.active = false;
        kQueueDatagramChannel.connected = false;
        this.resetCachedAddresses();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        void var2_2;
        void var1_1;
        if (super.doConnect((SocketAddress)var1_1, (SocketAddress)var2_2)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected final void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    final class KQueueDatagramChannelUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        /*
         * WARNING - void declaration
         */
        KQueueDatagramChannelUnsafe() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            KQueueDatagramChannelConfig config;
            block19: {
                assert (KQueueDatagramChannel.this.eventLoop().inEventLoop());
                config = KQueueDatagramChannel.this.config();
                if (KQueueDatagramChannel.this.shouldBreakReadReady((ChannelConfig)config)) {
                    this.clearReadFilter0();
                    return;
                }
                ChannelPipeline pipeline = KQueueDatagramChannel.this.pipeline();
                ByteBufAllocator allocator = config.getAllocator();
                allocHandle.reset((ChannelConfig)config);
                this.readReadyBefore();
                Throwable exception = null;
                try {
                    void var3_4;
                    void var1_1;
                    ByteBuf byteBuf = null;
                    try {
                        boolean connected = KQueueDatagramChannel.this.isConnected();
                        do {
                            DatagramPacket packet;
                            byteBuf = allocHandle.allocate(allocator);
                            allocHandle.attemptedBytesRead(byteBuf.writableBytes());
                            if (connected) {
                                try {
                                    allocHandle.lastBytesRead(KQueueDatagramChannel.this.doReadBytes(byteBuf));
                                }
                                catch (Errors.NativeIoException nativeIoException) {
                                    Errors.NativeIoException e = nativeIoException;
                                    if (nativeIoException.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
                                        PortUnreachableException error = new PortUnreachableException(e.getMessage());
                                        error.initCause(e);
                                        throw error;
                                    }
                                    throw e;
                                }
                                if (allocHandle.lastBytesRead() <= 0) {
                                    byteBuf.release();
                                    byteBuf = null;
                                    break;
                                }
                                packet = new DatagramPacket(byteBuf, (InetSocketAddress)this.localAddress(), (InetSocketAddress)this.remoteAddress());
                            } else {
                                DatagramSocketAddress remoteAddress;
                                if (byteBuf.hasMemoryAddress()) {
                                    remoteAddress = KQueueDatagramChannel.this.socket.recvFromAddress(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                                } else {
                                    ByteBuffer nioData;
                                    ByteBuf byteBuf2 = byteBuf;
                                    ByteBuffer byteBuffer = nioData = byteBuf2.internalNioBuffer(byteBuf2.writerIndex(), byteBuf.writableBytes());
                                    remoteAddress = KQueueDatagramChannel.this.socket.recvFrom(byteBuffer, byteBuffer.position(), nioData.limit());
                                }
                                if (remoteAddress == null) {
                                    allocHandle.lastBytesRead(-1);
                                    byteBuf.release();
                                    byteBuf = null;
                                    break;
                                }
                                Object localAddress = remoteAddress.localAddress();
                                if (localAddress == null) {
                                    localAddress = (InetSocketAddress)this.localAddress();
                                }
                                allocHandle.lastBytesRead(remoteAddress.receivedAmount());
                                ByteBuf byteBuf3 = byteBuf;
                                byteBuf3.writerIndex(byteBuf3.writerIndex() + allocHandle.lastBytesRead());
                                packet = new DatagramPacket(byteBuf, (InetSocketAddress)localAddress, (InetSocketAddress)remoteAddress);
                            }
                            allocHandle.incMessagesRead(1);
                            this.readPending = false;
                            pipeline.fireChannelRead((Object)packet);
                            byteBuf = null;
                        } while (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                    }
                    catch (Throwable t) {
                        if (byteBuf != null) {
                            byteBuf.release();
                        }
                        exception = t;
                    }
                    var1_1.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (exception == null) break block19;
                    var3_4.fireExceptionCaught(exception);
                }
                catch (Throwable throwable) {
                    void var2_3;
                    this.readReadyFinally((ChannelConfig)var2_3);
                    throw throwable;
                }
            }
            this.readReadyFinally((ChannelConfig)config);
        }
    }
}

