/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.Native;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class BsdSocket
extends Socket {
    private static final int APPLE_SND_LOW_AT_MAX = 131072;
    private static final int FREEBSD_SND_LOW_AT_MAX = 32768;
    static final int BSD_SND_LOW_AT_MAX = Math.min(131072, 32768);
    private static final int UNSPECIFIED_SOURCE_INTERFACE = 0;

    /*
     * WARNING - void declaration
     */
    BsdSocket(int fd) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setAcceptFilter(AcceptFilter acceptFilter) throws IOException {
        void var1_1;
        BsdSocket.setAcceptFilter(this.intValue(), acceptFilter.filterName(), var1_1.filterArgs());
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpNoPush(boolean tcpNoPush) throws IOException {
        void var1_1;
        BsdSocket.setTcpNoPush(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setSndLowAt(int lowAt) throws IOException {
        void var1_1;
        BsdSocket.setSndLowAt(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTcpFastOpen(boolean enableTcpFastOpen) throws IOException {
        void var1_1;
        BsdSocket.setTcpFastOpen(this.intValue(), var1_1 != false ? 1 : 0);
    }

    final boolean isTcpNoPush() throws IOException {
        return BsdSocket.getTcpNoPush(this.intValue()) != 0;
    }

    final int getSndLowAt() throws IOException {
        return BsdSocket.getSndLowAt(this.intValue());
    }

    /*
     * WARNING - void declaration
     */
    final AcceptFilter getAcceptFilter() throws IOException {
        void var1_1;
        String[] result = BsdSocket.getAcceptFilter(this.intValue());
        if (result == null) {
            return AcceptFilter.PLATFORM_UNSUPPORTED;
        }
        return new AcceptFilter(result[0], (String)var1_1[1]);
    }

    public final boolean isTcpFastOpen() throws IOException {
        return BsdSocket.isTcpFastOpen(this.intValue()) != 0;
    }

    final PeerCredentials getPeerCredentials() throws IOException {
        return BsdSocket.getPeerCredentials(this.intValue());
    }

    /*
     * WARNING - void declaration
     */
    final long sendFile(DefaultFileRegion src, long baseOffset, long offset, long length) throws IOException {
        void var2_2;
        void var1_1;
        src.open();
        long res = BsdSocket.sendFile(this.intValue(), (DefaultFileRegion)var1_1, (long)var2_2, offset, length);
        if (res >= 0L) {
            return res;
        }
        return Errors.ioResult((String)"sendfile", (int)((int)res));
    }

    /*
     * WARNING - void declaration
     */
    final int connectx(InetSocketAddress source, InetSocketAddress destination, IovArray data, boolean tcpFastOpen) throws IOException {
        void var2_4;
        void var1_2;
        int iovDataLength22;
        int iovCount;
        long iovAddress;
        int destinationScopeId;
        byte[] destinationAddress;
        int sourcePort22;
        int sourceScopeId;
        byte[] sourceAddress;
        boolean sourceIPv6;
        int flags;
        ObjectUtil.checkNotNull((Object)destination, (String)"Destination InetSocketAddress cannot be null.");
        int n = flags = tcpFastOpen ? Native.CONNECT_TCP_FASTOPEN : 0;
        if (source == null) {
            sourceIPv6 = false;
            sourceAddress = null;
            sourceScopeId = 0;
            sourcePort22 = 0;
        } else {
            void sourcePort22;
            InetAddress sourceInetAddress = sourcePort22.getAddress();
            sourceIPv6 = BsdSocket.useIpv6((Socket)this, (InetAddress)sourceInetAddress);
            if (sourceInetAddress instanceof Inet6Address) {
                sourceAddress = sourceInetAddress.getAddress();
                sourceScopeId = ((Inet6Address)sourceInetAddress).getScopeId();
            } else {
                sourceScopeId = 0;
                sourceAddress = NativeInetAddress.ipv4MappedIpv6Address((byte[])sourceInetAddress.getAddress());
            }
            sourcePort22 = sourcePort22.getPort();
        }
        InetAddress destinationInetAddress = destination.getAddress();
        boolean destinationIPv6 = BsdSocket.useIpv6((Socket)this, (InetAddress)destinationInetAddress);
        if (destinationInetAddress instanceof Inet6Address) {
            destinationAddress = destinationInetAddress.getAddress();
            destinationScopeId = ((Inet6Address)destinationInetAddress).getScopeId();
        } else {
            destinationScopeId = 0;
            destinationAddress = NativeInetAddress.ipv4MappedIpv6Address((byte[])destinationInetAddress.getAddress());
        }
        int destinationPort = destination.getPort();
        if (data == null || data.count() == 0) {
            iovAddress = 0L;
            iovCount = 0;
            iovDataLength22 = 0;
        } else {
            void iovDataLength22;
            iovAddress = iovDataLength22.memoryAddress(0);
            iovCount = iovDataLength22.count();
            long size = iovDataLength22.size();
            if (size > Integer.MAX_VALUE) {
                throw new IOException("IovArray.size() too big: " + size + " bytes.");
            }
            iovDataLength22 = (int)size;
        }
        int result = BsdSocket.connectx(this.intValue(), 0, sourceIPv6, sourceAddress, sourceScopeId, (int)var1_2, destinationIPv6, destinationAddress, destinationScopeId, (int)var2_4, flags, iovAddress, iovCount, iovDataLength22);
        if (result == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
            void var3_6;
            return (int)(-var3_6);
        }
        if (result < 0) {
            return Errors.ioResult((String)"connectx", (int)result);
        }
        return result;
    }

    public static BsdSocket newSocketStream() {
        return new BsdSocket(BsdSocket.newSocketStream0());
    }

    public static BsdSocket newSocketStream(InternetProtocolFamily protocol) {
        InternetProtocolFamily internetProtocolFamily;
        return new BsdSocket(BsdSocket.newSocketStream0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static BsdSocket newSocketDgram() {
        return new BsdSocket(BsdSocket.newSocketDgram0());
    }

    public static BsdSocket newSocketDgram(InternetProtocolFamily protocol) {
        InternetProtocolFamily internetProtocolFamily;
        return new BsdSocket(BsdSocket.newSocketDgram0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static BsdSocket newSocketDomain() {
        return new BsdSocket(BsdSocket.newSocketDomain0());
    }

    public static BsdSocket newSocketDomainDgram() {
        return new BsdSocket(BsdSocket.newSocketDomainDgram0());
    }

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6) throws IOException;

    private static native int connectx(int var0, int var1, boolean var2, byte[] var3, int var4, int var5, boolean var6, byte[] var7, int var8, int var9, int var10, long var11, int var13, int var14);

    private static native String[] getAcceptFilter(int var0) throws IOException;

    private static native int getTcpNoPush(int var0) throws IOException;

    private static native int getSndLowAt(int var0) throws IOException;

    private static native int isTcpFastOpen(int var0) throws IOException;

    private static native PeerCredentials getPeerCredentials(int var0) throws IOException;

    private static native void setAcceptFilter(int var0, String var1, String var2) throws IOException;

    private static native void setTcpNoPush(int var0, int var1) throws IOException;

    private static native void setSndLowAt(int var0, int var1) throws IOException;

    private static native void setTcpFastOpen(int var0, int var1) throws IOException;
}

