/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.SocketWritableByteChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;

public abstract class AbstractKQueueStreamChannel
extends AbstractKQueueChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractKQueueStreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private WritableByteChannel byteChannel;
    private final Runnable flushTask;

    /*
     * WARNING - void declaration
     */
    AbstractKQueueStreamChannel(Channel parent, BsdSocket fd, boolean active) {
        super((Channel)var1_1, (BsdSocket)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.flushTask = new Runnable(this){
            final /* synthetic */ AbstractKQueueStreamChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                ((AbstractKQueueChannel.AbstractKQueueUnsafe)this.this$0.unsafe()).flush0();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    AbstractKQueueStreamChannel(Channel parent, BsdSocket fd, SocketAddress remote) {
        super((Channel)var1_1, (BsdSocket)var2_2, (SocketAddress)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.flushTask = new /* invalid duplicate definition of identical inner class */;
    }

    /*
     * WARNING - void declaration
     */
    AbstractKQueueStreamChannel(BsdSocket fd) {
        void var1_1;
        void v0 = var1_1;
        this(null, (BsdSocket)v0, AbstractKQueueStreamChannel.isSoErrorZero((BsdSocket)v0));
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytes(ChannelOutboundBuffer in, ByteBuf buf) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            in.remove();
            return 0;
        }
        if (buf.hasMemoryAddress() || buf.nioBufferCount() == 1) {
            return this.doWriteBytes(in, buf);
        }
        ByteBuffer[] nioBuffers = buf.nioBuffers();
        void v0 = var2_2;
        return this.writeBytesMultiple((ChannelOutboundBuffer)var1_1, (ByteBuffer[])v0, ((void)v0).length, (long)var3_3, this.config().getMaxBytesPerGatheringWrite());
    }

    /*
     * WARNING - void declaration
     */
    private void adjustMaxBytesPerGatheringWrite(long attempted, long written, long oldMaxBytesPerGatheringWrite) {
        void var3_2;
        if (attempted == written) {
            if (attempted << 1 > oldMaxBytesPerGatheringWrite) {
                this.config().setMaxBytesPerGatheringWrite(attempted << 1);
                return;
            }
        } else if (attempted > 4096L && var3_2 < attempted >>> 1) {
            void var1_1;
            this.config().setMaxBytesPerGatheringWrite((long)(var1_1 >>> 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytesMultiple(ChannelOutboundBuffer in, IovArray array) throws IOException {
        long expectedWrittenBytes = array.size();
        assert (expectedWrittenBytes != 0L);
        int cnt = array.count();
        assert (cnt != 0);
        long localWrittenBytes = this.socket.writevAddresses(array.memoryAddress(0), cnt);
        if (localWrittenBytes > 0L) {
            void var1_1;
            void var2_2;
            void var3_3;
            this.adjustMaxBytesPerGatheringWrite((long)var3_3, localWrittenBytes, var2_2.maxBytes());
            var1_1.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytesMultiple(ChannelOutboundBuffer in, ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, long maxBytesPerGatheringWrite) throws IOException {
        void var3_3;
        void var2_2;
        long localWrittenBytes;
        assert (expectedWrittenBytes != 0L);
        if (expectedWrittenBytes > maxBytesPerGatheringWrite) {
            expectedWrittenBytes = maxBytesPerGatheringWrite;
        }
        if ((localWrittenBytes = this.socket.writev((ByteBuffer[])var2_2, 0, (int)var3_3, expectedWrittenBytes)) > 0L) {
            void var1_1;
            this.adjustMaxBytesPerGatheringWrite(expectedWrittenBytes, localWrittenBytes, maxBytesPerGatheringWrite);
            var1_1.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeDefaultFileRegion(ChannelOutboundBuffer in, DefaultFileRegion region) throws Exception {
        long regionCount = region.count();
        long offset = region.transferred();
        if (offset >= regionCount) {
            in.remove();
            return 0;
        }
        DefaultFileRegion defaultFileRegion = region;
        long flushedAmount = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), offset, regionCount - offset);
        if (flushedAmount > 0L) {
            void var3_3;
            in.progress(flushedAmount);
            if (region.transferred() >= var3_3) {
                void var1_1;
                var1_1.remove();
            }
            return 1;
        }
        if (flushedAmount == 0L) {
            void var2_2;
            this.validateFileRegion((DefaultFileRegion)var2_2, offset);
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeFileRegion(ChannelOutboundBuffer in, FileRegion region) throws Exception {
        long flushedAmount;
        if (region.transferred() >= region.count()) {
            in.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new KQueueSocketWritableByteChannel();
        }
        if ((flushedAmount = region.transferTo(this.byteChannel, region.transferred())) > 0L) {
            void var2_2;
            void var3_3;
            in.progress((long)var3_3);
            if (region.transferred() >= var2_2.count()) {
                void var1_1;
                var1_1.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var2_2;
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            void var3_3;
            int msgCount;
            if ((msgCount = in.size()) > 1 && in.current() instanceof ByteBuf) {
                writeSpinCount -= this.doWriteMultiple(in);
                continue;
            }
            if (var3_3 == false) {
                this.writeFilter(false);
                return;
            }
            writeSpinCount -= this.doWriteSingle(in);
        } while (writeSpinCount > 0);
        if (var2_2 == false) {
            this.writeFilter(false);
            this.eventLoop().execute(this.flushTask);
            return;
        }
        this.writeFilter(true);
    }

    /*
     * WARNING - void declaration
     */
    protected int doWriteSingle(ChannelOutboundBuffer in) throws Exception {
        Object msg = in.current();
        if (msg instanceof ByteBuf) {
            return this.writeBytes(in, (ByteBuf)msg);
        }
        if (msg instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(in, (DefaultFileRegion)msg);
        }
        if (msg instanceof FileRegion) {
            void var2_2;
            void var1_1;
            return this.writeFileRegion((ChannelOutboundBuffer)var1_1, (FileRegion)var2_2);
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    private int doWriteMultiple(ChannelOutboundBuffer in) throws Exception {
        void var1_1;
        void var2_2;
        long maxBytesPerGatheringWrite = this.config().getMaxBytesPerGatheringWrite();
        IovArray array = ((KQueueEventLoop)this.eventLoop()).cleanArray();
        array.maxBytes((long)var2_2);
        in.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)array);
        if (array.count() > 0) {
            return this.writeBytesMultiple(in, array);
        }
        var1_1.removeBytes(0L);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf)) {
                return this.newDirectBuffer(buf);
            }
            return var1_1;
        }
        if (var1_1 instanceof FileRegion) {
            return var1_1;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public ChannelFuture shutdownOutput() {
        AbstractKQueueStreamChannel abstractKQueueStreamChannel = this;
        return abstractKQueueStreamChannel.shutdownOutput(abstractKQueueStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        void var1_1;
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractKQueueStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)this.this$0.unsafe()).shutdownOutput(this.val$promise);
                }
            });
        }
        return var1_1;
    }

    public ChannelFuture shutdownInput() {
        AbstractKQueueStreamChannel abstractKQueueStreamChannel = this;
        return abstractKQueueStreamChannel.shutdownInput(abstractKQueueStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdownInput(ChannelPromise promise) {
        void var1_1;
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractKQueueStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractKQueueStreamChannel.access$000(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownInput0(ChannelPromise promise) {
        void var1_1;
        try {
            this.socket.shutdown(true, false);
        }
        catch (Throwable cause) {
            void var2_2;
            promise.setFailure((Throwable)var2_2);
            return;
        }
        var1_1.setSuccess();
    }

    public ChannelFuture shutdown() {
        AbstractKQueueStreamChannel abstractKQueueStreamChannel = this;
        return abstractKQueueStreamChannel.shutdown(abstractKQueueStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdown(ChannelPromise promise) {
        void var1_1;
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            void var2_2;
            var2_2.addListener((GenericFutureListener)new ChannelFutureListener(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractKQueueStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    void var1_1;
                    AbstractKQueueStreamChannel.access$100(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractKQueueStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
            return;
        }
        var3_3.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelFuture)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelFuture val$shutdownOutputFuture;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ AbstractKQueueStreamChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$shutdownOutputFuture = channelFuture;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                void var1_1;
                AbstractKQueueStreamChannel.access$200(this.val$shutdownOutputFuture, (ChannelFuture)var1_1, this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        void var2_2;
        Object shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            Object object;
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure((Throwable)object);
            return;
        }
        if (shutdownInputCause != null) {
            void var1_1;
            promise.setFailure((Throwable)var1_1);
            return;
        }
        var2_2.setSuccess();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AbstractKQueueStreamChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownInput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(AbstractKQueueStreamChannel x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.shutdownOutputDone((ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(ChannelFuture x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        AbstractKQueueStreamChannel.shutdownDone(x0, (ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    private final class KQueueSocketWritableByteChannel
    extends SocketWritableByteChannel {
        KQueueSocketWritableByteChannel() {
            super((FileDescriptor)AbstractKQueueStreamChannel.this.socket);
        }

        protected final ByteBufAllocator alloc() {
            return AbstractKQueueStreamChannel.this.alloc();
        }
    }

    class KQueueStreamUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        /*
         * WARNING - void declaration
         */
        KQueueStreamUnsafe() {
            void var1_1;
        }

        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            KQueueChannelConfig config;
            block7: {
                config = AbstractKQueueStreamChannel.this.config();
                if (AbstractKQueueStreamChannel.this.shouldBreakReadReady((ChannelConfig)config)) {
                    this.clearReadFilter0();
                    return;
                }
                ChannelPipeline pipeline = AbstractKQueueStreamChannel.this.pipeline();
                ByteBufAllocator allocator = config.getAllocator();
                allocHandle.reset((ChannelConfig)config);
                this.readReadyBefore();
                ByteBuf byteBuf = null;
                boolean close = false;
                try {
                    do {
                        byteBuf = allocHandle.allocate(allocator);
                        allocHandle.lastBytesRead(AbstractKQueueStreamChannel.this.doReadBytes(byteBuf));
                        if (allocHandle.lastBytesRead() <= 0) {
                            byteBuf.release();
                            byteBuf = null;
                            close = allocHandle.lastBytesRead() < 0;
                            if (!close) break;
                            this.readPending = false;
                            break;
                        }
                        allocHandle.incMessagesRead(1);
                        this.readPending = false;
                        pipeline.fireChannelRead((Object)byteBuf);
                        byteBuf = null;
                    } while (!AbstractKQueueStreamChannel.this.shouldBreakReadReady((ChannelConfig)config) && allocHandle.continueReading());
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (!close) break block7;
                    this.shutdownInput(false);
                }
                catch (Throwable t) {
                    try {
                        void var1_1;
                        void var3_4;
                        this.handleReadException((ChannelPipeline)var3_4, byteBuf, t, close, (KQueueRecvByteAllocatorHandle)var1_1);
                    }
                    catch (Throwable throwable) {
                        void var2_3;
                        this.readReadyFinally((ChannelConfig)var2_3);
                        throw throwable;
                    }
                    this.readReadyFinally((ChannelConfig)config);
                    return;
                }
            }
            this.readReadyFinally((ChannelConfig)config);
            return;
        }

        /*
         * WARNING - void declaration
         */
        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, KQueueRecvByteAllocatorHandle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    void var2_2;
                    var2_2.release();
                }
            }
            if (!this.failConnectPromise(cause)) {
                void var3_3;
                void var1_1;
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                var1_1.fireExceptionCaught(cause);
                if (close || cause instanceof OutOfMemoryError || var3_3 instanceof IOException) {
                    this.shutdownInput(false);
                }
            }
        }
    }
}

