/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.ServerChannel;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractKQueueServerChannel
extends AbstractKQueueChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);

    /*
     * WARNING - void declaration
     */
    AbstractKQueueServerChannel(BsdSocket fd) {
        void var1_1;
        void v0 = var1_1;
        this((BsdSocket)v0, AbstractKQueueServerChannel.isSoErrorZero((BsdSocket)v0));
    }

    /*
     * WARNING - void declaration
     */
    AbstractKQueueServerChannel(BsdSocket fd, boolean active) {
        super(null, (BsdSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof KQueueEventLoop;
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueServerSocketUnsafe();
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    abstract Channel newChildChannel(int var1, byte[] var2, int var3, int var4) throws Exception;

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    final class KQueueServerSocketUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        private final byte[] acceptedAddress;

        /*
         * WARNING - void declaration
         */
        KQueueServerSocketUnsafe() {
            void var1_1;
            super((AbstractKQueueChannel)var1_1);
            this.acceptedAddress = new byte[26];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            KQueueChannelConfig config;
            block9: {
                assert (AbstractKQueueServerChannel.this.eventLoop().inEventLoop());
                config = AbstractKQueueServerChannel.this.config();
                if (AbstractKQueueServerChannel.this.shouldBreakReadReady((ChannelConfig)config)) {
                    this.clearReadFilter0();
                    return;
                }
                ChannelPipeline pipeline = AbstractKQueueServerChannel.this.pipeline();
                allocHandle.reset((ChannelConfig)config);
                allocHandle.attemptedBytesRead(1);
                this.readReadyBefore();
                Throwable exception = null;
                try {
                    void var3_4;
                    void var1_1;
                    try {
                        do {
                            int acceptFd;
                            if ((acceptFd = AbstractKQueueServerChannel.this.socket.accept(this.acceptedAddress)) == -1) {
                                allocHandle.lastBytesRead(-1);
                                break;
                            }
                            allocHandle.lastBytesRead(1);
                            allocHandle.incMessagesRead(1);
                            this.readPending = false;
                            pipeline.fireChannelRead((Object)AbstractKQueueServerChannel.this.newChildChannel(acceptFd, this.acceptedAddress, 1, this.acceptedAddress[0]));
                        } while (allocHandle.continueReading());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        exception = throwable;
                    }
                    var1_1.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (exception == null) break block9;
                    var3_4.fireExceptionCaught(exception);
                }
                catch (Throwable throwable) {
                    void var2_3;
                    this.readReadyFinally((ChannelConfig)var2_3);
                    throw throwable;
                }
            }
            this.readReadyFinally((ChannelConfig)config);
        }
    }
}

