/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueDomainSocketChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.kqueue.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.TimeUnit;

abstract class AbstractKQueueChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    final BsdSocket socket;
    private boolean readFilterEnabled;
    private boolean writeFilterEnabled;
    boolean readReadyRunnablePending;
    boolean inputClosedSeenErrorOnRead;
    protected volatile boolean active;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;

    /*
     * WARNING - void declaration
     */
    AbstractKQueueChannel(Channel parent, BsdSocket fd, boolean active) {
        super((Channel)var1_1);
        void var3_3;
        void var1_1;
        this.socket = (BsdSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)fd), (String)"fd"));
        this.active = active;
        if (var3_3 != false) {
            void var2_2;
            this.local = fd.localAddress();
            this.remote = var2_2.remoteAddress();
        }
    }

    /*
     * WARNING - void declaration
     */
    AbstractKQueueChannel(Channel parent, BsdSocket fd, SocketAddress remote) {
        super((Channel)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.socket = (BsdSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)fd), (String)"fd"));
        this.active = true;
        this.remote = var3_3;
        this.local = var2_2.localAddress();
    }

    /*
     * WARNING - void declaration
     */
    static boolean isSoErrorZero(BsdSocket fd) {
        try {
            return fd.getSoError() == 0;
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException((Throwable)var0_1);
        }
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected void doClose() throws Exception {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        this.socket.close();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof KQueueEventLoop;
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    protected void doDeregister() throws Exception {
        ((KQueueEventLoop)this.eventLoop()).remove(this);
        this.readFilterEnabled = false;
        this.writeFilterEnabled = false;
    }

    void unregisterFilters() throws Exception {
        this.readFilter(false);
        this.writeFilter(false);
        this.clearRdHup0();
    }

    private void clearRdHup0() {
        this.evSet0(Native.EVFILT_SOCK, Native.EV_DELETE_DISABLE, Native.NOTE_RDHUP);
    }

    /*
     * WARNING - void declaration
     */
    protected final void doBeginRead() throws Exception {
        AbstractKQueueUnsafe unsafe = (AbstractKQueueUnsafe)this.unsafe();
        ((AbstractKQueueUnsafe)this.unsafe()).readPending = true;
        this.readFilter(true);
        if (unsafe.maybeMoreDataToRead) {
            void var1_1;
            var1_1.executeReadReadyRunnable((ChannelConfig)this.config());
        }
    }

    protected void doRegister() throws Exception {
        this.readReadyRunnablePending = false;
        ((KQueueEventLoop)this.eventLoop()).add(this);
        if (this.writeFilterEnabled) {
            this.evSet0(Native.EVFILT_WRITE, Native.EV_ADD_CLEAR_ENABLE);
        }
        if (this.readFilterEnabled) {
            this.evSet0(Native.EVFILT_READ, Native.EV_ADD_CLEAR_ENABLE);
        }
        this.evSet0(Native.EVFILT_SOCK, Native.EV_ADD, Native.NOTE_RDHUP);
    }

    protected abstract AbstractKQueueUnsafe newUnsafe();

    public abstract KQueueChannelConfig config();

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(ByteBuf buf) {
        void var1_1;
        void v0 = var1_1;
        return this.newDirectBuffer(v0, (ByteBuf)v0);
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(Object holder, ByteBuf buf) {
        void var1_1;
        void var3_3;
        void var2_2;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.release((Object)holder);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            return AbstractKQueueChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        ByteBuf directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf == null) {
            return AbstractKQueueChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        void v0 = var2_2;
        directBuf.writeBytes((ByteBuf)v0, v0.readerIndex(), (int)var3_3);
        ReferenceCountUtil.safeRelease((Object)var1_1);
        return directBuf;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf newDirectBuffer0(Object holder, ByteBuf buf, ByteBufAllocator alloc, int capacity) {
        void var2_2;
        Object object;
        void var3_3;
        void var1_1;
        ByteBuf directBuf = alloc.directBuffer(capacity);
        void v0 = var1_1;
        directBuf.writeBytes((ByteBuf)v0, v0.readerIndex(), (int)var3_3);
        ReferenceCountUtil.safeRelease((Object)object);
        return var2_2;
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int doReadBytes(ByteBuf byteBuf) throws Exception {
        void var3_3;
        int localReadAmount;
        int writerIndex = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            localReadAmount = this.socket.readAddress(byteBuf.memoryAddress(), writerIndex, byteBuf.capacity());
        } else {
            ByteBuffer buf;
            ByteBuffer byteBuffer = buf = byteBuf.internalNioBuffer(writerIndex, byteBuf.writableBytes());
            localReadAmount = this.socket.read(byteBuffer, byteBuffer.position(), buf.limit());
        }
        if (localReadAmount > 0) {
            void var2_2;
            void var1_1;
            var1_1.writerIndex((int)(var2_2 + localReadAmount));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected final int doWriteBytes(ChannelOutboundBuffer in, ByteBuf buf) throws Exception {
        if (buf.hasMemoryAddress()) {
            int localFlushedAmount = this.socket.writeAddress(buf.memoryAddress(), buf.readerIndex(), buf.writerIndex());
            if (localFlushedAmount > 0) {
                in.removeBytes((long)localFlushedAmount);
                return 1;
            }
        } else {
            ByteBuffer nioBuf;
            ByteBuffer byteBuffer;
            void localFlushedAmount;
            if (localFlushedAmount.nioBufferCount() == 1) {
                void v0 = localFlushedAmount;
                byteBuffer = v0.internalNioBuffer(v0.readerIndex(), localFlushedAmount.readableBytes());
            } else {
                byteBuffer = localFlushedAmount.nioBuffer();
            }
            ByteBuffer byteBuffer2 = nioBuf = byteBuffer;
            int localFlushedAmount2 = this.socket.write(byteBuffer2, byteBuffer2.position(), nioBuf.limit());
            if (localFlushedAmount2 > 0) {
                void var3_4;
                void var1_1;
                void var2_2;
                void v3 = var2_2;
                v3.position(v3.position() + localFlushedAmount2);
                var1_1.removeBytes((long)var3_4);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    final boolean shouldBreakReadReady(ChannelConfig config) {
        void var1_1;
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractKQueueChannel.isAllowHalfClosure((ChannelConfig)var1_1));
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        ChannelConfig channelConfig;
        if (config instanceof KQueueDomainSocketChannelConfig) {
            return ((KQueueDomainSocketChannelConfig)config).isAllowHalfClosure();
        }
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void clearReadFilter() {
        void var2_2;
        void var1_1;
        if (!this.isRegistered()) {
            this.readFilterEnabled = false;
            return;
        }
        EventLoop loop = this.eventLoop();
        AbstractKQueueUnsafe unsafe = (AbstractKQueueUnsafe)this.unsafe();
        if (loop.inEventLoop()) {
            unsafe.clearReadFilter0();
            return;
        }
        var1_1.execute(new Runnable(this, (AbstractKQueueUnsafe)var2_2){
            final /* synthetic */ AbstractKQueueUnsafe val$unsafe;
            final /* synthetic */ AbstractKQueueChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$unsafe = abstractKQueueUnsafe;
            }

            @Override
            public void run() {
                if (!this.val$unsafe.readPending && !this.this$0.config().isAutoRead()) {
                    this.val$unsafe.clearReadFilter0();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    void readFilter(boolean readFilterEnabled) throws IOException {
        if (this.readFilterEnabled != readFilterEnabled) {
            void var1_1;
            this.readFilterEnabled = readFilterEnabled;
            this.evSet(Native.EVFILT_READ, var1_1 != false ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeFilter(boolean writeFilterEnabled) throws IOException {
        if (this.writeFilterEnabled != writeFilterEnabled) {
            void var1_1;
            this.writeFilterEnabled = writeFilterEnabled;
            this.evSet(Native.EVFILT_WRITE, var1_1 != false ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evSet(short filter, short flags) {
        if (this.isRegistered()) {
            void var2_2;
            void var1_1;
            this.evSet0((short)var1_1, (short)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evSet0(short filter, short flags) {
        void var2_2;
        void var1_1;
        this.evSet0((short)var1_1, (short)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void evSet0(short filter, short flags, int fflags) {
        if (this.isOpen()) {
            void var3_3;
            void var2_2;
            void var1_1;
            ((KQueueEventLoop)this.eventLoop()).evSet(this, (short)var1_1, (short)var2_2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doBind(SocketAddress local) throws Exception {
        void var1_1;
        if (local instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind((SocketAddress)var1_1);
        this.local = this.socket.localAddress();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        void var2_3;
        boolean connected;
        InetSocketAddress remoteSocketAddr;
        if (localAddress instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        if ((remoteSocketAddr = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null) != null) {
            AbstractKQueueChannel.checkResolvable(remoteSocketAddr);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        if (connected = this.doConnect0(remoteAddress, localAddress)) {
            void var3_4;
            void var1_1;
            this.remote = remoteSocketAddr == null ? var1_1 : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)var3_4, (InetSocketAddress)this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doConnect0(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        boolean success = false;
        try {
            void var1_2;
            boolean connected = this.socket.connect(remoteAddress);
            if (!connected) {
                this.writeFilter(true);
            }
            success = true;
            return (boolean)var1_2;
        }
        catch (Throwable throwable) {
            void var2_5;
            if (var2_5 == false) {
                this.doClose();
            }
            throw throwable;
        }
    }

    protected SocketAddress localAddress0() {
        return this.local;
    }

    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelPromise access$002(AbstractKQueueChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.connectPromise = var1_1;
        return x0.connectPromise;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$402(AbstractKQueueChannel x0, SocketAddress x1) {
        void var1_1;
        x0.requestedRemoteAddress = var1_1;
        return x0.requestedRemoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$502(AbstractKQueueChannel x0, Future x1) {
        void var1_1;
        x0.connectTimeoutFuture = var1_1;
        return x0.connectTimeoutFuture;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$602(AbstractKQueueChannel x0, SocketAddress x1) {
        void var1_1;
        x0.remote = var1_1;
        return x0.remote;
    }

    public abstract class AbstractKQueueUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        private KQueueRecvByteAllocatorHandle allocHandle;
        private final Runnable readReadyRunnable;

        /*
         * WARNING - void declaration
         */
        public AbstractKQueueUnsafe() {
            void var1_1;
            super((AbstractChannel)var1_1);
            this.readReadyRunnable = new Runnable(this){
                final /* synthetic */ AbstractKQueueUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public void run() {
                    this.this$1.AbstractKQueueChannel.this.readReadyRunnablePending = false;
                    this.this$1.readReady(this.this$1.recvBufAllocHandle());
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        final void readReady(long numberBytesPending) {
            void var3_2;
            void var1_1;
            KQueueRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.numberBytesPending((long)var1_1);
            this.readReady((KQueueRecvByteAllocatorHandle)var3_2);
        }

        abstract void readReady(KQueueRecvByteAllocatorHandle var1);

        final void readReadyBefore() {
            this.maybeMoreDataToRead = false;
        }

        /*
         * WARNING - void declaration
         */
        final void readReadyFinally(ChannelConfig config) {
            void var1_1;
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (this.allocHandle.isReadEOF() || this.readPending && this.maybeMoreDataToRead) {
                this.executeReadReadyRunnable(config);
                return;
            }
            if (!this.readPending && !var1_1.isAutoRead()) {
                this.clearReadFilter0();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean failConnectPromise(Throwable cause) {
            if (AbstractKQueueChannel.this.connectPromise != null) {
                void var1_1;
                void var2_2;
                ChannelPromise connectPromise = AbstractKQueueChannel.this.connectPromise;
                AbstractKQueueChannel.access$002(AbstractKQueueChannel.this, null);
                if (var2_2.tryFailure(cause instanceof ConnectException ? cause : new ConnectException("failed to connect").initCause((Throwable)var1_1))) {
                    this.closeIfClosed();
                    return true;
                }
            }
            return false;
        }

        final void writeReady() {
            if (AbstractKQueueChannel.this.connectPromise != null) {
                this.finishConnect();
                return;
            }
            if (!AbstractKQueueChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        /*
         * WARNING - void declaration
         */
        void shutdownInput(boolean readEOF) {
            void var1_1;
            if (readEOF && AbstractKQueueChannel.this.connectPromise != null) {
                this.finishConnect();
            }
            if (!AbstractKQueueChannel.this.socket.isInputShutdown()) {
                if (AbstractKQueueChannel.isAllowHalfClosure((ChannelConfig)AbstractKQueueChannel.this.config())) {
                    try {
                        AbstractKQueueChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException iOException) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {}
                    this.clearReadFilter0();
                    AbstractKQueueChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
                return;
            }
            if (var1_1 == false && !AbstractKQueueChannel.this.inputClosedSeenErrorOnRead) {
                AbstractKQueueChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractKQueueChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        /*
         * WARNING - void declaration
         */
        final void readEOF() {
            KQueueRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.readEOF();
            if (AbstractKQueueChannel.this.isActive()) {
                void var1_1;
                this.readReady((KQueueRecvByteAllocatorHandle)var1_1);
            } else {
                this.shutdownInput(true);
            }
            AbstractKQueueChannel.this.clearRdHup0();
        }

        public KQueueRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = new KQueueRecvByteAllocatorHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        protected final void flush0() {
            if (!AbstractKQueueChannel.this.writeFilterEnabled) {
                super.flush0();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void executeReadReadyRunnable(ChannelConfig config) {
            void var1_1;
            if (AbstractKQueueChannel.this.readReadyRunnablePending || !AbstractKQueueChannel.this.isActive() || AbstractKQueueChannel.this.shouldBreakReadReady((ChannelConfig)var1_1)) {
                return;
            }
            AbstractKQueueChannel.this.readReadyRunnablePending = true;
            AbstractKQueueChannel.this.eventLoop().execute(this.readReadyRunnable);
        }

        /*
         * WARNING - void declaration
         */
        protected final void clearReadFilter0() {
            assert (AbstractKQueueChannel.this.eventLoop().inEventLoop());
            try {
                this.readPending = false;
                AbstractKQueueChannel.this.readFilter(false);
                return;
            }
            catch (IOException e) {
                void var1_1;
                AbstractKQueueChannel.this.pipeline().fireExceptionCaught((Throwable)var1_1);
                AbstractKQueueChannel.this.unsafe().close(AbstractKQueueChannel.this.unsafe().voidPromise());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fireEventAndClose(Object evt) {
            void var1_1;
            AbstractKQueueChannel.this.pipeline().fireUserEventTriggered((Object)var1_1);
            AbstractKQueueUnsafe abstractKQueueUnsafe = this;
            abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
        }

        /*
         * WARNING - void declaration
         */
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (promise.isDone() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractKQueueChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean wasActive = AbstractKQueueChannel.this.isActive();
                if (!AbstractKQueueChannel.this.doConnect(remoteAddress, localAddress)) {
                    AbstractKQueueChannel.access$002(AbstractKQueueChannel.this, promise);
                    AbstractKQueueChannel.access$402(AbstractKQueueChannel.this, remoteAddress);
                    int connectTimeoutMillis = AbstractKQueueChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        void var2_3;
                        AbstractKQueueChannel.access$502(AbstractKQueueChannel.this, (Future)AbstractKQueueChannel.this.eventLoop().schedule(new Runnable(this, connectTimeoutMillis, remoteAddress){
                            final /* synthetic */ int val$connectTimeoutMillis;
                            final /* synthetic */ SocketAddress val$remoteAddress;
                            final /* synthetic */ AbstractKQueueUnsafe this$1;
                            {
                                void var1_1;
                                this.this$1 = var1_1;
                                this.val$connectTimeoutMillis = n;
                                this.val$remoteAddress = socketAddress;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void run() {
                                void var1_1;
                                ChannelPromise connectPromise = this.this$1.AbstractKQueueChannel.this.connectPromise;
                                if (connectPromise != null && !connectPromise.isDone() && var1_1.tryFailure((Throwable)new ConnectTimeoutException("connection timed out after " + this.val$connectTimeoutMillis + " ms: " + this.val$remoteAddress))) {
                                    this.this$1.close(this.this$1.voidPromise());
                                }
                            }
                        }, (long)var2_3, TimeUnit.MILLISECONDS));
                    }
                    promise.addListener((GenericFutureListener)new ChannelFutureListener(this){
                        final /* synthetic */ AbstractKQueueUnsafe this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        public void operationComplete(ChannelFuture future) {
                            if (future.isCancelled()) {
                                if (this.this$1.AbstractKQueueChannel.this.connectTimeoutFuture != null) {
                                    this.this$1.AbstractKQueueChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractKQueueChannel.access$002(this.this$1.AbstractKQueueChannel.this, null);
                                this.this$1.close(this.this$1.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(promise, wasActive);
            }
            catch (Throwable t) {
                void var1_1;
                void var3_4;
                this.closeIfClosed();
                var3_4.tryFailure(this.annotateConnectException(t, (SocketAddress)var1_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            void var1_2;
            void var3_4;
            void var2_3;
            if (promise == null) {
                return;
            }
            AbstractKQueueChannel.this.active = true;
            boolean active = AbstractKQueueChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (var2_3 == false && var3_4 != false) {
                AbstractKQueueChannel.this.pipeline().fireChannelActive();
            }
            if (var1_2 == false) {
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            void var2_2;
            void var1_1;
            if (promise == null) {
                return;
            }
            var1_1.tryFailure((Throwable)var2_2);
            this.closeIfClosed();
        }

        /*
         * WARNING - void declaration
         */
        private void finishConnect() {
            assert (AbstractKQueueChannel.this.eventLoop().inEventLoop());
            try {
                boolean wasActive = AbstractKQueueChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    return;
                }
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.fulfillConnectPromise(abstractKQueueUnsafe.AbstractKQueueChannel.this.connectPromise, wasActive);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.fulfillConnectPromise(abstractKQueueUnsafe.AbstractKQueueChannel.this.connectPromise, this.annotateConnectException((Throwable)var1_2, AbstractKQueueChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractKQueueChannel.this.connectTimeoutFuture != null) {
                    AbstractKQueueChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractKQueueChannel.access$002(AbstractKQueueChannel.this, null);
            }
        }

        private boolean doFinishConnect() throws Exception {
            if (AbstractKQueueChannel.this.socket.finishConnect()) {
                AbstractKQueueChannel.this.writeFilter(false);
                if (AbstractKQueueChannel.this.requestedRemoteAddress instanceof InetSocketAddress) {
                    AbstractKQueueChannel.access$602(AbstractKQueueChannel.this, UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)AbstractKQueueChannel.this.requestedRemoteAddress), (InetSocketAddress)AbstractKQueueChannel.this.socket.remoteAddress()));
                }
                AbstractKQueueChannel.access$402(AbstractKQueueChannel.this, null);
                return true;
            }
            AbstractKQueueChannel.this.writeFilter(true);
            return false;
        }
    }
}

