/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import kotlinx.serialization.json.internal.InternalJsonReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\rH\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0014J\u001a\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0006\u0010,\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "getReader", "()Lkotlinx/serialization/json/internal/InternalJsonReader;", "getBuffer", "()[C", "threshold", "", "source", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "canConsumeValue", "", "preload", "", "unprocessedCount", "prefetchOrEof", "position", "consumeNextToken", "", "expected", "", "skipWhitespaces", "ensureHaveChars", "consumeKeyString", "", "indexOf", "char", "startPos", "substring", "endPos", "appendRange", "fromIndex", "toIndex", "peekLeadingMatchingValue", "keyToMatch", "isLenient", "release", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nReaderJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n*L\n1#1,221:1\n158#2:222\n158#2:223\n158#2:224\n*S KotlinDebug\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n*L\n66#1:222\n133#1:223\n150#1:224\n*E\n"})
public class ReaderJsonLexer
extends AbstractJsonLexer {
    private final InternalJsonReader reader;
    private final char[] buffer;
    @JvmField
    protected int threshold;
    private final ArrayAsSequence source;

    /*
     * WARNING - void declaration
     */
    public ReaderJsonLexer(InternalJsonReader reader, char[] buffer) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.reader = var1_1;
        this.buffer = var2_2;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    public final InternalJsonReader getReader() {
        return this.reader;
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    @Override
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canConsumeValue() {
        void var1_1;
        ((AbstractJsonLexer)this).ensureHaveChars();
        int current = this.currentPosition;
        while ((current = ((AbstractJsonLexer)this).prefetchOrEof(current)) != -1) {
            void var2_2;
            void var3_3;
            char c = this.getSource().charAt(current);
            char $this$isWs$iv = c;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || var3_3 == 9) {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart((char)var2_2);
        }
        this.currentPosition = var1_1;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void preload(int unprocessedCount) {
        void filledCount;
        char[] buffer = this.getSource().getBuffer$kotlinx_serialization_json();
        if (unprocessedCount != 0) {
            ArraysKt.copyInto((char[])buffer, (char[])buffer, (int)0, (int)this.currentPosition, (int)(this.currentPosition + unprocessedCount));
        }
        int sizeTotal = this.getSource().length();
        while (filledCount != sizeTotal) {
            int actual = this.reader.read(buffer, (int)filledCount, sizeTotal - filledCount);
            if (actual == -1) {
                this.getSource().trim((int)filledCount);
                this.threshold = -1;
                break;
            }
            filledCount += actual;
        }
        this.currentPosition = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int prefetchOrEof(int position) {
        void var1_1;
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = var1_1;
        ((AbstractJsonLexer)this).ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte consumeNextToken() {
        void var2_2;
        ((AbstractJsonLexer)this).ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = ((AbstractJsonLexer)this).prefetchOrEof(cpos)) != -1) {
            byte by;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass((char)(by = source.charAt(cpos++)))) == 3) continue;
            this.currentPosition = cpos;
            return by;
        }
        this.currentPosition = var2_2;
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void consumeNextToken(char expected) {
        void var1_1;
        void var3_3;
        ((AbstractJsonLexer)this).ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = ((AbstractJsonLexer)this).prefetchOrEof(cpos)) != -1) {
            char c = source.charAt(cpos++);
            char $this$isWs$iv = c;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = var3_3;
        this.unexpectedToken((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int skipWhitespaces() {
        void var1_1;
        int current = this.currentPosition;
        while ((current = ((AbstractJsonLexer)this).prefetchOrEof(current)) != -1) {
            void var2_2;
            char c = this.getSource().charAt(current);
            char $this$isWs$iv = c;
            if (!($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || var2_2 == 9)) break;
            ++current;
        }
        this.currentPosition = current;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ensureHaveChars() {
        void var1_1;
        int cur = this.currentPosition;
        int n = this.getSource().length();
        int spaceLeft = n - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String consumeKeyString() {
        void var2_2;
        void var1_1;
        ((AbstractJsonLexer)this).consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = ((AbstractJsonLexer)this).indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = ((AbstractJsonLexer)this).prefetchOrEof(current)) == -1) {
                AbstractJsonLexer.fail$kotlinx_serialization_json$default(this, (byte)1, false, 2, null);
                throw new KotlinNothingValueException();
            }
            ReaderJsonLexer readerJsonLexer = this;
            return readerJsonLexer.consumeString(readerJsonLexer.getSource(), this.currentPosition, current);
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            ReaderJsonLexer readerJsonLexer = this;
            return readerJsonLexer.consumeString(readerJsonLexer.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return ((AbstractJsonLexer)this).substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(char c, int startPos) {
        void i;
        ArrayAsSequence src = this.getSource();
        int n = src.length();
        while (i < n) {
            if (src.charAt((int)i) == c) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String substring(int startPos, int endPos) {
        void var2_2;
        void var1_1;
        return this.getSource().substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), fromIndex, (int)(var2_2 - var1_1)), (String)"append(...)");
    }

    @Override
    public String peekLeadingMatchingValue(String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

