/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "polymorphicDiscriminator", "", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "position", "", "forceNull", "", "coerceInputValue", "descriptor", "index", "tag", "decodeElementIndex", "absenceIsNull", "decodeNotNullMark", "elementName", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nTreeJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n+ 2 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 3 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt$tryCoerceValue$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/AbstractJsonTreeDecoder\n+ 6 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,334:1\n125#2,22:335\n147#2,4:358\n131#3:357\n1#4:362\n74#5:363\n271#6,8:364\n*S KotlinDebug\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n*L\n200#1:335,22\n200#1:358,4\n200#1:357\n262#1:363\n262#1:364,8\n*E\n"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    private final JsonObject value;
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    /*
     * WARNING - void declaration
     */
    public JsonTreeDecoder(Json json, JsonObject value, String polymorphicDiscriminator, SerialDescriptor polyDescriptor) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super((Json)var1_1, value, (String)var3_3, null);
        this.value = var2_2;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor, int index2, String tag) {
        Json $this$tryCoerceValue_u24default$iv = this.getJson();
        boolean isOptional$iv = descriptor.isElementOptional(index2);
        SerialDescriptor elementDescriptor$iv = descriptor.getElementDescriptor(index2);
        if (isOptional$iv && !elementDescriptor$iv.isNullable() && this.currentElement(tag) instanceof JsonNull) {
            return true;
        }
        if (!(!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE) || elementDescriptor$iv.isNullable() && this.currentElement(tag) instanceof JsonNull)) {
            void var3_6;
            JsonElement index2 = this.currentElement((String)var3_6);
            JsonPrimitive jsonPrimitive = index2 instanceof JsonPrimitive ? (JsonPrimitive)index2 : null;
            String string = jsonPrimitive != null ? JsonElementKt.getContentOrNull(jsonPrimitive) : null;
            if (string != null) {
                void var1_2;
                void var2_5;
                boolean coerceToNull$iv;
                String enumValue$iv = string;
                int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue_u24default$iv, enumValue$iv);
                boolean bl = coerceToNull$iv = !$this$tryCoerceValue_u24default$iv.getConfiguration().getExplicitNulls() && elementDescriptor$iv.isNullable();
                if (var2_5 == -3 && (isOptional$iv || var1_2 != false)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        while (this.position < descriptor.getElementsCount()) {
            void var2_2;
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor, index, (String)var2_2)) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean absenceIsNull(SerialDescriptor descriptor, int index) {
        void var2_2;
        void var1_1;
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor.isElementOptional(index) && var1_1.getElementDescriptor((int)var2_2).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    /*
     * WARNING - void declaration
     */
    protected String elementName(SerialDescriptor descriptor, int index) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object v1;
        Object object;
        String baseName;
        block6: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
            baseName = descriptor.getElementName(index);
            if (strategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return baseName;
                }
                if (this.getValue().keySet().contains(baseName)) {
                    return baseName;
                }
            }
            Map<String, Integer> deserializationNamesMap = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor);
            object = this.getValue().keySet();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                String it = (String)e;
                Integer n = deserializationNamesMap.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            object = string;
            return object;
        }
        void v2 = var3_3;
        string = v2 != null ? v2.serialNameForJson((SerialDescriptor)var1_1, (int)var2_2, baseName) : null;
        String string2 = string;
        if (string == null) {
            string2 = baseName;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected JsonElement currentElement(String tag) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor == this.polyDescriptor) {
            void value$iv;
            descriptor = this;
            JsonElement jsonElement = this.currentObject();
            Object object = this.polyDescriptor;
            String serialName$iv$iv = object.getSerialName();
            if (!(value$iv instanceof JsonObject)) {
                object = new StringBuilder("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append((String)object).append(" at element: ");
                string = AbstractJsonTreeDecoder.access$renderTagStack((AbstractJsonTreeDecoder)((Object)string));
                throw JsonExceptionsKt.JsonDecodingException(-1, ((StringBuilder)object).append(string).toString(), value$iv.toString());
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)jsonElement, this.getPolymorphicDiscriminator(), this.polyDescriptor);
        }
        return super.beginStructure((SerialDescriptor)string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Iterator<String> iterator;
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
        if (strategy == null && !this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor);
        } else if (iterator != null) {
            set = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor).keySet();
        } else {
            Set set2 = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor);
            Map<String, Integer> map = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set set3 = map != null ? map.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus((Set)set2, (Iterable)set3);
        }
        Set names = set;
        for (String key : this.getValue().keySet()) {
            void var3_3;
            if (names.contains(key) || Intrinsics.areEqual((Object)key, (Object)this.getPolymorphicDiscriminator())) continue;
            throw JsonExceptionsKt.UnknownKeyException((String)var3_3, this.getValue().toString());
        }
    }
}

