/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;
import kotlinx.serialization.json.internal.JsonNamesMapKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u001a'\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0012*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0000\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u0000\u001ac\u0010\u001e\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b!\u0012\b\b\u0018\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001a0 2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030$2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020&0$H\u0080\b\u00f8\u0001\u0000\"&\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\" \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"JsonDeserializationNamesKey", "Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "", "", "", "getJsonDeserializationNamesKey", "()Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "JsonSerializationNamesKey", "", "getJsonSerializationNamesKey", "buildDeserializationNamesMap", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lkotlinx/serialization/json/Json;", "deserializationNamesMap", "descriptor", "serializationNamesIndices", "strategy", "Lkotlinx/serialization/json/JsonNamingStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonNamingStrategy;)[Ljava/lang/String;", "getJsonElementName", "index", "namingStrategy", "getJsonNameIndexSlowPath", "name", "decodeCaseInsensitive", "", "getJsonNameIndex", "getJsonNameIndexOrThrow", "suffix", "tryCoerceValue", "peekNull", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "consume", "peekString", "Lkotlin/Function0;", "onEnumCoercing", "", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJsonNamesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n808#2,11:153\n13409#3,2:164\n1#4:166\n*S KotlinDebug\n*F\n+ 1 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n*L\n35#1:153,11\n35#1:164,2\n*E\n"})
public final class JsonNamesMapKt {
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonDeserializationNamesKey = new DescriptorSchemaCache.Key();
    private static final DescriptorSchemaCache.Key<String[]> JsonSerializationNamesKey = new DescriptorSchemaCache.Key();

    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonDeserializationNamesKey() {
        return JsonDeserializationNamesKey;
    }

    public static final DescriptorSchemaCache.Key<String[]> getJsonSerializationNamesKey() {
        return JsonSerializationNamesKey;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Integer> buildDeserializationNamesMap(SerialDescriptor $this$buildDeserializationNamesMap, Json json) {
        void var2_2;
        Map builder = new LinkedHashMap();
        boolean useLowercaseEnums = JsonNamesMapKt.decodeCaseInsensitive(json, $this$buildDeserializationNamesMap);
        JsonNamingStrategy strategyForClasses = JsonNamesMapKt.namingStrategy($this$buildDeserializationNamesMap, json);
        int n = $this$buildDeserializationNamesMap.getElementsCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable iterable = $this$buildDeserializationNamesMap.getElementAnnotations(i);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JsonNames)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String[] stringArray = (String[])CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (stringArray != null && (stringArray = stringArray.names()) != null) {
                $this$forEach$iv = stringArray;
                int n2 = ((String[])$this$forEach$iv).length;
                for (int j = 0; j < n2; ++j) {
                    String string;
                    String string2 = $this$forEach$iv[j];
                    String name = string2;
                    if (useLowercaseEnums) {
                        String string3 = name.toLowerCase(Locale.ROOT);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    } else {
                        string = name;
                    }
                    JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(builder, $this$buildDeserializationNamesMap, string, i);
                }
            }
            if (useLowercaseEnums) {
                String string = $this$buildDeserializationNamesMap.getElementName(i).toLowerCase(Locale.ROOT);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            } else {
                JsonNamingStrategy jsonNamingStrategy = strategyForClasses;
                object = $this$forEach$iv = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson($this$buildDeserializationNamesMap, i, $this$buildDeserializationNamesMap.getElementName(i)) : null;
            }
            if (object == null) continue;
            String it = object;
            JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(builder, $this$buildDeserializationNamesMap, it, i);
        }
        void var4_5 = var2_2;
        if (var4_5.isEmpty()) {
            return MapsKt.emptyMap();
        }
        return var4_5;
    }

    /*
     * WARNING - void declaration
     */
    public static final Map<String, Integer> deserializationNamesMap(Json $this$deserializationNamesMap, SerialDescriptor descriptor) {
        Json json;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$deserializationNamesMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return JsonSchemaCacheKt.getSchemaCache($this$deserializationNamesMap).getOrPut(descriptor, JsonDeserializationNamesKey, () -> JsonNamesMapKt.deserializationNamesMap$lambda$3((SerialDescriptor)var1_1, json));
    }

    /*
     * WARNING - void declaration
     */
    public static final String[] serializationNamesIndices(SerialDescriptor $this$serializationNamesIndices, Json json, JsonNamingStrategy strategy) {
        void var2_2;
        SerialDescriptor serialDescriptor;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$serializationNamesIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        return JsonSchemaCacheKt.getSchemaCache((Json)var1_1).getOrPut($this$serializationNamesIndices, JsonSerializationNamesKey, () -> JsonNamesMapKt.serializationNamesIndices$lambda$4(serialDescriptor, (JsonNamingStrategy)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final String getJsonElementName(SerialDescriptor $this$getJsonElementName, Json json, int index) {
        void var2_2;
        void var3_3;
        void var1_1;
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonElementName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy($this$getJsonElementName, json);
        if (strategy == null) {
            return $this$getJsonElementName.getElementName(index);
        }
        return JsonNamesMapKt.serializationNamesIndices(serialDescriptor, (Json)var1_1, (JsonNamingStrategy)var3_3)[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonNamingStrategy namingStrategy(SerialDescriptor $this$namingStrategy, Json json) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$namingStrategy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)StructureKind.CLASS.INSTANCE)) {
            void var1_1;
            return var1_1.getConfiguration().getNamingStrategy();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getJsonNameIndexSlowPath(SerialDescriptor $this$getJsonNameIndexSlowPath, Json json, String name) {
        void var2_2;
        SerialDescriptor serialDescriptor;
        Integer n = JsonNamesMapKt.deserializationNamesMap(json, serialDescriptor).get(var2_2);
        if (n != null) {
            return n;
        }
        return -3;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean decodeCaseInsensitive(Json $this$decodeCaseInsensitive, SerialDescriptor descriptor) {
        void var1_1;
        return $this$decodeCaseInsensitive.getConfiguration().getDecodeEnumsCaseInsensitive() && Intrinsics.areEqual((Object)var1_1.getKind(), (Object)SerialKind.ENUM.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getJsonNameIndex(SerialDescriptor $this$getJsonNameIndex, Json json, String name) {
        void var2_2;
        void var1_1;
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (JsonNamesMapKt.decodeCaseInsensitive(json, $this$getJsonNameIndex)) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, string);
        }
        JsonNamingStrategy jsonNamingStrategy = JsonNamesMapKt.namingStrategy($this$getJsonNameIndex, json);
        if (jsonNamingStrategy != null) {
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, name);
        }
        int index = $this$getJsonNameIndex.getElementIndex(name);
        if (index != -3) {
            return index;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            void var3_4;
            return (int)var3_4;
        }
        return JsonNamesMapKt.getJsonNameIndexSlowPath(serialDescriptor, (Json)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getJsonNameIndexOrThrow(SerialDescriptor $this$getJsonNameIndexOrThrow, Json json, String name, String suffix) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndexOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        int index = JsonNamesMapKt.getJsonNameIndex($this$getJsonNameIndexOrThrow, json, name);
        if (index == -3) {
            void var3_4;
            void var2_3;
            SerialDescriptor serialDescriptor;
            throw new SerializationException(serialDescriptor.getSerialName() + " does not contain element with name '" + (String)var2_3 + '\'' + (String)var3_4);
        }
        return (int)var1_2;
    }

    public static /* synthetic */ int getJsonNameIndexOrThrow$default(SerialDescriptor serialDescriptor, Json json, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return JsonNamesMapKt.getJsonNameIndexOrThrow(serialDescriptor, json, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean tryCoerceValue(Json $this$tryCoerceValue, SerialDescriptor descriptor, int index, Function1<? super Boolean, Boolean> peekNull, Function0<String> peekString, Function0<Unit> onEnumCoercing) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCoerceValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(peekNull, (String)"peekNull");
        Intrinsics.checkNotNullParameter(peekString, (String)"peekString");
        Intrinsics.checkNotNullParameter(onEnumCoercing, (String)"onEnumCoercing");
        boolean isOptional = descriptor.isElementOptional(index);
        SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(index);
        if (isOptional && !elementDescriptor.isNullable() && ((Boolean)peekNull.invoke((Object)Boolean.TRUE)).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)elementDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            void var0_1;
            void var2_5;
            void var1_2;
            boolean coerceToNull;
            void var3_6;
            if (elementDescriptor.isNullable() && ((Boolean)var3_6.invoke((Object)Boolean.FALSE)).booleanValue()) {
                return false;
            }
            String string = (String)peekString.invoke();
            if (string == null) {
                return false;
            }
            String enumValue = string;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor, $this$tryCoerceValue, enumValue);
            boolean bl = coerceToNull = !$this$tryCoerceValue.getConfiguration().getExplicitNulls() && var1_2.isNullable();
            if (var2_5 == -3 && (isOptional || var0_1 != false)) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ boolean tryCoerceValue$default(Json $this$tryCoerceValue_u24default, SerialDescriptor descriptor, int index, Function1 peekNull, Function0 peekString, Function0 onEnumCoercing, int n, Object object) {
        if ((n & 0x10) != 0) {
            onEnumCoercing = tryCoerceValue.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$tryCoerceValue_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)peekNull, (String)"peekNull");
        Intrinsics.checkNotNullParameter((Object)peekString, (String)"peekString");
        Intrinsics.checkNotNullParameter((Object)onEnumCoercing, (String)"onEnumCoercing");
        boolean isOptional = descriptor.isElementOptional(index);
        SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(index);
        if (isOptional && !elementDescriptor.isNullable() && ((Boolean)peekNull.invoke((Object)Boolean.TRUE)).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)elementDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            void var0_1;
            void var2_5;
            void var1_2;
            boolean coerceToNull;
            void var3_6;
            if (elementDescriptor.isNullable() && ((Boolean)var3_6.invoke((Object)Boolean.FALSE)).booleanValue()) {
                return false;
            }
            String string = (String)peekString.invoke();
            if (string == null) {
                return false;
            }
            String enumValue = string;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor, $this$tryCoerceValue_u24default, enumValue);
            boolean bl = coerceToNull = !$this$tryCoerceValue_u24default.getConfiguration().getExplicitNulls() && var1_2.isNullable();
            if (var2_5 == -3 && (isOptional || var0_1 != false)) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildDeserializationNamesMap$putOrThrow(Map<String, Integer> $this$buildDeserializationNamesMap_u24putOrThrow, SerialDescriptor $this_buildDeserializationNamesMap, String name, int index) {
        void var2_2;
        Map<String, Integer> map;
        void var3_3;
        Integer n;
        String entity;
        String string = entity = Intrinsics.areEqual((Object)$this_buildDeserializationNamesMap.getKind(), (Object)SerialKind.ENUM.INSTANCE) ? "enum value" : "property";
        if ($this$buildDeserializationNamesMap_u24putOrThrow.containsKey(name)) {
            throw new JsonException("The suggested name '" + name + "' for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(index) + " is already one of the names for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(((Number)MapsKt.getValue($this$buildDeserializationNamesMap_u24putOrThrow, (Object)name)).intValue()) + " in " + n);
        }
        n = (int)var3_3;
        map.put((String)var2_2, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map deserializationNamesMap$lambda$3(SerialDescriptor $descriptor, Json $this_deserializationNamesMap) {
        void var1_1;
        return JsonNamesMapKt.buildDeserializationNamesMap($descriptor, (Json)var1_1);
    }

    private static final String[] serializationNamesIndices$lambda$4(SerialDescriptor $this_serializationNamesIndices, JsonNamingStrategy $strategy) {
        int n = 0;
        int n2 = $this_serializationNamesIndices.getElementsCount();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            String baseName = $this_serializationNamesIndices.getElementName(n3);
            stringArray[n3] = $strategy.serialNameForJson($this_serializationNamesIndices, n3, baseName);
        }
        return stringArray;
    }
}

