/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a \u0010\u0017\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a \u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u001a\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u001b"}, d2={"JsonDecodingException", "Lkotlinx/serialization/json/internal/JsonDecodingException;", "offset", "", "message", "", "input", "", "InvalidFloatingPointEncoded", "Lkotlinx/serialization/json/internal/JsonEncodingException;", "value", "", "output", "throwInvalidFloatingPointDecoded", "", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "result", "invalidTrailingComma", "entity", "InvalidKeyKindException", "keyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "key", "InvalidFloatingPointDecoded", "unexpectedFpErrorMessage", "UnknownKeyException", "minify", "kotlinx-serialization-json"})
public final class JsonExceptionsKt {
    /*
     * WARNING - void declaration
     */
    public static final JsonDecodingException JsonDecodingException(int offset, String message) {
        void var1_1;
        int n;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new JsonDecodingException((String)(offset >= 0 ? "Unexpected JSON token at offset " + n + ": " + message : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonDecodingException JsonDecodingException(int offset, String message, CharSequence input) {
        int n;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return JsonExceptionsKt.JsonDecodingException(offset, (String)var1_1 + "\nJSON input: " + JsonExceptionsKt.minify((CharSequence)var2_2, n));
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonEncodingException InvalidFloatingPointEncoded(Number value, String output) {
        void var1_1;
        Number number;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException("Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default((CharSequence)var1_1, 0, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    public static final Void throwInvalidFloatingPointDecoded(AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, Number result) {
        void var1_1;
        AbstractJsonLexer abstractJsonLexer;
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidFloatingPointDecoded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        AbstractJsonLexer.fail$default(abstractJsonLexer, "Unexpected special floating-point value " + var1_1 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public static final Void invalidTrailingComma(AbstractJsonLexer $this$invalidTrailingComma, String entity) {
        AbstractJsonLexer abstractJsonLexer;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$invalidTrailingComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        $this$invalidTrailingComma.fail("Trailing comma before the end of JSON " + (String)var1_1, abstractJsonLexer.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingCommas = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    public static final JsonEncodingException InvalidKeyKindException(SerialDescriptor keyDescriptor) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)keyDescriptor, (String)"keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + serialDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonEncodingException InvalidFloatingPointEncoded(Number value, String key, String output) {
        void var2_2;
        void var1_1;
        Number number;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException(JsonExceptionsKt.unexpectedFpErrorMessage(number, (String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonDecodingException InvalidFloatingPointDecoded(Number value, String key, String output) {
        void var2_2;
        void var1_1;
        Number number;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(number, (String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static final String unexpectedFpErrorMessage(Number value, String key, String output) {
        void var2_2;
        void var1_1;
        Number number;
        return "Unexpected special floating-point value " + number + " with key " + (String)var1_1 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default((CharSequence)var2_2, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonDecodingException UnknownKeyException(String key, String input) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + string + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.\nCurrent input: " + JsonExceptionsKt.minify$default((CharSequence)var1_1, 0, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    public static final CharSequence minify(CharSequence $this$minify, int offset22) {
        CharSequence charSequence;
        void var1_1;
        void var2_4;
        void var3_6;
        int offset22;
        Intrinsics.checkNotNullParameter((Object)$this$minify, (String)"<this>");
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset22 == -1) {
            int start = $this$minify.length() - 60;
            if (start <= 0) {
                return $this$minify;
            }
            CharSequence offset22 = $this$minify;
            int n = offset22.length();
            return "....." + ((Object)offset22.subSequence(start, n)).toString();
        }
        int start = offset22 - 30;
        int end = offset22 + 30;
        String prefix = start <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        return (String)var3_6 + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast((int)var2_4, (int)0), RangesKt.coerceAtMost((int)var1_1, (int)charSequence.length()))).toString() + suffix;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

