/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.ByteArrayPool8k;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/json/internal/CharsetReader;", "", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "decoder", "Ljava/nio/charset/CharsetDecoder;", "byteBuffer", "Ljava/nio/ByteBuffer;", "hasLeftoverPotentiallySurrogateChar", "", "leftoverChar", "", "read", "", "array", "", "offset", "length", "doRead", "fillByteBuffer", "oneShotReadSlowPath", "release", "", "kotlinx-serialization-json"})
public final class CharsetReader {
    private final InputStream inputStream;
    private final Charset charset;
    private final CharsetDecoder decoder;
    private final ByteBuffer byteBuffer;
    private boolean hasLeftoverPotentiallySurrogateChar;
    private char leftoverChar;

    /*
     * WARNING - void declaration
     */
    public CharsetReader(InputStream inputStream, Charset charset) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.inputStream = var1_1;
        this.charset = var2_2;
        this.decoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        this.byteBuffer.flip();
    }

    /*
     * WARNING - void declaration
     */
    public final int read(char[] array, int offset, int length22) {
        void var2_2;
        void var1_1;
        void var3_3;
        int length22;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length22 == 0) {
            return 0;
        }
        if (!((offset >= 0 ? offset < array.length : false) && length22 >= 0 && offset + length22 <= array.length)) {
            String length22 = "Unexpected arguments: " + offset + ", " + length22 + ", " + array.length;
            throw new IllegalArgumentException(length22.toString());
        }
        int bytesRead = 0;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            array[offset] = this.leftoverChar;
            ++offset;
            this.hasLeftoverPotentiallySurrogateChar = false;
            bytesRead = 1;
            if (--length22 == 0) {
                return 1;
            }
        }
        if (length22 == 1) {
            int c = this.oneShotReadSlowPath();
            if (c == -1) {
                if (bytesRead == 0) {
                    return -1;
                }
                return 1;
            }
            array[offset] = (char)var3_3;
            return bytesRead + 1;
        }
        return this.doRead((char[])var1_1, (int)var2_2, (int)var3_3) + bytesRead;
    }

    /*
     * WARNING - void declaration
     */
    private final int doRead(char[] array, int offset, int length) {
        void var1_1;
        void var2_2;
        CharSequence charBuffer = CharBuffer.wrap(array, offset, length);
        if (charBuffer.position() != 0) {
            charBuffer = charBuffer.slice();
        }
        boolean isEof = false;
        while (true) {
            void var3_4;
            CoderResult cr2;
            if ((cr2 = this.decoder.decode(this.byteBuffer, (CharBuffer)charBuffer, isEof)).isUnderflow()) {
                if (isEof || !charBuffer.hasRemaining()) break;
                int cr2 = this.fillByteBuffer();
                if (cr2 >= 0) continue;
                isEof = true;
                if (charBuffer.position() == 0 && !this.byteBuffer.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (cr2.isOverflow()) {
                boolean bl = cr2 = charBuffer.position() > 0;
                if (!_Assertions.ENABLED || cr2) break;
                charBuffer = "Assertion failed";
                throw new AssertionError(charBuffer);
            }
            var3_4.throwException();
        }
        if (var2_2 != false) {
            this.decoder.reset();
        }
        if (charBuffer.position() == 0) {
            return -1;
        }
        return var1_1.position();
    }

    /*
     * WARNING - void declaration
     */
    private final int fillByteBuffer() {
        this.byteBuffer.compact();
        try {
            void var1_1;
            void var2_2;
            int limit = this.byteBuffer.limit();
            int position = this.byteBuffer.position();
            int remaining = position <= limit ? limit - position : 0;
            int bytesRead = this.inputStream.read(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + position, remaining);
            if (bytesRead < 0) {
                return bytesRead;
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer).position((int)(var2_2 + var1_1));
        }
        finally {
            this.byteBuffer.flip();
        }
        return this.byteBuffer.remaining();
    }

    /*
     * WARNING - void declaration
     */
    private final int oneShotReadSlowPath() {
        void var2_2;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            this.hasLeftoverPotentiallySurrogateChar = false;
            return this.leftoverChar;
        }
        char[] array = new char[2];
        int bytesRead = this.read(array, 0, 2);
        switch (bytesRead) {
            case -1: {
                return -1;
            }
            case 1: {
                return array[0];
            }
            case 2: {
                void var1_1;
                this.leftoverChar = array[1];
                this.hasLeftoverPotentiallySurrogateChar = true;
                return (int)var1_1[0];
            }
        }
        throw new IllegalStateException(("Unreachable state: " + (int)var2_2).toString());
    }

    public final void release() {
        byte[] byArray = this.byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        ByteArrayPool8k.INSTANCE.release(byArray);
    }
}

