/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.paragraph.Paragraph;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010 \u001a\u00020\u0012H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "text", "", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "<set-?>", "", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "getText", "()Ljava/lang/String;", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getTextDirection", "()Landroidx/compose/ui/text/style/ResolvedTextDirection;", "newLayouter", "ui-text"})
@StabilityInferred(parameters=0)
public final class SkiaParagraphIntrinsics
implements ParagraphIntrinsics {
    private final String text;
    private final TextStyle style;
    private final List<AnnotatedString.Range<SpanStyle>> spanStyles;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final ResolvedTextDirection textDirection;
    private ParagraphLayouter layouter;
    private float minIntrinsicWidth;
    private float maxIntrinsicWidth;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SkiaParagraphIntrinsics(String text, TextStyle style, List<AnnotatedString.Range<SpanStyle>> spanStyles, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text;
        this.style = var2_2;
        this.spanStyles = var3_3;
        this.placeholders = placeholders;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.textDirection = SkiaParagraphIntrinsics_skikoKt.resolveTextDirection-Ikz0yAw(this.text, TextDirection.box-impl(this.style.getTextDirection-s_7X-co()), this.style.getLocaleList());
        ParagraphLayouter paragraphLayouter = this.layouter = this.newLayouter();
        Intrinsics.checkNotNull((Object)paragraphLayouter);
        Paragraph para = paragraphLayouter.layoutParagraph(Float.POSITIVE_INFINITY);
        this.minIntrinsicWidth = (float)Math.ceil(para.getMinIntrinsicWidth());
        this.maxIntrinsicWidth = (float)Math.ceil(var1_1.getMaxIntrinsicWidth());
    }

    public final String getText() {
        return this.text;
    }

    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    /*
     * WARNING - void declaration
     */
    public final ParagraphLayouter layouter() {
        void var1_1;
        ParagraphLayouter paragraphLayouter = this.layouter;
        if (paragraphLayouter == null) {
            paragraphLayouter = this.newLayouter();
        }
        ParagraphLayouter layouter = paragraphLayouter;
        this.layouter = null;
        return var1_1;
    }

    private final ParagraphLayouter newLayouter() {
        return new ParagraphLayouter(this.text, this.textDirection, this.style, this.spanStyles, this.placeholders, this.density, this.fontFamilyResolver);
    }

    @Override
    public final float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }
}

