/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010#\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u0004\u0018\u00010\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\rJ*\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\tJ=\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0011\u001a\u00020\t2\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0013\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0019JA\u0010\u001a\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001dJE\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00132\u0012\u0010 \u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00060!2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\rH\u0002\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Landroidx/compose/ui/text/platform/ReflectionUtil;", "", "()V", "findAssignableField", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "fieldType", "fieldName", "", "findFieldInHierarchy", "rootClass", "checker", "Ljava/util/function/Predicate;", "getAssignableField", "getDeclaredMethodOrNull", "Ljava/lang/reflect/Method;", "name", "parameters", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getFieldValue", "T", "field", "instance", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", "getFieldValueOrNull", "objectClass", "object", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "processInterfaces", "interfaces", "visited", "", "([Ljava/lang/Class;Ljava/util/Set;Ljava/util/function/Predicate;)Ljava/lang/reflect/Field;", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nReflectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionUtil.kt\nandroidx/compose/ui/text/platform/ReflectionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class ReflectionUtil {
    public static final ReflectionUtil INSTANCE = new ReflectionUtil();
    public static final int $stable;

    private ReflectionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final Method getDeclaredMethodOrNull(Class<?> clazz, String name, Class<?> ... parameters) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        try {
            Method method2;
            void var3_3;
            void v0 = var3_3;
            method2 = method = ((Class)((Object)method)).getDeclaredMethod((String)((Object)method2), (Class[])Arrays.copyOf(v0, ((void)v0).length));
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            method = null;
        }
        return method;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T getFieldValueOrNull(Class<?> objectClass, Object object, Class<T> fieldType, String fieldName) {
        Field field;
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            void var2_2;
            void var3_3;
            Field field2 = this.getAssignableField(objectClass, (Class<?>)var3_3, fieldName);
            field = (Field)this.getFieldValue(field, var2_2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = null;
        }
        return (T)field;
    }

    /*
     * WARNING - void declaration
     */
    public final Field getAssignableField(Class<?> clazz, Class<?> fieldType, String fieldName) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Field field = this.findAssignableField(clazz, fieldType, fieldName);
        if (field == null) {
            void var2_2;
            void var3_3;
            void var1_1;
            throw new NoSuchFieldException("Class: " + var1_1 + " fieldName: " + (String)var3_3 + " fieldType: " + var2_2);
        }
        return field;
    }

    /*
     * WARNING - void declaration
     */
    public final Field findAssignableField(Class<?> clazz, Class<?> fieldType, String fieldName) {
        void var2_2;
        void var3_3;
        Field field;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        field = this.findFieldInHierarchy((Class<?>)((Object)field), (Predicate<? super Field>)((Predicate<Object>)arg_0 -> ReflectionUtil.findAssignableField$lambda$1((Function1)new Function1<Field, Boolean>((String)var3_3, var2_2){
            final /* synthetic */ String $fieldName;
            final /* synthetic */ Class<?> $fieldType;
            {
                void var2_2;
                void var1_1;
                this.$fieldName = var1_1;
                this.$fieldType = var2_2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(Field field) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return Intrinsics.areEqual((Object)this.$fieldName, (Object)field.getName()) && (this.$fieldType == null || this.$fieldType.isAssignableFrom(var1_1.getType()));
            }
        }, arg_0)));
        return field;
    }

    /*
     * WARNING - void declaration
     */
    public final Field findFieldInHierarchy(Class<?> rootClass, Predicate<? super Field> checker) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        try {
            for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
                Field[] fieldArray;
                Intrinsics.checkNotNullExpressionValue((Object)aClass.getDeclaredFields(), (String)"getDeclaredFields(...)");
                for (Field field : fieldArray) {
                    Intrinsics.checkNotNull((Object)field);
                    if (!checker.test(field)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            return null;
        }
        Class<?>[] classArray = var1_1.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        return this.processInterfaces(classArray, new HashSet(), (Predicate<? super Field>)var2_2);
    }

    private final Field processInterfaces(Class<?>[] interfaces, Set<? super Class<?>> visited, Predicate<? super Field> checker) {
        for (Class<?> anInterface : interfaces) {
            Field[] fieldArray;
            if (!visited.add(anInterface)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)anInterface.getDeclaredFields(), (String)"getDeclaredFields(...)");
            for (Field field : fieldArray) {
                Intrinsics.checkNotNull((Object)field);
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Class<?>[] classArray = anInterface.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            Field field = this.processInterfaces(classArray, visited, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T getFieldValue(Field field, Object instance) {
        Object object;
        try {
            void var2_2;
            object = field.get(var2_2);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findAssignableField$lambda$1(Function1 $tmp0, Object p0) {
        void var1_1;
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)function1.invoke((Object)var1_1);
    }
}

