/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.Platform;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.ResourceFont;
import androidx.compose.ui.text.platform.SystemFont;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.Typeface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a,\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\u0010\u001a\b\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"skFontStyle", "Lorg/jetbrains/skia/FontStyle;", "Landroidx/compose/ui/text/font/Font;", "getSkFontStyle", "(Landroidx/compose/ui/text/font/Font;)Lorg/jetbrains/skia/FontStyle;", "Font", "file", "Ljava/io/File;", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "Font-RetOiIg", "(Ljava/io/File;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "resource", "", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "currentPlatform", "Landroidx/compose/ui/text/platform/Platform;", "loadTypeface", "Lorg/jetbrains/skia/Typeface;", "font", "typefaceResource", "resourceName", "ui-text"})
@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class DesktopFont_desktopKt {
    /*
     * WARNING - void declaration
     */
    public static final Font Font-RetOiIg(String resource2, FontWeight weight, int style) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)resource2, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        return new ResourceFont(string, (FontWeight)var1_1, (int)var2_2, null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(String string, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(string, fontWeight, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final Font Font-RetOiIg(File file, FontWeight weight, int style) {
        void var2_2;
        void var1_1;
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        return new FileFont(file2, (FontWeight)var1_1, (int)var2_2, null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(File file, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(file, fontWeight, n);
    }

    public static final Typeface loadTypeface(Font font) {
        Font font2;
        Typeface typeface2;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        PlatformFont platformFont = (PlatformFont)font;
        if (platformFont instanceof ResourceFont) {
            typeface2 = DesktopFont_desktopKt.typefaceResource(((ResourceFont)font).getName());
        } else if (platformFont instanceof FileFont) {
            FontMgr fontMgr = FontMgr.Companion.getDefault();
            String string = ((FileFont)font).getFile().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            typeface2 = FontMgr.makeFromFile$default((FontMgr)fontMgr, (String)string, (int)0, (int)2, null);
        } else if (platformFont instanceof LoadedFont) {
            typeface2 = FontMgr.makeFromData$default((FontMgr)FontMgr.Companion.getDefault(), (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((byte[])((LoadedFont)font).getGetData$ui_text().invoke()), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        } else if (platformFont instanceof SystemFont) {
            typeface2 = FontMgr.Companion.getDefault().matchFamilyStyle(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface3 = typeface2;
        if (typeface2 == null && (typeface3 = FontMgr.Companion.getDefault().legacyMakeTypeface(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font2))) == null) {
            throw new IllegalStateException("loadTypeface legacyMakeTypeface failed".toString());
        }
        return typeface3;
    }

    private static final Typeface typefaceResource(String resourceName) {
        Object object;
        Object object2;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        Object object3 = classLoader;
        Object object4 = classLoader.getResourceAsStream(resourceName);
        if (object4 == null) {
            object4 = object3 = ((Object)((Object)typefaceResource.resource.1.INSTANCE)).getClass().getResourceAsStream(resourceName);
        }
        if (object4 == null) {
            throw new IllegalStateException(("Can't load font from " + (String)object2).toString());
        }
        object2 = object3;
        object2 = (Closeable)object2;
        object3 = null;
        try {
            object = (InputStream)object2;
            object = ((InputStream)object).readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object3 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)object2, null);
        Object bytes = object;
        FontMgr fontMgr = FontMgr.Companion.getDefault();
        Intrinsics.checkNotNull((Object)bytes);
        Typeface typeface2 = FontMgr.makeFromData$default((FontMgr)fontMgr, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])object3, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)typeface2);
        return typeface2;
    }

    private static final org.jetbrains.skia.FontStyle getSkFontStyle(Font $this$skFontStyle) {
        Font font;
        return new org.jetbrains.skia.FontStyle($this$skFontStyle.getWeight().getWeight(), 5, FontStyle.equals-impl0(font.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA()) ? FontSlant.ITALIC : FontSlant.UPRIGHT);
    }

    /*
     * WARNING - void declaration
     */
    public static final Platform currentPlatform() {
        void var0;
        String name = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"Linux", (boolean)false, (int)2, null)) {
            return Platform.Linux;
        }
        if (StringsKt.startsWith$default((String)name, (String)"Win", (boolean)false, (int)2, null)) {
            return Platform.Windows;
        }
        if (Intrinsics.areEqual((Object)var0, (Object)"Mac OS X")) {
            return Platform.MacOS;
        }
        return Platform.Unknown;
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

