/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/SetComposingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "text", "", "newCursorPosition", "", "(Ljava/lang/String;I)V", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;I)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "getNewCursorPosition", "()I", "getText", "()Ljava/lang/String;", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "ui-text"})
@StabilityInferred(parameters=1)
public final class SetComposingTextCommand
implements EditCommand {
    private final AnnotatedString annotatedString;
    private final int newCursorPosition;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public SetComposingTextCommand(AnnotatedString annotatedString, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        this.annotatedString = var1_1;
        this.newCursorPosition = var2_2;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    /*
     * WARNING - void declaration
     */
    public SetComposingTextCommand(String text, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new AnnotatedString((String)var1_1, null, null, 6, null), (int)var2_2);
    }

    public final String getText() {
        return this.annotatedString.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text()) {
            int compositionStart = buffer.getCompositionStart$ui_text();
            EditingBuffer editingBuffer = buffer;
            editingBuffer.replace$ui_text(editingBuffer.getCompositionStart$ui_text(), buffer.getCompositionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                int n = compositionStart;
                buffer.setComposition$ui_text(n, n + this.getText().length());
            }
        } else {
            int selectionStart = buffer.getSelectionStart$ui_text();
            EditingBuffer editingBuffer = buffer;
            editingBuffer.replace$ui_text(editingBuffer.getSelectionStart$ui_text(), buffer.getSelectionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                int n = selectionStart;
                buffer.setComposition$ui_text(n, n + this.getText().length());
            }
        }
        int newCursor = buffer.getCursor$ui_text();
        int newCursorInBuffer = this.newCursorPosition > 0 ? newCursor + this.newCursorPosition - 1 : newCursor + this.newCursorPosition - this.getText().length();
        buffer.setCursor$ui_text(RangesKt.coerceIn((int)var2_2, (int)0, (int)var1_1.getLength$ui_text()));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetComposingTextCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getText(), (Object)((SetComposingTextCommand)other).getText())) {
            return false;
        }
        return this.newCursorPosition == ((SetComposingTextCommand)var1_1).newCursorPosition;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result2 = this.getText().hashCode();
        var1_1 = var1_1 * 31 + this.newCursorPosition;
        return (int)var1_1;
    }

    public final String toString() {
        return "SetComposingTextCommand(text='" + this.getText() + "', newCursorPosition=" + this.newCursorPosition + ')';
    }
}

