/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.BackspaceCommand;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.MoveCursorCommand;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ \u0010\u0010\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\f\u0010\u0019\u001a\u00020\u0011*\u00020\u000fH\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/EditProcessor;", "", "()V", "<set-?>", "Landroidx/compose/ui/text/input/EditingBuffer;", "mBuffer", "getMBuffer$ui_text", "()Landroidx/compose/ui/text/input/EditingBuffer;", "Landroidx/compose/ui/text/input/TextFieldValue;", "mBufferState", "getMBufferState$ui_text", "()Landroidx/compose/ui/text/input/TextFieldValue;", "apply", "editCommands", "", "Landroidx/compose/ui/text/input/EditCommand;", "generateBatchErrorMessage", "", "failedCommand", "reset", "", "value", "textInputSession", "Landroidx/compose/ui/text/input/TextInputSession;", "toTextFieldValue", "toStringForLog", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n33#2,6:183\n1#3:189\n*S KotlinDebug\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n*L\n115#1:183,6\n*E\n"})
public final class EditProcessor {
    private TextFieldValue mBufferState = new TextFieldValue(AnnotatedStringKt.emptyAnnotatedString(), TextRange.Companion.getZero-d9O1mEE(), null, null);
    private EditingBuffer mBuffer = new EditingBuffer(this.mBufferState.getAnnotatedString(), this.mBufferState.getSelection-d9O1mEE(), null);
    public static final int $stable = 8;

    public final TextFieldValue getMBufferState$ui_text() {
        return this.mBufferState;
    }

    public final EditingBuffer getMBuffer$ui_text() {
        return this.mBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public final void reset(TextFieldValue value, TextInputSession textInputSession) {
        void var2_2;
        void newValue;
        TextFieldValue textFieldValue;
        boolean compositionChanged;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean textChanged = false;
        boolean selectionChanged = false;
        boolean bl = compositionChanged = !Intrinsics.areEqual((Object)value.getComposition-MzsxiRA(), (Object)this.mBuffer.getComposition-MzsxiRA$ui_text());
        if (!Intrinsics.areEqual((Object)this.mBufferState.getAnnotatedString(), (Object)value.getAnnotatedString())) {
            this.mBuffer = new EditingBuffer(value.getAnnotatedString(), value.getSelection-d9O1mEE(), null);
            textChanged = true;
        } else if (!TextRange.equals-impl0(this.mBufferState.getSelection-d9O1mEE(), value.getSelection-d9O1mEE())) {
            this.mBuffer.setSelection$ui_text(TextRange.getMin-impl(value.getSelection-d9O1mEE()), TextRange.getMax-impl(value.getSelection-d9O1mEE()));
            selectionChanged = true;
        }
        if (value.getComposition-MzsxiRA() == null) {
            this.mBuffer.commitComposition$ui_text();
        } else if (!TextRange.getCollapsed-impl(value.getComposition-MzsxiRA().unbox-impl())) {
            this.mBuffer.setComposition$ui_text(TextRange.getMin-impl(value.getComposition-MzsxiRA().unbox-impl()), TextRange.getMax-impl(value.getComposition-MzsxiRA().unbox-impl()));
        }
        if (textChanged || !selectionChanged && compositionChanged) {
            this.mBuffer.commitComposition$ui_text();
            textFieldValue = TextFieldValue.copy-3r_uNRQ$default(value, null, 0L, null, 3, null);
        } else {
            textFieldValue = newValue;
        }
        newValue = textFieldValue;
        TextFieldValue oldValue = this.mBufferState;
        this.mBufferState = newValue;
        void v2 = var2_2;
        if (v2 != null) {
            void var1_1;
            void var3_4;
            v2.updateState((TextFieldValue)var3_4, (TextFieldValue)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final TextFieldValue apply(List<? extends EditCommand> editCommands) {
        void var3_3;
        TextFieldValue newState;
        void $this$apply_u24lambda_u242;
        AnnotatedString annotatedString;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
        EditCommand lastCommand = null;
        try {
            List<? extends EditCommand> $this$fastForEach$iv = editCommands;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                object2 = $this$fastForEach$iv.get(index$iv);
                EditCommand it = object2;
                lastCommand = object2;
                it.applyTo(this.mBuffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.generateBatchErrorMessage((List<? extends EditCommand>)object, (EditCommand)((Object)annotatedString)), e);
        }
        long index$iv = this.mBuffer.getSelection-d9O1mEE$ui_text();
        object = this.mBuffer.toAnnotatedString$ui_text();
        object2 = TextRange.box-impl((long)$this$apply_u24lambda_u242);
        ((TextRange)object2).unbox-impl();
        Object object3 = !TextRange.getReversed-impl(this.mBufferState.getSelection-d9O1mEE()) ? object2 : null;
        long l = object3 != null ? ((TextRange)object3).unbox-impl() : TextRangeKt.TextRange(TextRange.getMax-impl((long)$this$apply_u24lambda_u242), TextRange.getMin-impl((long)$this$apply_u24lambda_u242));
        AnnotatedString annotatedString2 = object;
        object = this.mBuffer.getComposition-MzsxiRA$ui_text();
        long l2 = l;
        annotatedString = annotatedString2;
        this.mBufferState = newState = new TextFieldValue(annotatedString, l2, (TextRange)object, null);
        return var3_3;
    }

    public final TextFieldValue toTextFieldValue() {
        return this.mBufferState;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateBatchErrorMessage(List<? extends EditCommand> editCommands, EditCommand failedCommand) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        StringBuilder $this$generateBatchErrorMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength$ui_text() + ", composition=" + this.mBuffer.getComposition-MzsxiRA$ui_text() + ", selection=" + TextRange.toString-impl(this.mBuffer.getSelection-d9O1mEE$ui_text()) + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        CollectionsKt.joinTo$default((Iterable)((Iterable)var1_1), (Appendable)$this$generateBatchErrorMessage_u24lambda_u243, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<EditCommand, CharSequence>((EditCommand)var2_2, this){
            final /* synthetic */ EditCommand $failedCommand;
            final /* synthetic */ EditProcessor this$0;
            {
                void var2_2;
                void var1_1;
                this.$failedCommand = var1_1;
                this.this$0 = var2_2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final CharSequence invoke(EditCommand it) {
                void var1_1;
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String prefix = this.$failedCommand == it ? " > " : "   ";
                return (String)var2_2 + EditProcessor.access$toStringForLog(this.this$0, (EditCommand)var1_1);
            }
        }), (int)60, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String toStringForLog(EditCommand $this$toStringForLog) {
        void var1_1;
        EditCommand editCommand = $this$toStringForLog;
        if (editCommand instanceof CommitTextCommand) {
            return "CommitTextCommand(text.length=" + ((CommitTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((CommitTextCommand)$this$toStringForLog).getNewCursorPosition() + ')';
        }
        if (editCommand instanceof SetComposingTextCommand) {
            return "SetComposingTextCommand(text.length=" + ((SetComposingTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((SetComposingTextCommand)$this$toStringForLog).getNewCursorPosition() + ')';
        }
        if (editCommand instanceof SetComposingRegionCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof DeleteSurroundingTextCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof DeleteSurroundingTextInCodePointsCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof SetSelectionCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof FinishComposingTextCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof BackspaceCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof MoveCursorCommand) {
            return $this$toStringForLog.toString();
        }
        if (editCommand instanceof DeleteAllCommand) {
            return $this$toStringForLog.toString();
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown EditCommand: ");
        String string = Reflection.getOrCreateKotlinClass(var1_1.getClass()).getSimpleName();
        if (string == null) {
            string = "{anonymous EditCommand}";
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String access$toStringForLog(EditProcessor $this, EditCommand $receiver) {
        void var1_1;
        return $this.toStringForLog((EditCommand)var1_1);
    }
}

