/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "(II)V", "getLengthAfterCursor", "()I", "getLengthBeforeCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
@StabilityInferred(parameters=1)
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        void var2_3;
        void var1_1;
        this.lengthBeforeCursor = var1_1;
        this.lengthAfterCursor = var2_3;
        if (!(this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = this.lengthBeforeCursor;
        for (int i = 0; i < n; ++i) {
            if (buffer.getSelectionStart$ui_text() > ++beforeLenInChars) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionStart$ui_text() - beforeLenInChars - 1);
                EditingBuffer editingBuffer2 = buffer;
                char trail = editingBuffer2.get$ui_text(editingBuffer2.getSelectionStart$ui_text() - beforeLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = buffer.getSelectionStart$ui_text();
            break;
        }
        int afterLenInChars = 0;
        int n2 = this.lengthAfterCursor;
        for (int i = 0; i < n2; ++i) {
            if (buffer.getSelectionEnd$ui_text() + ++afterLenInChars < buffer.getLength$ui_text()) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionEnd$ui_text() + afterLenInChars - 1);
                EditingBuffer editingBuffer3 = buffer;
                char trail = editingBuffer3.get$ui_text(editingBuffer3.getSelectionEnd$ui_text() + afterLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = buffer.getLength$ui_text() - buffer.getSelectionEnd$ui_text();
            break;
        }
        EditingBuffer editingBuffer = buffer;
        editingBuffer.delete$ui_text(editingBuffer.getSelectionEnd$ui_text(), buffer.getSelectionEnd$ui_text() + var3_3);
        EditingBuffer editingBuffer4 = buffer;
        editingBuffer4.delete$ui_text(editingBuffer4.getSelectionStart$ui_text() - var2_2, var1_1.getSelectionStart$ui_text());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)var1_1).lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result2 = this.lengthBeforeCursor;
        var1_1 = var1_1 * 31 + this.lengthAfterCursor;
        return (int)var1_1;
    }

    public final String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ')';
    }
}

