/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "(II)V", "getLengthAfterCursor", "()I", "getLengthBeforeCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n+ 2 MathUtils.kt\nandroidx/compose/ui/text/input/MathUtilsKt\n*L\n1#1,570:1\n23#2,3:571\n32#2,4:574\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n*L\n268#1:571,3\n273#1:574,4\n*E\n"})
public final class DeleteSurroundingTextCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public DeleteSurroundingTextCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        void var2_3;
        void var1_1;
        this.lengthBeforeCursor = var1_1;
        this.lengthAfterCursor = var2_3;
        if (!(this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var3_3;
        void $this$subtractExactOrElse$iv;
        void $this$addExactOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n = buffer.getSelectionEnd$ui_text();
        int right$iv = this.lengthAfterCursor;
        void result$iv = $this$addExactOrElse$iv + right$iv;
        int end = (($this$addExactOrElse$iv ^ result$iv) & (right$iv ^ result$iv)) < 0 ? buffer.getLength$ui_text() : result$iv;
        EditingBuffer editingBuffer = buffer;
        editingBuffer.delete$ui_text(editingBuffer.getSelectionEnd$ui_text(), Math.min(end, buffer.getLength$ui_text()));
        right$iv = buffer.getSelectionStart$ui_text();
        int right$iv2 = this.lengthBeforeCursor;
        result$iv = $this$subtractExactOrElse$iv - right$iv2;
        boolean start = (($this$subtractExactOrElse$iv ^ right$iv2) & (var3_3 ^ result$iv)) < 0 ? false : result$iv;
        buffer.delete$ui_text(Math.max(0, n), var1_1.getSelectionStart$ui_text());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextCommand)var1_1).lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result2 = this.lengthBeforeCursor;
        var1_1 = var1_1 * 31 + this.lengthAfterCursor;
        return (int)var1_1;
    }

    public final String toString() {
        return "DeleteSurroundingTextCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ')';
    }
}

