/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.caches.ContainerHelpersKt;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b'\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0005J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0018\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005H\u0004J\u0010\u0010)\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\b\u0010*\u001a\u00020\u0005H\u0004J\u0017\u0010+\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b,\u0010-J\u0006\u0010.\u001a\u00020\u0018J\u0013\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u001e\u00103\u001a\u00020\u00162\u0016\u00104\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000J\u001d\u00105\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0015\u00106\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u001b\u00106\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u0004\u0018\u00018\u00012\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101J\u001d\u00109\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J#\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010:\u001a\u00028\u00012\u0006\u0010;\u001a\u00028\u0001\u00a2\u0006\u0002\u0010<J\u001b\u0010=\u001a\u00028\u00012\u0006\u00100\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020@H\u0016J\u0013\u0010A\u001a\u00028\u00012\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101R\u001a\u0010\t\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\u00058G\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006B"}, d2={"Landroidx/compose/ui/text/caches/SimpleArrayMap;", "K", "V", "", "capacity", "", "(I)V", "map", "(Landroidx/compose/ui/text/caches/SimpleArrayMap;)V", "_size", "get_size", "()I", "set_size", "hashes", "", "keyValues", "", "[Ljava/lang/Object;", "size", "size$annotations", "()V", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "ensureCapacity", "minimumCapacity", "equals", "other", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "indexOf", "hash", "indexOfKey", "indexOfNull", "indexOfValue", "indexOfValue$ui_text", "(Ljava/lang/Object;)I", "isEmpty", "keyAt", "index", "(I)Ljava/lang/Object;", "put", "putAll", "array", "putIfAbsent", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeAt", "replace", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "setValueAt", "(ILjava/lang/Object;)Ljava/lang/Object;", "toString", "", "valueAt", "ui-text"})
@StabilityInferred(parameters=0)
public final class SimpleArrayMap<K, V> {
    private int[] hashes;
    private Object[] keyValues;
    private int _size;
    public static final int $stable = 8;

    protected final int get_size() {
        return this._size;
    }

    /*
     * WARNING - void declaration
     */
    protected final void set_size(int n) {
        void var1_1;
        this._size = var1_1;
    }

    @JvmName(name="size")
    public final int size() {
        return this._size;
    }

    public static /* synthetic */ void size$annotations() {
    }

    protected final int indexOf(Object key, int hash) {
        int end;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearchInternal(this.hashes, N, hash);
        if (index2 < 0) {
            return index2;
        }
        if (Intrinsics.areEqual((Object)key, (Object)this.keyValues[index2 << 1])) {
            return index2;
        }
        for (end = index2 + 1; end < N && this.hashes[end] == hash; ++end) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[end << 1])) continue;
            return end;
        }
        for (int i = index2 - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - void declaration
     */
    protected final int indexOfNull() {
        void var3_3;
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearchInternal(this.hashes, N, 0);
        if (index2 < 0) {
            return index2;
        }
        if (this.keyValues[index2 << 1] == null) {
            return index2;
        }
        for (int end = index2 + 1; end < N && this.hashes[end] == 0; ++end) {
            if (this.keyValues[end << 1] != null) continue;
            return end;
        }
        for (void i = var2_2 - true; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.keyValues[i << 1] != null) continue;
            return (int)i;
        }
        return (int)(~var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SimpleArrayMap(int capacity) {
        if (capacity == 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
        } else {
            void var1_1;
            this.hashes = new int[capacity];
            this.keyValues = new Object[var1_1 << 1];
        }
        this._size = 0;
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleArrayMap(SimpleArrayMap<K, V> map) {
        this(0, 1, null);
        if (map != null) {
            void var1_1;
            this.putAll((SimpleArrayMap<K, V>)var1_1);
        }
    }

    public final void clear() {
        if (this._size > 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
            this._size = 0;
        }
        if (this._size > 0) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int minimumCapacity) {
        void var2_2;
        int osize = this._size;
        if (this.hashes.length < minimumCapacity) {
            void var1_1;
            int[] nArray = Arrays.copyOf(this.hashes, minimumCapacity);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.keyValues, (int)(var1_1 << 1));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.keyValues = objectArray;
        }
        if (this._size != var2_2) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsKey(K key) {
        void var1_1;
        return this.indexOfKey(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfKey(Object key) {
        void var1_1;
        Object object = key;
        if (object == null) {
            return this.indexOfNull();
        }
        return this.indexOf(object, var1_1.hashCode());
    }

    public final int indexOfValue$ui_text(V value) {
        int N = this._size << 1;
        Object[] array = this.keyValues;
        if (value == null) {
            for (int i = 1; i < N; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!Intrinsics.areEqual(value, (Object)array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsValue(V value) {
        void var1_1;
        return this.indexOfValue$ui_text(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        int index2 = this.indexOfKey(key);
        if (index2 >= 0) {
            void var1_2;
            return (V)this.keyValues[(var1_2 << 1) + true];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final V getOrDefault(K key, V defaultValue) {
        void var2_3;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0) {
            void var1_2;
            return (V)this.keyValues[(var1_2 << 1) + true];
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final K keyAt(int index2) {
        void var1_1;
        return (K)this.keyValues[var1_1 << 1];
    }

    /*
     * WARNING - void declaration
     */
    public final V valueAt(int index2) {
        void var1_1;
        return (V)this.keyValues[(var1_1 << 1) + true];
    }

    /*
     * WARNING - void declaration
     */
    public final V setValueAt(int index2, V value) {
        void var3_3;
        void var2_2;
        int actualIndex = (index2 << 1) + 1;
        Object old = this.keyValues[actualIndex];
        this.keyValues[var1_1] = var2_2;
        return var3_3;
    }

    public final boolean isEmpty() {
        return this._size <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index2;
        int hash;
        int osize = this._size;
        if (key == null) {
            hash = 0;
            index2 = this.indexOfNull();
        } else {
            hash = key.hashCode();
            index2 = this.indexOf(key, hash);
        }
        if (index2 >= 0) {
            index2 = (index2 << 1) + 1;
            Object old = this.keyValues[index2];
            this.keyValues[index2] = value;
            return (V)old;
        }
        index2 ^= 0xFFFFFFFF;
        if (osize >= this.hashes.length) {
            int n;
            if (osize >= 8) {
                int n2 = osize;
                n = n2 + (n2 >> 1);
            } else {
                n = osize >= 4 ? 8 : 4;
            }
            int n3 = n;
            int[] nArray = Arrays.copyOf(this.hashes, n3);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.keyValues, n3 << 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.keyValues = objectArray;
            if (osize != this._size) {
                throw new ConcurrentModificationException();
            }
        }
        if (index2 < osize) {
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(index2 + 1), (int)index2, (int)osize);
            ArraysKt.copyInto((Object[])this.keyValues, (Object[])this.keyValues, (int)(index2 + 1 << 1), (int)(index2 << 1), (int)(this._size << 1));
        }
        if (var3_3 != this._size || index2 >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index2] = hash;
        this.keyValues[index2 << 1] = var1_1;
        this.keyValues[(index2 << 1) + 1] = var2_2;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    public final void putAll(SimpleArrayMap<? extends K, ? extends V> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int N = array._size;
        SimpleArrayMap simpleArrayMap = this;
        simpleArrayMap.ensureCapacity(simpleArrayMap._size + N);
        if (this._size == 0) {
            if (N > 0) {
                ArraysKt.copyInto((int[])array.hashes, (int[])this.hashes, (int)0, (int)0, (int)N);
                ArraysKt.copyInto((Object[])array.keyValues, (Object[])this.keyValues, (int)0, (int)0, (int)(N << 1));
                this._size = N;
                return;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.put(array.keyAt(i), array.valueAt(i));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V putIfAbsent(K key, V value) {
        void var3_3;
        V mapValue = this.get(key);
        if (mapValue == null) {
            void var2_2;
            void var1_1;
            mapValue = this.put(var1_1, var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(K key) {
        int index2 = this.indexOfKey(key);
        if (index2 >= 0) {
            void var1_2;
            return this.removeAt((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(K key, V value) {
        int index2 = this.indexOfKey(key);
        if (index2 >= 0) {
            void var3_4;
            void var2_3;
            V mapValue = this.valueAt(index2);
            if (Intrinsics.areEqual((Object)var2_3, (Object)var3_4)) {
                void var1_2;
                this.removeAt((int)var1_2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final V removeAt(int index2) {
        void var2_2;
        Object old = this.keyValues[(index2 << 1) + 1];
        int osize = this._size;
        if (osize <= 1) {
            this.clear();
        } else {
            void var3_3;
            int nsize = osize - 1;
            if (this.hashes.length > 8 && osize < this.hashes.length / 3) {
                int n;
                if (osize > 8) {
                    int n2 = osize;
                    n = n2 + (n2 >> 1);
                } else {
                    n = 8;
                }
                int n3 = n;
                int[] ohashes = this.hashes;
                Object[] oarray = this.keyValues;
                this.hashes = new int[n3];
                this.keyValues = new Object[n3 << 1];
                if (osize != this._size) {
                    throw new ConcurrentModificationException();
                }
                if (index2 > 0) {
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)index2);
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.keyValues, (int)0, (int)0, (int)(index2 << 1));
                }
                if (index2 < nsize) {
                    int n4 = index2;
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)n4, (int)(n4 + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.keyValues, (int)(index2 << 1), (int)(index2 + 1 << 1), (int)(nsize + 1 << 1));
                }
            } else {
                if (index2 < nsize) {
                    void var1_1;
                    int n = index2;
                    ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)n, (int)(n + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])this.keyValues, (Object[])this.keyValues, (int)(index2 << 1), (int)(var1_1 + true << 1), (int)(nsize + 1 << 1));
                }
                this.keyValues[nsize << 1] = null;
                this.keyValues[(nsize << 1) + 1] = null;
            }
            if (var3_3 != this._size) {
                throw new ConcurrentModificationException();
            }
            this._size = nsize;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final V replace(K key, V value) {
        int index2 = this.indexOfKey(key);
        if (index2 >= 0) {
            void var2_3;
            void var1_2;
            return this.setValueAt((int)var1_2, var2_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean replace(K key, V oldValue, V newValue) {
        void var2_3;
        V v;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0 && (v = this.valueAt(index2)) == var2_3) {
            void var3_4;
            void var1_2;
            this.setValueAt((int)var1_2, var3_4);
            return true;
        }
        return false;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        try {
            SimpleArrayMap map;
            if (other instanceof SimpleArrayMap) {
                map = (SimpleArrayMap)other;
                if (this._size != map._size) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    V theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
            if (map instanceof Map) {
                if (this._size != ((Map)((Object)map)).size()) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)((Object)map)).get(key);
                    if (!(mine == null ? theirs != null || !((Map)((Object)map)).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        int[] hashes = this.hashes;
        Object[] array = this.keyValues;
        int result2 = 0;
        int i = 0;
        int v = 1;
        int s = this._size;
        while (i < s) {
            Object value = array[v];
            Object object = value;
            result2 += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this._size * 28);
        buffer.append('{');
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1, null);
    }
}

