/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.SynchronizationKt;
import androidx.compose.ui.text.SynchronizedObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u00012\b\u0010\u001f\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\b\u001a\u00020\u0005J\u0015\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0006\u0010\u0013\u001a\u00020\u0005J\u0015\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010(\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,J'\u0010-\u001a\u0002H.\"\u0004\b\u0002\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000ej\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"Landroidx/compose/ui/text/caches/LruCache;", "K", "V", "", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "keySet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "missCount", "monitor", "Landroidx/compose/ui/text/SynchronizedObject;", "putCount", "<set-?>", "size", "()I", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "synchronizedValue", "R", "block", "Lkotlin/Function0;", "synchronizedValue$ui_text", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "", "trimToSize", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n+ 2 Synchronization.kt\nandroidx/compose/ui/text/SynchronizationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n350#1:354\n350#1:363\n350#1:365\n350#1:367\n350#1:369\n350#1:371\n350#1:373\n33#2:355\n33#2:357\n33#2:358\n33#2:359\n33#2:360\n33#2:361\n33#2:362\n33#2:364\n33#2:366\n33#2:368\n33#2:370\n33#2:372\n33#2:374\n33#2:375\n33#2:376\n33#2:377\n1#3:356\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n*L\n40#1:354\n297#1:363\n303#1:365\n309#1:367\n314#1:369\n319#1:371\n324#1:373\n40#1:355\n71#1:357\n86#1:358\n104#1:359\n142#1:360\n176#1:361\n218#1:362\n297#1:364\n303#1:366\n309#1:368\n314#1:370\n319#1:372\n324#1:374\n331#1:375\n341#1:376\n350#1:377\n*E\n"})
public class LruCache<K, V> {
    private final SynchronizedObject monitor = SynchronizationKt.createSynchronizedObject();
    private final HashMap<K, V> map;
    private final LinkedHashSet<K> keySet;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;
    public static final int $stable = 8;

    @JvmName(name="size")
    public final int size() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public LruCache(int maxSize2) {
        void var1_1;
        if (!(maxSize2 > 0)) {
            String maxSize2 = "maxSize <= 0";
            throw new IllegalArgumentException(maxSize2.toString());
        }
        this.maxSize = var1_1;
        this.map = new HashMap(0, 0.75f);
        this.keySet = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public void resize(int maxSize2) {
        if (!(maxSize2 > 0)) {
            String maxSize2 = "maxSize <= 0";
            throw new IllegalArgumentException(maxSize2.toString());
        }
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            void var1_1;
            int maxSize2;
            this.maxSize = maxSize2;
            // ** MonitorExit[var2_4] (shouldn't be in output)
            this.trimToSize((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            V mapValue;
            block11: {
                mapValue = this.map.get(key);
                if (mapValue == null) break block11;
                this.keySet.remove(key);
                this.keySet.add(key);
                int n = this.hitCount;
                this.hitCount = n + 1;
                key = mapValue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (V)key;
            }
            int n = this.missCount;
            this.missCount = n + 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            V createdValue = this.create(key);
            if (createdValue == null) {
                return null;
            }
            SynchronizedObject synchronizedObject3 = this.monitor;
            SynchronizedObject synchronizedObject4 = synchronizedObject3;
            synchronizedObject4 = synchronizedObject3;
            synchronized (synchronizedObject3) {
                int n2 = this.createCount;
                this.createCount = n2 + 1;
                V previousValue = this.map.put(key, createdValue);
                this.keySet.remove(key);
                this.keySet.add(key);
                if (previousValue != null) {
                    this.map.put(key, previousValue);
                    mapValue = previousValue;
                } else {
                    this.size = this.size() + this.safeSizeOf(key, createdValue);
                }
                // ** MonitorExit[var4_7] (shouldn't be in output)
                if (mapValue != null) {
                    void var2_4;
                    void var1_1;
                    this.entryRemoved(false, var1_1, createdValue, mapValue);
                    return var2_4;
                }
                LruCache lruCache = this;
                lruCache.trimToSize(lruCache.maxSize);
                return (V)synchronizedObject2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        SynchronizedObject synchronizedObject;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        SynchronizedObject synchronizedObject2 = synchronizedObject = this.monitor;
        synchronized (synchronizedObject) {
            void var3_6;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size = this.size() + this.safeSizeOf(key, value);
            V previous = this.map.put(key, value);
            if (previous != null) {
                this.size = this.size() - this.safeSizeOf(key, previous);
            }
            if (this.keySet.contains(key)) {
                this.keySet.remove(key);
            }
            this.keySet.add(key);
            // ** MonitorExit[var4_7] (shouldn't be in output)
            if (previous != null) {
                void var2_3;
                void var1_1;
                this.entryRemoved(false, var1_1, previous, var2_3);
            }
            LruCache lruCache = this;
            lruCache.trimToSize(lruCache.maxSize);
            return var3_6;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void trimToSize(int maxSize) {
        while (true) {
            void var3_3;
            void var2_2;
            Object key = null;
            V value = null;
            SynchronizedObject synchronizedObject = this.monitor;
            SynchronizedObject synchronizedObject2 = synchronizedObject;
            synchronizedObject2 = synchronizedObject;
            // MONITORENTER : synchronizedObject
            if (this.size() < 0) throw new IllegalStateException("map/keySet size inconsistency");
            if (this.map.isEmpty()) {
                if (this.size() != 0) throw new IllegalStateException("map/keySet size inconsistency");
            }
            if (this.map.isEmpty() != this.keySet.isEmpty()) {
                throw new IllegalStateException("map/keySet size inconsistency");
            }
            if (this.size() > maxSize && !this.map.isEmpty()) {
                key = CollectionsKt.first((Iterable)this.keySet);
                Object v = ((Map)this.map).get(key);
                if (v == null) {
                    throw new IllegalStateException("inconsistent state");
                }
                value = v;
                Object object = this.map;
                Object object2 = key;
                TypeIntrinsics.asMutableMap((Object)object).remove(object2);
                object = this.keySet;
                object2 = key;
                TypeIntrinsics.asMutableCollection((Object)object).remove(object2);
                int n = this.size();
                Object object3 = key;
                Intrinsics.checkNotNull((Object)object3);
                V v2 = value;
                Intrinsics.checkNotNull(v2);
                this.size = n - this.safeSizeOf(object3, v2);
                int n2 = this.evictionCount;
                this.evictionCount = n2 + 1;
            }
            // MONITOREXIT : synchronizedObject2
            if (key == null) {
                if (value == null) return;
            }
            void v5 = var2_2;
            Intrinsics.checkNotNull((Object)v5);
            void v6 = var3_3;
            Intrinsics.checkNotNull((Object)v6);
            this.entryRemoved(true, v5, v6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(K key) {
        SynchronizedObject synchronizedObject;
        if (key == null) {
            throw new NullPointerException();
        }
        SynchronizedObject synchronizedObject2 = synchronizedObject = this.monitor;
        synchronized (synchronizedObject) {
            V previous = this.map.remove(key);
            this.keySet.remove(key);
            if (previous != null) {
                this.size = this.size() - this.safeSizeOf(key, previous);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (previous != null) {
                void var1_1;
                this.entryRemoved(false, var1_1, previous, null);
            }
            return (V)synchronizedObject;
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int safeSizeOf(K key, V value) {
        void var3_3;
        int result2 = this.sizeOf(key, value);
        if (!(result2 >= 0)) {
            void var2_2;
            String string;
            string = "Negative size: " + string + '=' + var2_2;
            throw new IllegalStateException(string.toString());
        }
        return (int)var3_3;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final int maxSize() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.maxSize;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int hitCount() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.hitCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int missCount() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.missCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int createCount() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.createCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int putCount() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.putCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int evictionCount() {
        Object object = this;
        SynchronizedObject synchronizedObject = ((LruCache)object).monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.evictionCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final Map<K, V> snapshot() {
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            Map map;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Object key : this.keySet) {
                V v = this.map.get(key);
                Intrinsics.checkNotNull(v);
                linkedHashMap.put(key, v);
            }
            map = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            void var2_2;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + (int)var2_2 + "%]";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }

    public final <R> R synchronizedValue$ui_text(Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            try {
                Object object;
                object = object.invoke();
                return (R)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                InlineMarker.finallyEnd((int)1);
            }
        }
    }
}

