/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 :2\u00020\u0001:\u00039:;B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0096\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J$\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0007J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000J\u0016\u0010-\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\u001e\u0010.\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\b\u0010/\u001a\u00020\u0013H\u0016J\u0011\u00100\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0087\u0002J\u0018\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J\u0018\u00101\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u00020\u0003H\u0016R$\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\"\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "spanStylesOrNull", "paragraphStylesOrNull", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getParagraphStylesOrNull$ui_text", "getSpanStyles", "getSpanStylesOrNull$ui_text", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getLinkAnnotations", "Landroidx/compose/ui/text/LinkAnnotation;", "start", "end", "getStringAnnotations", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "hasEqualAnnotations", "hasLinkAnnotations", "hasStringAnnotations", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Companion", "Range", "ui-text"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1045#2:1271\n33#3,6:1272\n235#3,3:1279\n33#3,4:1282\n238#3,2:1286\n38#3:1288\n240#3:1289\n101#3,2:1290\n33#3,6:1292\n103#3:1298\n235#3,3:1299\n33#3,4:1302\n238#3,2:1306\n38#3:1308\n240#3:1309\n235#3,3:1310\n33#3,4:1313\n238#3,2:1317\n38#3:1319\n240#3:1320\n235#3,3:1321\n33#3,4:1324\n238#3,2:1328\n38#3:1330\n240#3:1331\n235#3,3:1332\n33#3,4:1335\n238#3,2:1339\n38#3:1341\n240#3:1342\n101#3,2:1343\n33#3,6:1345\n103#3:1351\n1#4:1278\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n88#1:1271\n88#1:1272,6\n161#1:1279,3\n161#1:1282,4\n161#1:1286,2\n161#1:1288\n161#1:1289\n169#1:1290,2\n169#1:1292,6\n169#1:1298\n184#1:1299,3\n184#1:1302,4\n184#1:1306,2\n184#1:1308\n184#1:1309\n199#1:1310,3\n199#1:1313,4\n199#1:1317,2\n199#1:1319\n199#1:1320\n216#1:1321,3\n216#1:1324,4\n216#1:1328,2\n216#1:1330\n216#1:1331\n231#1:1332,3\n231#1:1335,4\n231#1:1339,2\n231#1:1341\n231#1:1342\n239#1:1343,2\n239#1:1345,6\n239#1:1351\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    public static final Companion Companion = new Companion(null);
    private final String text;
    private final List<Range<SpanStyle>> spanStylesOrNull;
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    private final List<Range<? extends Object>> annotations;
    public static final int $stable;
    private static final Saver<AnnotatedString, ?> Saver;

    public AnnotatedString(String text, List<Range<SpanStyle>> spanStylesOrNull, List<Range<ParagraphStyle>> paragraphStylesOrNull, List<? extends Range<? extends Object>> annotations) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.spanStylesOrNull = spanStylesOrNull;
        this.paragraphStylesOrNull = paragraphStylesOrNull;
        this.annotations = annotations;
        int lastStyleEnd2 = -1;
        List list = this.paragraphStylesOrNull;
        if (list != null && (list = CollectionsKt.sortedWith((Iterable)(spanStylesOrNull = (Iterable)list), (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (Range)a;
                Range it = (Range)((Object)comparable);
                comparable = Integer.valueOf(((Range)a).getStart());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(var1_1.getStart()));
            }
        })) != null) {
            List $this$fastForEach$iv = list;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object e = $this$fastForEach$iv.get(index$iv);
                Range paragraphStyle = (Range)e;
                if (!(paragraphStyle.getStart() >= lastStyleEnd2)) {
                    String lastStyleEnd2 = "ParagraphStyle should not overlap";
                    throw new IllegalArgumentException(lastStyleEnd2.toString());
                }
                if (!(paragraphStyle.getEnd() <= this.text.length())) {
                    String lastStyleEnd2 = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                    throw new IllegalArgumentException(lastStyleEnd2.toString());
                }
                lastStyleEnd2 = paragraphStyle.getEnd();
            }
            return;
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            list3 = null;
        }
        this(string, list, list2, list3);
    }

    public final String getText() {
        return this.text;
    }

    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text() {
        return this.spanStylesOrNull;
    }

    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    public final List<Range<? extends Object>> getAnnotations$ui_text() {
        return this.annotations;
    }

    public final List<Range<SpanStyle>> getSpanStyles() {
        List list = this.spanStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list = this.paragraphStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotatedString(String text, List<Range<SpanStyle>> spanStyles, List<Range<ParagraphStyle>> paragraphStyles) {
        Object object;
        List list;
        Collection collection;
        void var2_2;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        Object object3 = this;
        void v1 = object2;
        object2 = (Collection)var2_2;
        if (object2.isEmpty()) {
            var2_2 = v1;
            object3 = object2 = object3;
            v1 = var2_2;
            collection = null;
        } else {
            collection = object2;
        }
        List list2 = (List)collection;
        object2 = list;
        if (object2.isEmpty()) {
            list = list2;
            var2_2 = v1;
            object3 = object2 = object3;
            v1 = var2_2;
            list2 = list;
            object = null;
        } else {
            object = object2;
        }
        ((AnnotatedString)object3)((String)v1, list2, (List)object, null);
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    public final int getLength() {
        return this.text.length();
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index2) {
        void var1_1;
        return this.text.charAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AnnotatedString subSequence(int startIndex22, int endIndex) {
        void var2_3;
        void var1_1;
        void var3_4;
        int startIndex22;
        if (!(startIndex22 <= endIndex)) {
            String startIndex22 = "start (" + startIndex22 + ") should be less or equal to end (" + endIndex + ')';
            throw new IllegalArgumentException(startIndex22.toString());
        }
        if (startIndex22 == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex22, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        return new AnnotatedString((String)var3_4, AnnotatedStringKt.access$filterRanges(this.spanStylesOrNull, startIndex22, endIndex), AnnotatedStringKt.access$filterRanges(this.paragraphStylesOrNull, startIndex22, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, (int)var1_1, (int)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        void var1_1;
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    public final AnnotatedString plus(AnnotatedString other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u247 = new Builder(this);
        $this$plus_u24lambda_u247.append((AnnotatedString)var1_1);
        return var2_2.toAnnotatedString();
    }

    public final List<Range<String>> getStringAnnotations(String tag, int start, int end) {
        List list;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> range;
                Range<? extends Object> it$iv = range = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range<? extends Object> it = range;
                if (!(range.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list;
    }

    public final boolean hasStringAnnotations(String tag, int start, int end) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            List<Range<? extends Object>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Object>> list2 = list;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = list;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> range = $this$fastForEach$iv$iv.get(index$iv$iv);
                    Range<? extends Object> range2 = range;
                    range2 = range;
                    Range<? extends Object> it = range;
                    if (!(range.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block2;
                }
                return false;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<String>> getStringAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof String && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.TtsAnnotation>>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use LinkAnnotation API instead", replaceWith=@ReplaceWith(expression="getLinkAnnotations(start, end)", imports={}))
    @ExperimentalTextApi
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list;
    }

    public final boolean hasLinkAnnotations(int start, int end) {
        boolean bl;
        block2: {
            List<Range<? extends Object>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Object>> $this$fastForEach$iv$iv = list;
                $this$fastForEach$iv$iv = list;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> range = $this$fastForEach$iv$iv.get(index$iv$iv);
                    Range<? extends Object> range2 = range;
                    range2 = range;
                    Range<? extends Object> it = range;
                    if (!(range.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block2;
                }
                return false;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStylesOrNull, ((AnnotatedString)other).spanStylesOrNull)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStylesOrNull, ((AnnotatedString)other).paragraphStylesOrNull)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)var1_1).annotations);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result2 = this.text.hashCode();
        List<Range<SpanStyle>> list = this.spanStylesOrNull;
        result2 = result2 * 31 + (list != null ? ((Object)list).hashCode() : 0);
        List<Range<ParagraphStyle>> list2 = this.paragraphStylesOrNull;
        result2 = result2 * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        List<Range<? extends Object>> list3 = this.annotations;
        var1_1 = var1_1 * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        return (int)var1_1;
    }

    @Override
    public final String toString() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasEqualAnnotations(AnnotatedString other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual(this.annotations, var1_1.annotations);
    }

    static {
        Saver = SaversKt.getAnnotatedStringSaver();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ&\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ \u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J \u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0006J\u001e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/H\u0016J\"\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\b,J\u0006\u00101\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0013J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0015J\u000e\u00108\u001a\u00020\t2\u0006\u0010'\u001a\u00020(J\u0010\u00109\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0007J\u0006\u0010:\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addLink", "", "clickable", "Landroidx/compose/ui/text/LinkAnnotation$Clickable;", "start", "end", "url", "Landroidx/compose/ui/text/LinkAnnotation$Url;", "addStringAnnotation", "tag", "annotation", "addStyle", "style", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "append", "char", "", "", "deprecated_append_returning_void", "pop", "index", "pushLink", "link", "Landroidx/compose/ui/text/LinkAnnotation;", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "pushUrlAnnotation", "toAnnotatedString", "MutableRange", "ui-text"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n33#2,6:1271\n33#2,6:1277\n33#2,6:1283\n33#2,6:1289\n33#2,6:1295\n33#2,6:1301\n151#2,3:1308\n33#2,4:1311\n154#2,2:1315\n38#2:1317\n156#2:1318\n151#2,3:1319\n33#2,4:1322\n154#2,2:1326\n38#2:1328\n156#2:1329\n151#2,3:1330\n33#2,4:1333\n154#2,2:1337\n38#2:1339\n156#2:1340\n1#3:1307\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n436#1:1271,6\n439#1:1277,6\n443#1:1283,6\n463#1:1289,6\n466#1:1295,6\n470#1:1301,6\n742#1:1308,3\n742#1:1311,4\n742#1:1315,2\n742#1:1317\n742#1:1318\n745#1:1319,3\n745#1:1322,4\n745#1:1326,2\n745#1:1328\n745#1:1329\n748#1:1330,3\n748#1:1333,4\n748#1:1337,2\n748#1:1339\n748#1:1340\n*E\n"})
    public static final class Builder
    implements Appendable {
        private final StringBuilder text;
        private final List<MutableRange<SpanStyle>> spanStyles;
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        private final List<MutableRange<? extends Object>> annotations;
        private final List<MutableRange<? extends Object>> styleStack;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public Builder(int capacity) {
            void var1_1;
            this.text = new StringBuilder((int)var1_1);
            this.spanStyles = new ArrayList();
            this.paragraphStyles = new ArrayList();
            this.annotations = new ArrayList();
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(String text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(AnnotatedString text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append((AnnotatedString)var1_1);
        }

        public final int getLength() {
            return this.text.length();
        }

        /*
         * WARNING - void declaration
         */
        public final void append(String text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Replaced by the append(Char) method that returns an Appendable. This method must be kept around for binary compatibility.", level=DeprecationLevel.HIDDEN)
        @JvmName(name="append")
        public final /* synthetic */ void append(char c) {
            void var1_1;
            this.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(CharSequence text) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text);
            } else {
                void var1_1;
                this.text.append((CharSequence)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(CharSequence text, int start, int end) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text, start, end);
            } else {
                void var3_3;
                void var2_2;
                void var1_1;
                this.text.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(char c) {
            void var1_1;
            this.text.append((char)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final void append(AnnotatedString text) {
            void var1_1;
            Range<Object> it;
            int index$iv;
            int n;
            List<Range<Object>> $this$fastForEach$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            List<Range<SpanStyle>> list = text.getSpanStylesOrNull$ui_text();
            if (list != null) {
                $this$fastForEach$iv = list;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    Range<Object> range;
                    it = range = $this$fastForEach$iv.get(index$iv);
                    this.addStyle((SpanStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                }
            }
            List<Range<ParagraphStyle>> list2 = text.getParagraphStylesOrNull$ui_text();
            if (list2 != null) {
                $this$fastForEach$iv = list2;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    this.addStyle((ParagraphStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                }
            }
            List<Range<? extends Object>> list3 = var1_1.getAnnotations$ui_text();
            if (list3 != null) {
                $this$fastForEach$iv = list3;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    this.annotations.add(new MutableRange<Object>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void append(AnnotatedString text, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Range<Object> it;
            int index$iv;
            int n;
            List $this$fastForEach$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int insertionStart = this.text.length();
            this.text.append(text.getText(), start, end);
            List list = AnnotatedStringKt.access$getLocalSpanStyles(text, start, end);
            if (list != null) {
                $this$fastForEach$iv = list;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    Object e = $this$fastForEach$iv.get(index$iv);
                    it = (Range)e;
                    this.addStyle((SpanStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                }
            }
            List list2 = AnnotatedStringKt.access$getLocalParagraphStyles(text, start, end);
            if (list2 != null) {
                $this$fastForEach$iv = list2;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    it = it;
                    this.addStyle((ParagraphStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                }
            }
            List list3 = AnnotatedStringKt.access$getLocalAnnotations((AnnotatedString)var1_1, (int)var2_2, (int)var3_3);
            if (list3 != null) {
                $this$fastForEach$iv = list3;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$fastForEach$iv.get(index$iv);
                    it = it;
                    this.annotations.add(new MutableRange<Object>(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addStyle(SpanStyle style, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.spanStyles.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final void addStyle(ParagraphStyle style, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final void addStringAnnotation(String tag, String annotation, int start, int end) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableRange<void>(var2_2, (int)var3_3, end, (String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @ExperimentalTextApi
        public final void addTtsAnnotation(TtsAnnotation ttsAnnotation, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="addLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final void addUrlAnnotation(UrlAnnotation urlAnnotation, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final void addLink(LinkAnnotation.Url url, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final void addLink(LinkAnnotation.Clickable clickable, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)clickable, (String)"clickable");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStyle(SpanStyle style) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = new MutableRange(style, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.spanStyles.add((MutableRange<SpanStyle>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStyle(ParagraphStyle style) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = new MutableRange(style, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.paragraphStyles.add((MutableRange<ParagraphStyle>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStringAnnotation(String tag, String annotation) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange it = new MutableRange(var2_2, this.text.length(), 0, tag, 4, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Object>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushTtsAnnotation(TtsAnnotation ttsAnnotation) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            MutableRange it = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Object>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="pushLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final int pushUrlAnnotation(UrlAnnotation urlAnnotation) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            MutableRange it = new MutableRange(urlAnnotation, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Object>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushLink(LinkAnnotation link) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            MutableRange it = new MutableRange(link, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Object>)var1_1);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            if (!(!((Collection)this.styleStack).isEmpty())) {
                String string = "Nothing to pop.";
                throw new IllegalStateException(string.toString());
            }
            MutableRange<? extends Object> mutableRange = this.styleStack.remove(this.styleStack.size() - 1);
            mutableRange.setEnd(this.text.length());
        }

        public final void pop(int index222) {
            int index222;
            if (!(index222 < this.styleStack.size())) {
                String index222 = index222 + " should be less than " + this.styleStack.size();
                throw new IllegalStateException(index222.toString());
            }
            while (this.styleStack.size() - 1 >= index222) {
                this.pop();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final AnnotatedString toAnnotatedString() {
            Collection<MutableRange<SpanStyle>> collection;
            Collection<MutableRange<ParagraphStyle>> collection2;
            Collection<Range<ParagraphStyle>> collection3;
            Collection<MutableRange<ParagraphStyle>> collection4;
            Collection<MutableRange<ParagraphStyle>> collection5;
            List<MutableRange<ParagraphStyle>> list;
            MutableRange<ParagraphStyle> it;
            Collection collection6;
            Object it$iv;
            int index$iv$iv;
            Collection<MutableRange<Object>> $this$fastForEach$iv$iv;
            void $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Collection<MutableRange<SpanStyle>> collection7 = this.spanStyles;
            String string2 = string;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            int n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = (MutableRange)it$iv;
                collection6 = target$iv;
                collection6.add(it.toRange(this.text.length()));
            }
            String string3 = string2;
            $this$fastForEach$iv$iv = target$iv;
            if ($this$fastForEach$iv$iv.isEmpty()) {
                string2 = string3;
                list = null;
                string3 = string2;
            } else {
                list = $this$fastForEach$iv$iv;
            }
            $this$fastForEach$iv$iv = this.paragraphStyles;
            collection6 = list;
            string2 = string3;
            target$iv = new ArrayList($this$fastMap$iv.size());
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = it;
                it$iv = (MutableRange)it$iv;
                collection5 = target$iv;
                collection5.add((MutableRange<ParagraphStyle>)((Object)it.toRange(this.text.length())));
            }
            collection5 = target$iv;
            String string4 = string2;
            Collection collection8 = collection6;
            $this$fastForEach$iv$iv = collection5;
            if ($this$fastForEach$iv$iv.isEmpty()) {
                collection6 = collection8;
                string4 = string2 = string4;
                collection8 = collection6;
                collection4 = null;
            } else {
                collection4 = $this$fastForEach$iv$iv;
            }
            $this$fastForEach$iv$iv = this.annotations;
            collection5 = collection4;
            collection6 = collection8;
            string2 = string4;
            target$iv = new ArrayList($this$fastMap$iv.size());
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = it;
                it$iv = (MutableRange)it$iv;
                collection3 = target$iv;
                collection3.add(it.toRange(this.text.length()));
            }
            collection3 = (List)collection2;
            String string5 = string2;
            Collection collection9 = collection6;
            Collection<MutableRange<ParagraphStyle>> collection10 = collection5;
            collection7 = collection3;
            if (collection7.isEmpty()) {
                collection5 = collection10;
                collection6 = collection9;
                string5 = string2 = string5;
                collection9 = collection6;
                collection10 = collection5;
                collection = null;
            } else {
                collection = collection7;
            }
            collection7 = collection;
            collection2 = collection10;
            Collection collection11 = collection9;
            String string6 = string5;
            return new AnnotatedString(string6, (List<Range<SpanStyle>>)collection11, (List<Range<ParagraphStyle>>)collection2, (List<? extends Range<? extends Object>>)collection7);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1#2:1271\n*E\n"})
        private static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            private final String tag;

            /*
             * WARNING - void declaration
             */
            public MutableRange(T item, int start, int end, String tag) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = var1_1;
                this.start = var2_2;
                this.end = var3_3;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            /*
             * WARNING - void declaration
             */
            public final void setEnd(int n) {
                void var1_1;
                this.end = var1_1;
            }

            public final String getTag() {
                return this.tag;
            }

            /*
             * WARNING - void declaration
             */
            public final Range<T> toRange(int defaultEnd) {
                void var1_1;
                int end2 = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                if (!(end2 != Integer.MIN_VALUE)) {
                    String end2 = "Item.end should be set first";
                    throw new IllegalStateException(end2.toString());
                }
                return new Range<T>(this.item, this.start, (int)var1_1, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            public final String component4() {
                return this.tag;
            }

            /*
             * WARNING - void declaration
             */
            public final MutableRange<T> copy(T item, int start, int end, String tag) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                return new MutableRange<void>(var1_1, (int)var2_2, (int)var3_3, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            public final String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public final int hashCode() {
                int n = this.item == null ? 0 : this.item.hashCode();
                n = n * 31 + Integer.hashCode(this.start);
                n = n * 31 + Integer.hashCode(this.end);
                n = n * 31 + this.tag.hashCode();
                return n;
            }

            public final boolean equals(Object other) {
                MutableRange mutableRange;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                mutableRange = mutableRange;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/ui/text/AnnotatedString;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public final Saver<AnnotatedString, ?> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text"})
    @Immutable
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1#2:1271\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        private final String tag;
        public static final int $stable;

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end, String tag) {
            void var3_3;
            void var2_2;
            String string;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = string;
            this.start = var2_2;
            this.end = var3_3;
            this.tag = tag;
            if (!(this.start <= this.end)) {
                string = "Reversed range is not supported";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final String getTag() {
            return this.tag;
        }

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end) {
            this(var1_1, (int)var2_2, (int)var3_3, "");
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        public final String component4() {
            return this.tag;
        }

        /*
         * WARNING - void declaration
         */
        public final Range<T> copy(T item, int start, int end, String tag) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<void>(var1_1, (int)var2_2, (int)var3_3, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        public final String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public final int hashCode() {
            int n = this.item == null ? 0 : this.item.hashCode();
            n = n * 31 + Integer.hashCode(this.start);
            n = n * 31 + Integer.hashCode(this.end);
            n = n * 31 + this.tag.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            Range range;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            range = range;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

