/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LEFT_ANGLE_BRACKET", "Lokio/ByteString;", "SVG_TAG", "isSvg", "", "source", "Lokio/BufferedSource;", "indexOf", "", "bytes", "fromIndex", "toIndex", "GIF_HEADER_87A", "GIF_HEADER_89A", "WEBP_HEADER_RIFF", "WEBP_HEADER_WEBP", "WEBP_HEADER_VPX8", "HEIF_HEADER_FTYP", "HEIF_HEADER_MSF1", "HEIF_HEADER_HEVC", "HEIF_HEADER_HEVX", "isGif", "isWebP", "isAnimatedWebP", "isHeif", "isAnimatedHeif", "image-loader"})
@SourceDebugExtension(value={"SMAP\nSourceType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceType.kt\ncom/seiko/imageloader/util/SourceTypeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SourceTypeKt {
    private static final ByteString LEFT_ANGLE_BRACKET = ByteString.Companion.encodeUtf8("<");
    private static final ByteString SVG_TAG = ByteString.Companion.encodeUtf8("<svg");
    private static final ByteString GIF_HEADER_87A = ByteString.Companion.encodeUtf8("GIF87a");
    private static final ByteString GIF_HEADER_89A = ByteString.Companion.encodeUtf8("GIF89a");
    private static final ByteString WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
    private static final ByteString WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
    private static final ByteString WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    private static final ByteString HEIF_HEADER_FTYP = ByteString.Companion.encodeUtf8("ftyp");
    private static final ByteString HEIF_HEADER_MSF1 = ByteString.Companion.encodeUtf8("msf1");
    private static final ByteString HEIF_HEADER_HEVC = ByteString.Companion.encodeUtf8("hevc");
    private static final ByteString HEIF_HEADER_HEVX = ByteString.Companion.encodeUtf8("hevx");

    public static final boolean isSvg(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, LEFT_ANGLE_BRACKET) && SourceTypeKt.indexOf(bufferedSource, SVG_TAG, 0L, 1024L) != -1L;
    }

    /*
     * WARNING - void declaration
     */
    private static final long indexOf(BufferedSource $this$indexOf, ByteString bytes, long fromIndex, long toIndex) {
        void var2_2;
        if (!(bytes.size() > 0)) {
            String string = "bytes is empty";
            throw new IllegalArgumentException(string.toString());
        }
        byte firstByte = bytes.getByte(0);
        long lastIndex = toIndex - (long)bytes.size();
        long currentIndex = var2_2;
        while (currentIndex < lastIndex) {
            if ((currentIndex = $this$indexOf.indexOf(firstByte, currentIndex, lastIndex)) == -1L || $this$indexOf.rangeEquals(currentIndex, bytes)) {
                return currentIndex;
            }
            long l = currentIndex;
            currentIndex = l + 1L;
        }
        return -1L;
    }

    public static final boolean isGif(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, GIF_HEADER_89A) || bufferedSource.rangeEquals(0L, GIF_HEADER_87A);
    }

    public static final boolean isWebP(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && bufferedSource.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    public static final boolean isAnimatedWebP(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SourceTypeKt.isWebP(source) && source.rangeEquals(12L, WEBP_HEADER_VPX8) && source.request(17L) && (byte)(bufferedSource.getBuffer().getByte(16L) & 2) > 0;
    }

    public static final boolean isHeif(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return bufferedSource.rangeEquals(4L, HEIF_HEADER_FTYP);
    }

    public static final boolean isAnimatedHeif(BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SourceTypeKt.isHeif(source) && (source.rangeEquals(8L, HEIF_HEADER_MSF1) || source.rangeEquals(8L, HEIF_HEADER_HEVC) || bufferedSource.rangeEquals(8L, HEIF_HEADER_HEVX));
    }
}

