/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.component.fetcher.Fetcher;
import com.seiko.imageloader.component.keyer.Keyer;
import com.seiko.imageloader.component.mapper.Mapper;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BI\b\u0000\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010!\u001a\u00020 J5\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020 0\u001e2\n\u0010$\u001a\u00060&j\u0002`%2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010!\u001a\u00020 \u00a2\u0006\u0002\u0010'R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006("}, d2={"Lcom/seiko/imageloader/component/ComponentRegistry;", "", "mappers", "", "Lcom/seiko/imageloader/component/mapper/Mapper;", "keyers", "Lcom/seiko/imageloader/component/keyer/Keyer;", "fetcherFactories", "Lcom/seiko/imageloader/component/fetcher/Fetcher$Factory;", "decoderFactories", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getMappers", "()Ljava/util/List;", "getKeyers", "getFetcherFactories", "getDecoderFactories", "merge", "component", "merge$image_loader", "map", "data", "options", "Lcom/seiko/imageloader/option/Options;", "key", "", "type", "Lcom/seiko/imageloader/component/keyer/Keyer$Type;", "fetch", "Lkotlin/Pair;", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "", "startIndex", "decode", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "Lcom/seiko/imageloader/model/ImageResult$OfSource;", "(Lcom/seiko/imageloader/model/ImageResult$OfSource;Lcom/seiko/imageloader/option/Options;I)Lkotlin/Pair;", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComponentRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentRegistry.kt\ncom/seiko/imageloader/component/ComponentRegistry\n+ 2 Collections.kt\ncom/seiko/imageloader/util/CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n8#2,2:66\n11#2:69\n8#2,4:70\n1#3:68\n*S KotlinDebug\n*F\n+ 1 ComponentRegistry.kt\ncom/seiko/imageloader/component/ComponentRegistry\n*L\n28#1:66,2\n28#1:69\n35#1:70,4\n*E\n"})
public final class ComponentRegistry {
    private final List<Mapper<? extends Object>> mappers;
    private final List<Keyer> keyers;
    private final List<Fetcher.Factory> fetcherFactories;
    private final List<Decoder.Factory> decoderFactories;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public ComponentRegistry(List<? extends Mapper<? extends Object>> mappers, List<? extends Keyer> keyers, List<? extends Fetcher.Factory> fetcherFactories, List<? extends Decoder.Factory> decoderFactories) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(keyers, (String)"keyers");
        Intrinsics.checkNotNullParameter(fetcherFactories, (String)"fetcherFactories");
        Intrinsics.checkNotNullParameter(decoderFactories, (String)"decoderFactories");
        this.mappers = var1_1;
        this.keyers = var2_2;
        this.fetcherFactories = var3_3;
        this.decoderFactories = decoderFactories;
    }

    public final List<Mapper<? extends Object>> getMappers() {
        return this.mappers;
    }

    public final List<Keyer> getKeyers() {
        return this.keyers;
    }

    public final List<Fetcher.Factory> getFetcherFactories() {
        return this.fetcherFactories;
    }

    public final List<Decoder.Factory> getDecoderFactories() {
        return this.decoderFactories;
    }

    /*
     * WARNING - void declaration
     */
    public final ComponentRegistry merge$image_loader(ComponentRegistry component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return new ComponentRegistry(CollectionsKt.plus((Collection)this.mappers, (Iterable)component.mappers), CollectionsKt.plus((Collection)this.keyers, (Iterable)component.keyers), CollectionsKt.plus((Collection)this.fetcherFactories, (Iterable)component.fetcherFactories), CollectionsKt.plus((Collection)this.decoderFactories, (Iterable)var1_1.decoderFactories));
    }

    /*
     * WARNING - void declaration
     */
    public final Object map(Object data, Options options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List<Mapper<? extends Object>> $this$forEachIndices$iv = this.mappers;
        int n = ((Collection)$this$forEachIndices$iv).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object mappedData;
            Mapper<? extends Object> mapper = $this$forEachIndices$iv.get(i$iv);
            Object object = mapper.map(mappedData, options);
            if (object == null) continue;
            mappedData = object;
            mappedData = object;
        }
        return var1_1;
    }

    public final String key(Object data, Options options, Keyer.Type type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List<Keyer> $this$forEachIndices$iv = this.keyers;
        int n = ((Collection)$this$forEachIndices$iv).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Keyer keyer = $this$forEachIndices$iv.get(i$iv);
            String string = keyer.key(data, options, type);
            if (string == null) continue;
            data = string;
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<Fetcher, Integer> fetch(Object data, Options options, int startIndex) {
        void var1_1;
        void index;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        int n = this.fetcherFactories.size();
        while (index < n) {
            Object object = this.fetcherFactories.get((int)index);
            if ((object = object.create(data, options)) != null) {
                data = object;
                return TuplesKt.to((Object)data, (Object)((int)index));
            }
            ++index;
        }
        throw new RuntimeException("Unable to create a fetcher that supports: " + var1_1);
    }

    public static /* synthetic */ Pair fetch$default(ComponentRegistry componentRegistry, Object object, Options options, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return componentRegistry.fetch(object, options, n);
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<Decoder, Integer> decode(ImageResult.OfSource source, Options options, int startIndex) {
        void var1_1;
        void index;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        int n = this.decoderFactories.size();
        while (index < n) {
            Object object = this.decoderFactories.get((int)index);
            if ((object = object.create((ImageResult.OfSource)source, options)) != null) {
                source = object;
                return TuplesKt.to((Object)source, (Object)((int)index));
            }
            ++index;
        }
        throw new RuntimeException("Unable to create a decoder that supports: " + (ImageResult.OfSource)var1_1);
    }

    public static /* synthetic */ Pair decode$default(ComponentRegistry componentRegistry, ImageResult.OfSource ofSource, Options options, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return componentRegistry.decode(ofSource, options, n);
    }

    public final boolean equals(Object other) {
        ComponentRegistry componentRegistry;
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComponentRegistry)) {
            return false;
        }
        componentRegistry = componentRegistry;
        if (!Intrinsics.areEqual(this.mappers, componentRegistry.mappers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyers, componentRegistry.keyers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fetcherFactories, componentRegistry.fetcherFactories)) {
            return false;
        }
        return Intrinsics.areEqual(this.decoderFactories, componentRegistry.decoderFactories);
    }

    public final int hashCode() {
        int n = ((Object)this.mappers).hashCode();
        n = n * 31 + ((Object)this.keyers).hashCode();
        n = n * 31 + ((Object)this.fetcherFactories).hashCode();
        n = n * 31 + ((Object)this.decoderFactories).hashCode();
        return n;
    }

    public final String toString() {
        return "ComponentRegistry(mappers=" + this.mappers + ", keyers=" + this.keyers + ", fetcherFactories=" + this.fetcherFactories + ", decoderFactories=" + this.decoderFactories + ")";
    }
}

