/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.disk.DiskLruCache;
import com.seiko.imageloader.cache.disk.FaultHidingSink;
import com.seiko.imageloader.util.FileSystemKt;
import com.seiko.imageloader.util.LruHashMap;
import com.seiko.imageloader.util.LruHashMapKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015*\u0001%\b\u0001\u0018\u0000 G2\u00060\u0002j\u0002`\u0001:\u0004DEFGB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0015H\u0002J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u0017\u0010/\u001a\b\u0018\u000100R\u00020\u00002\u0006\u00101\u001a\u00020\u0015H\u0086\u0002J\u0014\u00102\u001a\b\u0018\u000103R\u00020\u00002\u0006\u00101\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\nJ\u001c\u00104\u001a\u00020(2\n\u00105\u001a\u000603R\u00020\u00002\u0006\u00106\u001a\u00020\u001eH\u0002J\b\u00107\u001a\u00020\u001eH\u0002J\u000e\u00108\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u0015J\u0014\u00109\u001a\u00020\u001e2\n\u0010:\u001a\u00060\u0016R\u00020\u0000H\u0002J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0016J\u0006\u0010=\u001a\u00020(J\b\u0010>\u001a\u00020(H\u0002J\b\u0010?\u001a\u00020\u001eH\u0002J\b\u0010@\u001a\u00020(H\u0002J\u0006\u0010A\u001a\u00020(J\b\u0010B\u001a\u00020(H\u0002J\u0010\u0010C\u001a\u00020(2\u0006\u00101\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u0006H"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "Lokio/Closeable;", "Ljava/io/Closeable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "<init>", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "journalFile", "journalFileTmp", "journalFileBackup", "lruEntries", "Lcom/seiko/imageloader/util/LruHashMap;", "", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "size", "operationsSinceRewrite", "journalWriter", "Lokio/BufferedSink;", "hasJournalErrors", "", "initialized", "closed", "mostRecentTrimFailed", "mostRecentRebuildFailed", "syncObject", "", "com/seiko/imageloader/cache/disk/DiskLruCache$fileSystem$1", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$fileSystem$1;", "initialize", "", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "writeJournal", "get", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "key", "edit", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "completeEdit", "editor", "success", "journalRewriteRequired", "remove", "removeEntry", "entry", "checkNotClosed", "close", "flush", "trimToSize", "removeOldestEntry", "delete", "evictAll", "launchCleanup", "validateKey", "Snapshot", "Editor", "Entry", "Companion", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,852:1\n1#2:853\n27#3:854\n27#3:879\n27#3:917\n27#3:919\n27#3:921\n27#3:923\n27#3:925\n27#3:927\n27#3:931\n27#3:933\n16#4:855\n16#4:880\n16#4:918\n16#4:920\n16#4:922\n16#4:924\n16#4:926\n16#4:928\n16#4:932\n16#4:934\n66#5:856\n52#5,4:858\n60#5,10:863\n56#5,3:873\n71#5,3:876\n52#5,4:884\n60#5,10:889\n56#5,18:899\n67#6:857\n68#6:862\n80#6:881\n165#6:882\n81#6:883\n82#6:888\n37#7,2:929\n37#7,2:935\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache\n*L\n152#1:854\n308#1:879\n352#1:917\n375#1:919\n426#1:921\n431#1:923\n507#1:925\n563#1:927\n582#1:931\n621#1:933\n152#1:855\n308#1:880\n352#1:918\n375#1:920\n426#1:922\n431#1:924\n507#1:926\n563#1:928\n582#1:932\n621#1:934\n197#1:856\n197#1:858,4\n197#1:863,10\n197#1:873,3\n197#1:876,3\n311#1:884,4\n311#1:889,10\n311#1:899,18\n197#1:857\n197#1:862\n311#1:881\n311#1:882\n311#1:883\n311#1:888\n570#1:929,2\n624#1:935,2\n*E\n"})
public final class DiskLruCache
implements Closeable {
    public static final Companion Companion = new Companion(null);
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    private final Path journalFile;
    private final Path journalFileTmp;
    private final Path journalFileBackup;
    private final LruHashMap<String, Entry> lruEntries;
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private final Object syncObject;
    private final fileSystem.1 fileSystem;
    public static final int $stable = 8;
    public static final String JOURNAL_FILE = "journal";
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    public static final String MAGIC = "libcore.io.DiskLruCache";
    public static final String VERSION = "1";
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z\\d_-]{1,120}");

    /*
     * WARNING - void declaration
     */
    public DiskLruCache(FileSystem fileSystem2, Path directory, CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)cleanupDispatcher, (String)"cleanupDispatcher");
        this.directory = var2_2;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            fileSystem2 = "maxSize <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        if (!(this.valueCount > 0)) {
            fileSystem2 = "valueCount <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = new LruHashMap(0, 0.75f);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)var3_3, (int)1, null, (int)2, null)));
        this.syncObject = new Object();
        this.fileSystem = new ForwardingFileSystem((FileSystem)var1_1){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Sink sink(Path file, boolean mustCreate) {
                void var2_2;
                void var1_1;
                block0: {
                    void var3_3;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path p0 = path;
                    this.createDirectories((Path)var3_3);
                }
                return super.sink((Path)var1_1, (boolean)var2_2);
            }
        };
    }

    public final void initialize() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            if (this.initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournal() {
        void var2_2;
        void this_$iv;
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFile;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource bufferedSource;
            Object $this$readJournal_u24lambda_u243 = bufferedSource = (BufferedSource)$this$use$iv$iv;
            String magic = bufferedSource.readUtf8LineStrict();
            String version = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String appVersionString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String valueCountString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String blank = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            if (!(Intrinsics.areEqual((Object)MAGIC, (Object)magic) && Intrinsics.areEqual((Object)VERSION, (Object)version) && Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString) && Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString) && !(((CharSequence)blank).length() > 0))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u243.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.operationsSinceRewrite = lineCount - this.lruEntries.getEntries().size();
                if (!$this$readJournal_u24lambda_u243.exhausted()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$readJournal_u24lambda_u243 = throwable;
                    thrown$iv$iv = throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable $this$readJournal_u24lambda_u243 = throwable;
            thrown$iv$iv = throwable;
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                void var3_5;
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)var3_5);
            }
        }
        catch (Throwable throwable) {
            try {
                FileSystem fileSystem3 = fileSystem2;
                if (fileSystem3 != null) {
                    fileSystem3.close();
                }
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        void v7 = var2_2;
        if (v7 != null) {
            throw v7;
        }
    }

    private final BufferedSink newJournalWriter() {
        FaultHidingSink faultHidingSink;
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        faultHidingSink = new FaultHidingSink(faultHidingSink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$4(this, arg_0)));
        return Okio.buffer((Sink)faultHidingSink);
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournalLine(String line) {
        void var2_2;
        void var1_1;
        String key22;
        int firstSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + (String)line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        if (secondSpace == -1) {
            String string = ((String)line).substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
            if (firstSpace == 6 && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key22);
                return;
            }
        } else {
            void key22;
            String string = ((String)line).substring((int)key22, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
        }
        Entry entry = LruHashMapKt.getOrPut(this.lruEntries, key22, () -> DiskLruCache.readJournalLine$lambda$5(this, key22));
        if (secondSpace != -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = ((String)line).substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[1];
            line = cArray;
            cArray[0] = 32;
            List parts = StringsKt.split$default((CharSequence)string, (char[])line, (boolean)false, (int)0, (int)6, null);
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths((List<String>)var1_1);
            return;
        }
        if (secondSpace == -1 && firstSpace == 5 && StringsKt.startsWith$default((String)var1_1, (String)DIRTY, (boolean)false, (int)2, null)) {
            void var3_4;
            entry.setCurrentEditor(new Editor(this, (Entry)var3_4));
            return;
        }
        if (secondSpace != -1 || var2_2 != 4 || !StringsKt.startsWith$default((String)var1_1, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processJournal() {
        void var1_1;
        long size = 0L;
        for (Map.Entry<String, Entry> entry : this.lruEntries.getEntries()) {
            int i;
            int n;
            if (entry.getValue().getCurrentEditor() == null) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    size += entry.getValue().getLengths()[i];
                }
                continue;
            }
            entry.getValue().setCurrentEditor(null);
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                Path path = entry.getValue().getCleanFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                this.fileSystem.delete(path);
                Path path2 = entry.getValue().getDirtyFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                this.fileSystem.delete(path2);
            }
            this.lruEntries.remove(entry.getKey());
        }
        this.size = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            void var3_3;
            block19: {
                Object $this$writeJournal_u24lambda_u247_u24lambda_u2462222;
                void $this$iv;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                Path file$iv = this.journalFileTmp;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                Throwable thrown$iv$iv = null;
                try {
                    BufferedSink bufferedSink2;
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = bufferedSink2 = (BufferedSink)$this$use$iv$iv;
                    bufferedSink2.writeUtf8(MAGIC).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(VERSION).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeDecimalLong((long)this.appVersion).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeDecimalLong((long)this.valueCount).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                    for (Map.Entry<String, Entry> entry : this.lruEntries.getEntries()) {
                        if (entry.getValue().getCurrentEditor() != null) {
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(DIRTY);
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(32);
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(entry.getKey());
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                            continue;
                        }
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(CLEAN);
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(32);
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(entry.getKey());
                        entry.getValue().writeLengths((BufferedSink)$this$writeJournal_u24lambda_u247_u24lambda_u2462222);
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                    }
                }
                catch (Throwable throwable) {
                    Throwable $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = throwable;
                    thrown$iv$iv = throwable;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block19;
                    }
                    catch (Throwable t$iv$iv) {
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    try {
                        FileSystem fileSystem3 = fileSystem2;
                        if (fileSystem3 == null) throw throwable;
                        fileSystem3.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = throwable;
                    thrown$iv$iv = throwable;
                }
            }
            void v8 = var3_3;
            if (v8 != null) {
                throw v8;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            // ** MonitorExit[object2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Snapshot get(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            void var3_4;
            void var1_1;
            Object object3;
            block5: {
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                object3 = this.lruEntries.get(key);
                if (object3 != null && (object3 = ((Entry)object3).snapshot()) != null) break block5;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return null;
            }
            Object snapshot = object3;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink $this$get_u24lambda_u249_u24lambda_u248 = bufferedSink;
            bufferedSink.writeUtf8(READ);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(32);
            $this$get_u24lambda_u249_u24lambda_u248.writeUtf8((String)var1_1);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            var1_1 = var3_4;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Editor edit(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            void var3_4;
            Editor editor;
            Entry entry;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            this.checkNotClosed();
                            this.validateKey(key);
                            this.initialize();
                            entry = this.lruEntries.get(key);
                            if ((entry != null ? entry.getCurrentEditor() : null) == null) break block8;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return null;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        return null;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return null;
                }
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                BufferedSink bufferedSink2 = bufferedSink;
                BufferedSink $this$edit_u24lambda_u2411_u24lambda_u2410 = bufferedSink;
                bufferedSink.writeUtf8(DIRTY);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(32);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeUtf8(key);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(10);
                $this$edit_u24lambda_u2411_u24lambda_u2410.flush();
                if (!this.hasJournalErrors) break block11;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return null;
            }
            if (entry == null) {
                entry = new Entry(key);
                this.lruEntries.put((String)((Object)editor), entry);
            }
            Editor editor2 = new Editor(this, entry);
            var3_4.setCurrentEditor(editor2);
            editor = editor2;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return editor;
        }
    }

    public final long size() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            this.initialize();
            long l = this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return l;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeEdit(Editor editor, boolean success) {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            void var2_3;
            int i;
            int n;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (success && !entry.getZombie()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    if (!editor.getWritten()[i]) continue;
                    Path path = entry.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    if (this.fileSystem.exists(path)) continue;
                    editor.abort();
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return;
                }
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    long newLength;
                    Path clean;
                    Path dirty;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getDirtyFiles().get(i), (String)"get(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getCleanFiles().get(i), (String)"get(...)");
                    if (this.fileSystem.exists(dirty)) {
                        void var1_1;
                        this.fileSystem.atomicMove((Path)var1_1, clean);
                    } else {
                        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                        Path path = entry.getCleanFiles().get(i);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        FileSystemKt.createFile(fileSystem2, path);
                    }
                    long oldLength = entry.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry.getLengths()[i] = newLength = l != null ? l : 0L;
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    Path path = entry.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    this.fileSystem.delete(path);
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink $this$completeEdit_u24lambda_u2414_u24lambda_u2413 = bufferedSink;
            if (var2_3 != false || entry.getReadable()) {
                entry.setReadable(true);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(CLEAN);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                entry.writeLengths($this$completeEdit_u24lambda_u2414_u24lambda_u2413);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            } else {
                this.lruEntries.remove(entry.getKey());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(REMOVE);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2414_u24lambda_u2413.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            void var1_2;
            Entry entry;
            block5: {
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                if (this.lruEntries.get(key) != null) break block5;
                // ** MonitorExit[var2_4] (shouldn't be in output)
                return false;
            }
            Entry entry2 = entry;
            boolean removed = this.removeEntry(entry2);
            if (removed && this.size <= this.maxSize) {
                this.mostRecentTrimFailed = false;
            }
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return (boolean)var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeEntry(Entry entry) {
        void var1_1;
        int i;
        if (entry.getLockingSnapshotCount() > 0) {
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink2 = bufferedSink;
                BufferedSink $this$removeEntry_u24lambda_u2416 = bufferedSink;
                bufferedSink.writeUtf8(DIRTY);
                $this$removeEntry_u24lambda_u2416.writeByte(32);
                $this$removeEntry_u24lambda_u2416.writeUtf8(entry.getKey());
                $this$removeEntry_u24lambda_u2416.writeByte(10);
                $this$removeEntry_u24lambda_u2416.flush();
            }
        }
        if (entry.getLockingSnapshotCount() > 0 || entry.getCurrentEditor() != null) {
            entry.setZombie(true);
            return true;
        }
        int n = this.valueCount;
        for (i = 0; i < n; ++i) {
            Path path = entry.getCleanFiles().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            this.fileSystem.delete(path);
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
        }
        i = this.operationsSinceRewrite;
        this.operationsSinceRewrite = i + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            void var2_7;
            BufferedSink bufferedSink3 = bufferedSink;
            BufferedSink $this$removeEntry_u24lambda_u2417 = bufferedSink;
            bufferedSink.writeUtf8(REMOVE);
            $this$removeEntry_u24lambda_u2417.writeByte(32);
            $this$removeEntry_u24lambda_u2417.writeUtf8(entry.getKey());
            var2_7.writeByte(10);
        }
        this.lruEntries.remove(var1_1.getKey());
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final void close() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            Collection collection;
            if (!this.initialized || this.closed) {
                this.closed = true;
                // ** MonitorExit[object2] (shouldn't be in output)
                return;
            }
            Collection object32 = collection = (Collection)this.lruEntries.getEntries();
            for (Map.Entry entry : collection.toArray(new Map.Entry[0])) {
                Editor editor = ((Entry)entry.getValue()).getCurrentEditor();
                if (editor == null) continue;
                editor.detach();
            }
            this.trimToSize();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
            this.journalWriter = null;
            this.closed = true;
            // ** MonitorExit[object2] (shouldn't be in output)
            return;
        }
    }

    public final void flush() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            if (!this.initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.flush();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeOldestEntry() {
        for (Map.Entry<String, Entry> toEvict : this.lruEntries.getEntries()) {
            void var2_2;
            if (toEvict.getValue().getZombie()) continue;
            this.removeEntry((Entry)var2_2.getValue());
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemKt.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    public final void evictAll() {
        Object object = this.syncObject;
        Object object2 = object;
        object2 = object;
        synchronized (object) {
            Collection collection;
            this.initialize();
            Collection collection2 = collection = (Collection)this.lruEntries.getEntries();
            for (Map.Entry entry : collection.toArray(new Map.Entry[0])) {
                this.removeEntry((Entry)entry.getValue());
            }
            this.mostRecentTrimFailed = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final void launchCleanup() {
        BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(2, (Continuation)var2_2);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        object = DiskLruCache.access$getSyncObject$p(this.this$0);
                        DiskLruCache diskLruCache = this.this$0;
                        synchronized (object) {
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache, true);
                            }
                            try {
                                if (!DiskLruCache.access$journalRewriteRequired(diskLruCache)) return Unit.INSTANCE;
                                DiskLruCache.access$writeJournal(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                void var2_2;
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            /*
             * WARNING - void declaration
             */
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                void var2_2;
                void var1_1;
                return (this.create(var1_1, (Continuation)var2_2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            String string;
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + (String)string + "\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit newJournalWriter$lambda$4(DiskLruCache this$0, IOException it) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"it");
        var0.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Entry readJournalLine$lambda$5(DiskLruCache this$0, String $key) {
        void var1_1;
        DiskLruCache diskLruCache;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return diskLruCache.new Entry((String)var1_1);
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentTrimFailed = var1_1;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentRebuildFailed = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        void var1_1;
        $this.journalWriter = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$removeEntry(DiskLruCache $this, Entry entry) {
        void var1_1;
        return $this.removeEntry((Entry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$completeEdit(DiskLruCache $this, Editor editor, boolean success) {
        void var2_2;
        void var1_1;
        $this.completeEdit((Editor)var1_1, (boolean)var2_2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Companion;", "", "<init>", "()V", "JOURNAL_FILE", "", "JOURNAL_FILE_TMP", "JOURNAL_FILE_BACKUP", "MAGIC", "VERSION", "CLEAN", "DIRTY", "REMOVE", "READ", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "image-loader"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "", "entry", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "<init>", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;)V", "getEntry", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "closed", "", "written", "", "getWritten", "()[Z", "file", "Lokio/Path;", "index", "", "detach", "", "commit", "commitAndGet", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "abort", "complete", "success", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Editor\n+ 2 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 3 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,852:1\n27#2:853\n27#2:856\n27#2:858\n16#3:854\n16#3:857\n16#3:859\n1#4:855\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Editor\n*L\n705#1:853\n732#1:856\n748#1:858\n705#1:854\n732#1:857\n748#1:859\n*E\n"})
    public final class Editor {
        private final Entry entry;
        private boolean closed;
        private final boolean[] written;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Editor(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
            this.written = new boolean[this.this$0.valueCount];
        }

        public final Entry getEntry() {
            return this.entry;
        }

        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - void declaration
         */
        public final Path file(int index2) {
            Object object = this.this$0.syncObject;
            Object object2 = this.this$0;
            synchronized (object) {
                void var1_1;
                if (!(!this.closed)) {
                    String index2 = "editor is closed";
                    throw new IllegalStateException(index2.toString());
                }
                this.written[index2] = true;
                Path path = this.entry.getDirtyFiles().get((int)var1_1);
                object2 = ((DiskLruCache)object2).fileSystem;
                Path p0 = path;
                FileSystemKt.createFile((FileSystem)object2, p0);
                Path path2 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"also(...)");
                path = path2;
                return path;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        public final Snapshot commitAndGet() {
            Object object = this.this$0.syncObject;
            Closeable closeable = this.this$0;
            synchronized (object) {
                this.commit();
                closeable = closeable.get(this.entry.getKey());
                return closeable;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - void declaration
         */
        private final void complete(boolean success2) {
            Object object = this.this$0.syncObject;
            DiskLruCache diskLruCache = this.this$0;
            synchronized (object) {
                if (!(!this.closed)) {
                    String success2 = "editor is closed";
                    throw new IllegalStateException(success2.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    void var1_1;
                    DiskLruCache.access$completeEdit(diskLruCache, this, (boolean)var1_1);
                }
                this.closed = true;
                return;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/J\f\u00100\u001a\b\u0018\u000101R\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R \u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "", "key", "", "<init>", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "getCleanFiles", "()Ljava/util/ArrayList;", "dirtyFiles", "getDirtyFiles", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "currentEditor", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "getCurrentEditor", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;)V", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "setLengths", "", "strings", "", "writeLengths", "writer", "Lokio/BufferedSink;", "snapshot", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Entry\n+ 2 Collections.kt\ncom/seiko/imageloader/util/CollectionsKt\n*L\n1#1,852:1\n8#2,4:853\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Entry\n*L\n824#1:853,4\n*E\n"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final ArrayList<Path> cleanFiles;
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path = DiskLruCache.this.directory;
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(path.resolve(string));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path2 = DiskLruCache.this.directory;
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(path2.resolve(string2));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey() {
            return this.key;
        }

        public final long[] getLengths() {
            return this.lengths;
        }

        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        /*
         * WARNING - void declaration
         */
        public final void setReadable(boolean bl) {
            void var1_1;
            this.readable = var1_1;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        /*
         * WARNING - void declaration
         */
        public final void setZombie(boolean bl) {
            void var1_1;
            this.zombie = var1_1;
        }

        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentEditor(Editor editor) {
            void var1_1;
            this.currentEditor = var1_1;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLockingSnapshotCount(int n) {
            void var1_1;
            this.lockingSnapshotCount = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths(List<String> strings) {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = ((Collection)strings).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                throw new IOException("unexpected journal line: " + (List)var1_1);
            }
        }

        public final void writeLengths(BufferedSink writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            List list = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            int n = ((Collection)$this$forEachIndices$iv).size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                if (diskLruCache.fileSystem.exists(file)) continue;
                try {
                    DiskLruCache.access$removeEntry(diskLruCache, this);
                }
                catch (IOException iOException) {}
                return null;
            }
            int n2 = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n2 + 1;
            return new Snapshot(DiskLruCache.this, this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0002j\u0002`\u0001B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0005R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "Lokio/Closeable;", "Ljava/io/Closeable;", "entry", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "<init>", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;)V", "getEntry", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "closed", "", "file", "Lokio/Path;", "index", "", "close", "", "closeAndEdit", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n*L\n1#1,852:1\n1#2:853\n27#3:854\n27#3:856\n16#4:855\n16#4:857\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot\n*L\n673#1:854\n683#1:856\n673#1:855\n683#1:857\n*E\n"})
    public final class Snapshot
    implements Closeable {
        private final Entry entry;
        private boolean closed;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Snapshot(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
        }

        public final Entry getEntry() {
            return this.entry;
        }

        /*
         * WARNING - void declaration
         */
        public final Path file(int index2) {
            void var1_1;
            if (!(!this.closed)) {
                String index2 = "snapshot is closed";
                throw new IllegalStateException(index2.toString());
            }
            Path path = this.entry.getCleanFiles().get((int)var1_1);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @Override
        public final void close() {
            if (!this.closed) {
                this.closed = true;
                Object object = this.this$0.syncObject;
                DiskLruCache diskLruCache = this.this$0;
                synchronized (object) {
                    Entry entry = this.entry;
                    int n = entry.getLockingSnapshotCount();
                    entry.setLockingSnapshotCount(n + -1);
                    if (this.entry.getLockingSnapshotCount() == 0 && this.entry.getZombie()) {
                        DiskLruCache.access$removeEntry(diskLruCache, this.entry);
                    }
                    return;
                }
            }
        }

        public final Editor closeAndEdit() {
            Object object = this.this$0.syncObject;
            Object object2 = this.this$0;
            synchronized (object) {
                this.close();
                object2 = ((DiskLruCache)object2).edit(this.entry.getKey());
                return object2;
            }
        }
    }
}

