/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.disk.DiskCache;
import com.seiko.imageloader.cache.disk.DiskCacheBuilder_desktopKt;
import com.seiko.imageloader.cache.disk.RealDiskCache;
import com.seiko.imageloader.util.Platform_nojsandwasmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.FileSystem;
import okio.Path;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000fJ\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskCacheBuilder;", "", "fileSystem", "Lokio/FileSystem;", "<init>", "(Lokio/FileSystem;)V", "directory", "Lokio/Path;", "maxSizePercent", "", "minimumMaxSizeBytes", "", "maximumMaxSizeBytes", "maxSizeBytes", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "", "percent", "size", "dispatcher", "build", "Lcom/seiko/imageloader/cache/disk/DiskCache;", "build$image_loader", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskCacheBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCacheBuilder.kt\ncom/seiko/imageloader/cache/disk/DiskCacheBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class DiskCacheBuilder {
    private final FileSystem fileSystem;
    private Path directory;
    private double maxSizePercent;
    private long minimumMaxSizeBytes;
    private long maximumMaxSizeBytes;
    private long maxSizeBytes;
    private CoroutineDispatcher cleanupDispatcher;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DiskCacheBuilder(FileSystem fileSystem2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        this.fileSystem = var1_1;
        this.maxSizePercent = 0.02;
        this.minimumMaxSizeBytes = 0xA00000L;
        this.maximumMaxSizeBytes = 0xFA00000L;
        this.cleanupDispatcher = Platform_nojsandwasmKt.getIoDispatcher();
    }

    /*
     * WARNING - void declaration
     */
    public final void directory(Path directory) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void maxSizePercent(double percent2) {
        void var1_1;
        if (!(0.0 <= percent2 ? percent2 <= 1.0 : false)) {
            String percent2 = "size must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException(percent2.toString());
        }
        this.maxSizeBytes = 0L;
        this.maxSizePercent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void minimumMaxSizeBytes(long size2) {
        void var1_1;
        if (!(size2 > 0L)) {
            String size2 = "size must be > 0.";
            throw new IllegalArgumentException(size2.toString());
        }
        this.minimumMaxSizeBytes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void maximumMaxSizeBytes(long size2) {
        void var1_1;
        if (!(size2 > 0L)) {
            String size2 = "size must be > 0.";
            throw new IllegalArgumentException(size2.toString());
        }
        this.maximumMaxSizeBytes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void maxSizeBytes(long size2) {
        void var1_1;
        if (!(size2 > 0L)) {
            String size2 = "size must be > 0.";
            throw new IllegalArgumentException(size2.toString());
        }
        this.maxSizePercent = 0.0;
        this.maxSizeBytes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupDispatcher(CoroutineDispatcher dispatcher) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.cleanupDispatcher = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final DiskCache build$image_loader() {
        void var1_2;
        void var2_5;
        long l;
        Path path = this.directory;
        if (path == null) {
            String string = "directory == null";
            throw new IllegalStateException(string.toString());
        }
        Path directory = path;
        if (this.maxSizePercent > 0.0) {
            long l2;
            try {
                double d = this.maxSizePercent * (double)DiskCacheBuilder_desktopKt.directorySize(directory);
                l2 = RangesKt.coerceIn((long)((long)d), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
            }
            catch (Exception exception) {
                l2 = this.minimumMaxSizeBytes;
            }
            l = l2;
        } else {
            l = this.maxSizeBytes;
        }
        long maxSize = l;
        return new RealDiskCache((long)var2_5, (Path)var1_2, this.fileSystem, this.cleanupDispatcher);
    }
}

