/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\"J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001d\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\n\u0010+\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010,\u001a\u00020-H\u0016J\n\u0010.\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006/"}, d2={"Landroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectableId", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "layoutResultCallback", "Landroidx/compose/ui/text/TextLayoutResult;", "(JLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "_previousLastVisibleOffset", "", "_previousTextLayoutResult", "getSelectableId", "()J", "lastVisibleOffset", "getLastVisibleOffset", "(Landroidx/compose/ui/text/TextLayoutResult;)I", "appendSelectableInfoToBuilder", "", "builder", "Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;", "getBoundingBox", "Landroidx/compose/ui/geometry/Rect;", "offset", "getCenterYForOffset", "", "getHandlePosition", "Landroidx/compose/ui/geometry/Offset;", "selection", "Landroidx/compose/foundation/text/selection/Selection;", "isStartHandle", "", "getHandlePosition-dBAh8RU", "(Landroidx/compose/foundation/text/selection/Selection;Z)J", "getLayoutCoordinates", "getLineHeight", "getLineLeft", "getLineRight", "getRangeOfLineContaining", "Landroidx/compose/ui/text/TextRange;", "getRangeOfLineContaining--jx7JFs", "(I)J", "getSelectAllSelection", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "textLayoutResult", "foundation"})
@StabilityInferred(parameters=0)
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiWidgetSelectionDelegate(long selectableId2, Function0<? extends LayoutCoordinates> coordinatesCallback, Function0<TextLayoutResult> layoutResultCallback) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = var1_1;
        this.coordinatesCallback = var3_2;
        this.layoutResultCallback = layoutResultCallback;
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public final long getSelectableId() {
        return this.selectableId;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized int getLastVisibleOffset(TextLayoutResult $this$lastVisibleOffset) {
        if (this._previousTextLayoutResult != $this$lastVisibleOffset) {
            void var1_1;
            void var2_2;
            int n;
            if (!$this$lastVisibleOffset.getDidOverflowHeight() || $this$lastVisibleOffset.getMultiParagraph().getDidExceedMaxLines()) {
                n = $this$lastVisibleOffset.getLineCount() - 1;
            } else {
                int finalVisibleLine;
                TextLayoutResult textLayoutResult = $this$lastVisibleOffset;
                for (finalVisibleLine = RangesKt.coerceAtMost((int)(v394261).getLineForVerticalPosition((float)IntSize.getHeight-impl((long)(v394261).getSize-YbymL2g())), (int)($this$lastVisibleOffset.getLineCount() - 1)); finalVisibleLine >= 0 && $this$lastVisibleOffset.getLineTop(finalVisibleLine) >= (float)IntSize.getHeight-impl((long)$this$lastVisibleOffset.getSize-YbymL2g()); --finalVisibleLine) {
                }
                n = RangesKt.coerceAtLeast((int)finalVisibleLine, (int)0);
            }
            int lastVisibleLine = n;
            this._previousLastVisibleOffset = $this$lastVisibleOffset.getLineEnd((int)var2_2, true);
            this._previousTextLayoutResult = var1_1;
        }
        return this._previousLastVisibleOffset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void appendSelectableInfoToBuilder(SelectionLayoutBuilder builder) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = builder.getContainerCoordinates().localPositionOf-R5De75A((LayoutCoordinates)var2_2, Offset.Companion.getZero-F1C5BW0());
        long localPosition = Offset.minus-MK-Hz9U((long)builder.getCurrentPosition-F1C5BW0(), (long)relativePosition);
        long localPreviousHandlePosition = OffsetKt.isUnspecified-k-4lQ0M((long)builder.getPreviousHandlePosition-F1C5BW0()) ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U((long)builder.getPreviousHandlePosition-F1C5BW0(), (long)relativePosition);
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A((SelectionLayoutBuilder)var1_1, (TextLayoutResult)var3_3, localPosition, localPreviousHandlePosition, this.getSelectableId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Selection getSelectAllSelection() {
        void var2_2;
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int end = textLayoutResult.getLayoutInput().getText().length();
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(0), 0, this.getSelectableId()), new Selection.AnchorInfo(var1_1.getBidiRunDirection(Math.max(end - 1, 0)), (int)var2_2, this.getSelectableId()), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getHandlePosition-dBAh8RU(Selection selection, boolean isStartHandle) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && selection.getStart().getSelectableId() != this.getSelectableId() || !isStartHandle && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n = isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        int coercedOffset = RangesKt.coerceIn((int)n, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates((TextLayoutResult)var3_3, coercedOffset, (boolean)var2_2, var1_1.getHandlesCrossed());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LayoutCoordinates getLayoutCoordinates() {
        void var1_1;
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return var1_1;
    }

    @Override
    public final TextLayoutResult textLayoutResult() {
        return (TextLayoutResult)this.layoutResultCallback.invoke();
    }

    @Override
    public final AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult.getLayoutInput().getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Rect getBoundingBox(int offset) {
        void var3_3;
        void var1_1;
        void var2_2;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult.getLayoutInput().getText().length();
        if (textLength <= 0) {
            return Rect.Companion.getZero();
        }
        return var2_2.getBoundingBox(RangesKt.coerceIn((int)var1_1, (int)0, (int)(var3_3 - true)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getLineLeft(int offset) {
        void var1_1;
        void var2_2;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return var2_2.getLineLeft((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getLineRight(int offset) {
        void var1_1;
        void var2_2;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return var2_2.getLineRight((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getCenterYForOffset(int offset) {
        void var3_4;
        void var1_1;
        void var2_3;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        float top = textLayoutResult2.getLineTop(line);
        float f = var2_3.getLineBottom((int)var1_1);
        return (f - top) / 2.0f + var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getRangeOfLineContaining--jx7JFs(int offset) {
        void var1_1;
        void var2_2;
        void var3_3;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int visibleTextLength = this.getLastVisibleOffset(textLayoutResult2);
        if (visibleTextLength <= 0) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(var3_3 - true)));
        return TextRangeKt.TextRange((int)textLayoutResult2.getLineStart(line), (int)var2_2.getLineEnd((int)var1_1, true));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLastVisibleOffset() {
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset((TextLayoutResult)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getLineHeight(int offset) {
        void var1_1;
        void var2_2;
        void var3_3;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult.getLayoutInput().getText().length();
        if (textLength <= 0) {
            return 0.0f;
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(var3_3 - true)));
        return var2_2.getMultiParagraph().getLineHeight((int)var1_1);
    }
}

