/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\rH\u0016J\u001c\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020.00H\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0000H\u0002J\u0012\u00106\u001a\u00020\u000b2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\u000bH\u0002J\u0018\u0010:\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u000bH\u0002J\b\u0010<\u001a\u00020=H\u0016J2\u0010>\u001a\u00020.*\b\u0012\u0004\u0012\u00020\r0?2\u0006\u0010,\u001a\u00020\r2\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0002R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019\u00a8\u0006C"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "Landroidx/collection/LongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "currentInfo", "getCurrentInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "getEndSlot", "()I", "firstInfo", "getFirstInfo", "getInfoList", "()Ljava/util/List;", "()Z", "lastInfo", "getLastInfo", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "getSelectableIdToInfoListIndex", "()Landroidx/collection/LongIntMap;", "size", "getSize", "startInfo", "getStartInfo", "getStartSlot", "createSubSelections", "Landroidx/collection/LongObjectMap;", "selection", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "getInfoListIndexBySelectableId", "id", "", "shouldAnyInfoRecomputeSelection", "other", "shouldRecomputeSelection", "slotToIndex", "slot", "isMinimumSlot", "startOrEndSlotToIndex", "isStartSlot", "toString", "", "createAndPutSubSelection", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,733:1\n1#2:734\n69#3,6:735\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n270#1:735,6\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    private final LongIntMap selectableIdToInfoListIndex;
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    private final Selection previousSelection;

    /*
     * WARNING - void declaration
     */
    public MultiSelectionLayout(LongIntMap selectableIdToInfoListIndex, List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, Selection previousSelection) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)selectableIdToInfoListIndex, (String)"selectableIdToInfoListIndex");
        Intrinsics.checkNotNullParameter(infoList, (String)"infoList");
        this.selectableIdToInfoListIndex = string;
        this.infoList = var2_2;
        this.startSlot = var3_3;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        if (!(this.infoList.size() > 1)) {
            string = "MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + '.';
            throw new IllegalStateException(string.toString());
        }
    }

    public final LongIntMap getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public final int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public final int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public final int getSize() {
        return this.infoList.size();
    }

    @Override
    public final CrossStatus getCrossStatus() {
        if (this.getStartSlot() < this.getEndSlot()) {
            return CrossStatus.NOT_CROSSED;
        }
        if (this.getStartSlot() > this.getEndSlot()) {
            return CrossStatus.CROSSED;
        }
        return this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus();
    }

    @Override
    public final SelectableInfo getStartInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getStartSlot(), true));
    }

    @Override
    public final SelectableInfo getEndInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getEndSlot(), false));
    }

    @Override
    public final SelectableInfo getCurrentInfo() {
        if (this.isStartHandle()) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final SelectableInfo getFirstInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getEndInfo();
        }
        return this.getStartInfo();
    }

    @Override
    public final SelectableInfo getLastInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final void forEachMiddleInfo(Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MultiSelectionLayout multiSelectionLayout = this;
        int minIndex = multiSelectionLayout.getInfoListIndexBySelectableId(multiSelectionLayout.getFirstInfo().getSelectableId());
        MultiSelectionLayout multiSelectionLayout2 = this;
        int maxIndex = multiSelectionLayout2.getInfoListIndexBySelectableId(multiSelectionLayout2.getLastInfo().getSelectableId());
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean shouldRecomputeSelection(SelectionLayout other) {
        void var1_1;
        return this.getPreviousSelection() == null || other == null || !(other instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)other).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)other).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)other).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)var1_1);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout other) {
        if (this.getSize() != other.getSize()) {
            return true;
        }
        int n = this.infoList.size();
        for (int i = 0; i < n; ++i) {
            SelectableInfo otherInfo;
            SelectableInfo thisInfo = this.infoList.get(i);
            if (!thisInfo.shouldRecomputeSelection(otherInfo = other.infoList.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LongObjectMap<Selection> createSubSelections(Selection selection) {
        void var1_1;
        void var3_3;
        MutableLongObjectMap mutableLongObjectMap;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            if (!(selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset())) {
                String string = "unexpectedly miss-crossed selection: " + selection;
                throw new IllegalStateException(string.toString());
            }
            return LongObjectMapKt.longObjectMapOf$7a6e42a6((long)selection.getStart().getSelectableId(), (Selection)selection);
        }
        MutableLongObjectMap $this$createSubSelections_u24lambda_u244 = mutableLongObjectMap = LongObjectMapKt.mutableLongObjectMapOf();
        Selection $this$createSubSelections_u24lambda_u244_u24lambda_u242 = selection;
        Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u244_u24lambda_u242.getStart();
        this.createAndPutSubSelection((MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
        this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)new Function1<SelectableInfo, Unit>(this, (MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection){
            final /* synthetic */ MultiSelectionLayout this$0;
            final /* synthetic */ MutableLongObjectMap<Selection> $this_apply;
            final /* synthetic */ Selection $selection;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$this_apply = var2_2;
                this.$selection = var3_3;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(SelectableInfo info) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                MultiSelectionLayout.access$createAndPutSubSelection(this.this$0, this.$this_apply, this.$selection, info, 0, var1_1.getTextLength());
            }
        }));
        Selection $this$createSubSelections_u24lambda_u244_u24lambda_u243 = selection;
        Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u243.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u243.getStart() : $this$createSubSelections_u24lambda_u244_u24lambda_u243.getEnd();
        this.createAndPutSubSelection((MutableLongObjectMap<Selection>)var3_3, (Selection)var1_1, this.getLastInfo(), 0, maxAnchor.getOffset());
        return (LongObjectMap)mutableLongObjectMap;
    }

    /*
     * WARNING - void declaration
     */
    private final void createAndPutSubSelection(MutableLongObjectMap<Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        void var2_2;
        void var3_3;
        void var1_1;
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        if (!(minOffset <= maxOffset)) {
            $this$createAndPutSubSelection = "minOffset should be less than or equal to maxOffset: " + subSelection;
            throw new IllegalStateException($this$createAndPutSubSelection.toString());
        }
        var1_1.put$33cced79(var3_3.getSelectableId(), (Selection)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void $this$toString_u24lambda_u247;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder("MultiSelectionLayout(isStartHandle=").append(this.isStartHandle()).append(", startPosition=").append((float)(this.getStartSlot() + 1) / 2.0f).append(", endPosition=").append((float)(this.getEndSlot() + 1) / 2.0f).append(", crossed=").append((Object)this.getCrossStatus()).append(", infos=");
        $this$toString_u24lambda_u247.append("[\n\t");
        boolean first = true;
        List<SelectableInfo> $this$fastForEachIndexed$iv = this.infoList;
        int n = $this$fastForEachIndexed$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            SelectableInfo item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index2 = index$iv;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u247.append(",\n\t");
            }
            $this$toString_u24lambda_u247.append(index2 + 1 + " -> " + info);
        }
        stringBuilder2.append("\n]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder3.append(string).append(')').toString();
    }

    /*
     * WARNING - void declaration
     */
    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        void var1_1;
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                void var2_2;
                if (var2_2 == false) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex((int)var1_1, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final int slotToIndex(int slot, boolean isMinimumSlot) {
        void var2_2;
        void var1_1;
        boolean slotAdjustment = !isMinimumSlot;
        return (int)((var1_1 - var2_2) / 2);
    }

    /*
     * WARNING - void declaration
     */
    private final int getInfoListIndexBySelectableId(long id) {
        int n;
        try {
            n = this.selectableIdToInfoListIndex.get(id);
        }
        catch (NoSuchElementException e) {
            void var3_3;
            void var1_1;
            throw new IllegalStateException("Invalid selectableId: " + (long)var1_1, (Throwable)var3_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$createAndPutSubSelection(MultiSelectionLayout $this, MutableLongObjectMap $receiver, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.createAndPutSubSelection((MutableLongObjectMap<Selection>)var1_1, (Selection)var2_2, (SelectableInfo)var3_3, minOffset, maxOffset);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

