/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextPointerIcon_skikoKt;
import androidx.compose.foundation.text.modifiers.SelectionController_jvmKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eR\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "selectableId", "", "selectionRegistrar", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "backgroundSelectionColor", "Landroidx/compose/ui/graphics/Color;", "params", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "(JLandroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "draw", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "onAbandoned", "onForgotten", "onRemembered", "updateGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "updateTextLayout", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,359:1\n225#2,8:360\n272#2,14:368\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n161#1:360,8\n161#1:368,14\n*E\n"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    private StaticTextSelectionParams params;
    private Selectable selectable;
    private final Modifier modifier;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"selectionRegistrar");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.selectableId = var1_1;
        this.selectionRegistrar = var3_2;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params;
        this.modifier = PointerIconKt.pointerHoverIcon$default((Modifier)SelectionController_jvmKt.makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        })), (PointerIcon)TextPointerIcon_skikoKt.getTextPointerIcon(), (boolean)false, (int)2, null);
    }

    public /* synthetic */ SelectionController(long l, SelectionRegistrar selectionRegistrar, long l2, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l, selectionRegistrar, l2, staticTextSelectionParams, null);
    }

    public final Modifier getModifier() {
        return this.modifier;
    }

    public final void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }), (Function0<TextLayoutResult>)((Function0)new Function0<TextLayoutResult>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final TextLayoutResult invoke() {
                return SelectionController.access$getParams$p(this.this$0).getTextLayoutResult();
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    public final void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTextLayout(TextLayoutResult textLayoutResult) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        TextLayoutResult prevTextLayoutResult = this.params.getTextLayoutResult();
        if (prevTextLayoutResult != null && !Intrinsics.areEqual((Object)var2_2.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, (TextLayoutResult)var1_1, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateGlobalPosition(LayoutCoordinates coordinates) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.params = StaticTextSelectionParams.copy$default(this.params, (LayoutCoordinates)var1_1, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(DrawScope drawScope) {
        void var1_1;
        int end;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start = !selection.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start == end) {
            return;
        }
        Selectable selectable2 = this.selectable;
        int lastOffset = selectable2 != null ? selectable2.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path == null) {
            return;
        }
        Path selectionPath = path;
        if (this.params.getShouldClip()) {
            void $this$draw_u24lambda_u241;
            void $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u241;
            float right$iv = Size.getWidth-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            float bottom$iv = Size.getHeight-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            void $this$withTransform$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            try {
                void var3_7;
                DrawTransform drawTransform = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
                drawTransform.clipRect-N_I0leg(0.0f, 0.0f, (float)var3_7, bottom$iv, clipOp$iv);
                DrawScope.drawPath-LG529CI$default((DrawScope)var1_1, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            }
            finally {
                $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
                $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            }
        } else {
            void var2_5;
            DrawScope.drawPath-LG529CI$default((DrawScope)var1_1, (Path)var2_5, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params, DefaultConstructorMarker $constructor_marker) {
        this((long)var1_1, (SelectionRegistrar)var3_2, backgroundSelectionColor, params);
        void var3_2;
        void var1_1;
    }

    public static final /* synthetic */ StaticTextSelectionParams access$getParams$p(SelectionController $this) {
        return $this.params;
    }
}

