/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.undo;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB/\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "", "initialUndoStack", "", "initialRedoStack", "capacity", "", "(Ljava/util/List;Ljava/util/List;I)V", "canRedo", "", "getCanRedo$foundation", "()Z", "canUndo", "getCanUndo$foundation", "redoStack", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "size", "getSize", "()I", "undoStack", "clearHistory", "", "record", "undoableAction", "(Ljava/lang/Object;)V", "redo", "()Ljava/lang/Object;", "undo", "Companion", "foundation"})
@StabilityInferred(parameters=0)
public final class UndoManager<T> {
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    private SnapshotStateList<T> undoStack;
    private SnapshotStateList<T> redoStack;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public UndoManager(List<? extends T> initialUndoStack, List<? extends T> initialRedoStack, int capacity) {
        void var2_2;
        void $this$redoStack_u24lambda_u241;
        void var1_1;
        SnapshotStateList $this$undoStack_u24lambda_u240;
        void var3_3;
        Intrinsics.checkNotNullParameter(initialUndoStack, (String)"initialUndoStack");
        Intrinsics.checkNotNullParameter(initialRedoStack, (String)"initialRedoStack");
        this.capacity = var3_3;
        SnapshotStateList snapshotStateList = new SnapshotStateList();
        Object object = snapshotStateList;
        UndoManager undoManager = this;
        $this$undoStack_u24lambda_u240.addAll((Collection)var1_1);
        undoManager.undoStack = snapshotStateList;
        $this$undoStack_u24lambda_u240 = snapshotStateList = new SnapshotStateList();
        undoManager = this;
        $this$redoStack_u24lambda_u241.addAll((Collection)var2_2);
        undoManager.redoStack = snapshotStateList;
        if (!(this.capacity >= 0)) {
            object = "Capacity must be a positive integer";
            throw new IllegalArgumentException(object.toString());
        }
        if (!(this.getSize() <= this.capacity)) {
            object = "Initial list of undo and redo operations have a size=(" + this.getSize() + ") greater than the given capacity=(" + this.capacity + ").";
            throw new IllegalArgumentException(object.toString());
        }
    }

    public /* synthetic */ UndoManager(List list, List list2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(list, list2, n);
    }

    public final boolean getCanUndo$foundation() {
        return !((Collection)this.undoStack).isEmpty();
    }

    public final boolean getCanRedo$foundation() {
        return !((Collection)this.redoStack).isEmpty();
    }

    public final int getSize() {
        return this.undoStack.size() + this.redoStack.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void record(T undoableAction) {
        void var1_1;
        this.redoStack.clear();
        while (this.getSize() > this.capacity - 1) {
            CollectionsKt.removeFirst((List)((List)this.undoStack));
        }
        this.undoStack.add((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final T undo() {
        void var1_2;
        if (!this.getCanUndo$foundation()) {
            String string = "It's an error to call undo while there is nothing to undo. Please first check `canUndo` value before calling the `undo` function.";
            throw new IllegalStateException(string.toString());
        }
        Object topOperation = CollectionsKt.removeLast((List)((List)this.undoStack));
        this.redoStack.add(topOperation);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final T redo() {
        void var1_2;
        if (!this.getCanRedo$foundation()) {
            String string = "It's an error to call redo while there is nothing to redo. Please first check `canRedo` value before calling the `redo` function.";
            throw new IllegalStateException(string.toString());
        }
        Object topOperation = CollectionsKt.removeLast((List)((List)this.redoStack));
        this.undoStack.add(topOperation);
        return var1_2;
    }

    public final void clearHistory() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public UndoManager() {
        this(null, null, 0, 7, null);
    }

    public static final /* synthetic */ int access$getCapacity$p(UndoManager $this) {
        return $this.capacity;
    }

    public static final /* synthetic */ SnapshotStateList access$getUndoStack$p(UndoManager $this) {
        return $this.undoStack;
    }

    public static final /* synthetic */ SnapshotStateList access$getRedoStack$p(UndoManager $this) {
        return $this.redoStack;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0005\u0012\u0004\u0012\u00020\u00010\u0004\"\u0006\b\u0001\u0010\u0006\u0018\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0086\b\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager$Companion;", "", "()V", "createSaver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "itemSaver", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> Saver<UndoManager<T>, Object> createSaver(Saver<T, Object> itemSaver) {
            void var1_1;
            Intrinsics.checkNotNullParameter(itemSaver, (String)"itemSaver");
            Intrinsics.needClassReification();
            return new Saver<UndoManager<T>, Object>(var1_1){
                final /* synthetic */ Saver<T, Object> $itemSaver;
                {
                    void var1_1;
                    this.$itemSaver = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object save(SaverScope $this$save, UndoManager<T> value) {
                    void var2_2;
                    E it;
                    int index$iv;
                    List list;
                    Intrinsics.checkNotNullParameter((Object)$this$save, (String)"<this>");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Saver<T, Object> saver2 = this.$itemSaver;
                    List $this$save_u24lambda_u244 = list = CollectionsKt.createListBuilder();
                    list.add(UndoManager.access$getCapacity$p(value));
                    $this$save_u24lambda_u244.add(UndoManager.access$getUndoStack$p(value).size());
                    $this$save_u24lambda_u244.add(UndoManager.access$getRedoStack$p(value).size());
                    List $this$fastForEach$iv = (List)UndoManager.access$getUndoStack$p(value);
                    int n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        E e;
                        it = e = $this$fastForEach$iv.get(index$iv);
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240 = saver2;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240.save($this$save, it));
                    }
                    $this$fastForEach$iv = (List)UndoManager.access$getRedoStack$p((UndoManager)var2_2);
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = $this$fastForEach$iv.get(index$iv);
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242 = saver2;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242.save($this$save, it));
                    }
                    return CollectionsKt.build((List)list);
                }

                /*
                 * WARNING - void declaration
                 */
                public final UndoManager<T> restore(Object value) {
                    void var3_4;
                    List list;
                    int i;
                    Saver<T, Object> saver2;
                    List list2;
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    List list3 = list2 = (List)value;
                    int capacity = ((Number)list2.get(0)).intValue();
                    int undoSize = ((Number)list3.get(1)).intValue();
                    int redoSize = ((Number)list3.get(2)).intValue();
                    Saver<T, Object> saver3 = this.$itemSaver;
                    Saver<T, Object> $this$restore_u24lambda_u245 = saver2 = CollectionsKt.createListBuilder();
                    for (i = 3; i < undoSize + 3; ++i) {
                        Object object = saver3.restore(list2.get(i));
                        Intrinsics.checkNotNull((Object)object);
                        $this$restore_u24lambda_u245.add(object);
                    }
                    List undoStackItems = CollectionsKt.build((List)saver2);
                    saver2 = this.$itemSaver;
                    List $this$restore_u24lambda_u246 = list = CollectionsKt.createListBuilder();
                    while (i < undoSize + redoSize + 3) {
                        Object object = saver2.restore(list2.get(i));
                        Intrinsics.checkNotNull((Object)object);
                        $this$restore_u24lambda_u246.add(object);
                        ++i;
                    }
                    List redoStackItems = CollectionsKt.build((List)list);
                    return new UndoManager<T>(undoStackItems, redoStackItems, (int)var3_4);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

