/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.selection;

import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.input.internal.TextLayoutState;
import androidx.compose.foundation.text.input.internal.TextLayoutStateKt;
import androidx.compose.foundation.text.input.internal.TransformedTextFieldState;
import androidx.compose.foundation.text.input.internal.selection.TextFieldSelectionState;
import androidx.compose.foundation.text.selection.SelectionManagerKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\f"}, d2={"calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "textFieldState", "Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;", "selectionState", "Landroidx/compose/foundation/text/input/internal/selection/TextFieldSelectionState;", "textLayoutState", "Landroidx/compose/foundation/text/input/internal/TextLayoutState;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-hUlJWOE", "(Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;Landroidx/compose/foundation/text/input/internal/selection/TextFieldSelectionState;Landroidx/compose/foundation/text/input/internal/TextLayoutState;J)J", "foundation"})
@SourceDebugExtension(value={"SMAP\nTextFieldMagnifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldMagnifier.kt\nandroidx/compose/foundation/text/input/internal/selection/TextFieldMagnifierKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class TextFieldMagnifierKt {
    /*
     * WARNING - void declaration
     */
    public static final long calculateSelectionMagnifierCenterAndroid-hUlJWOE(TransformedTextFieldState textFieldState, TextFieldSelectionState selectionState, TextLayoutState textLayoutState, long magnifierSize) {
        void var2_5;
        long offset;
        block9: {
            void var0_2;
            void var3_7;
            int n;
            Intrinsics.checkNotNullParameter((Object)textFieldState, (String)"textFieldState");
            Intrinsics.checkNotNullParameter((Object)selectionState, (String)"selectionState");
            Intrinsics.checkNotNullParameter((Object)textLayoutState, (String)"textLayoutState");
            long localDragPosition = selectionState.getHandleDragPosition-F1C5BW0();
            if (OffsetKt.isUnspecified-k-4lQ0M((long)localDragPosition) || ((CharSequence)textFieldState.getVisualText()).length() == 0) {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            long selection = textFieldState.getVisualText().getSelection-d9O1mEE();
            Handle handle = selectionState.getDraggingHandle();
            switch (handle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle.ordinal()]) {
                case -1: {
                    return Offset.Companion.getUnspecified-F1C5BW0();
                }
                case 1: 
                case 2: {
                    n = TextRange.getStart-impl((long)selection);
                    break;
                }
                case 3: {
                    n = TextRange.getEnd-impl((long)selection);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int textOffset = n;
            TextLayoutResult textLayoutResult = textLayoutState.getLayoutResult();
            if (textLayoutResult == null) {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            TextLayoutResult layoutResult2 = textLayoutResult;
            float dragX = Offset.getX-impl((long)localDragPosition);
            int line22 = layoutResult2.getLineForOffset(textOffset);
            float lineStart = layoutResult2.getLineLeft(line22);
            float lineEnd = layoutResult2.getLineRight(line22);
            float lineMin = Math.min(lineStart, lineEnd);
            float lineMax = Math.max(lineStart, lineEnd);
            float centerX = RangesKt.coerceIn((float)dragX, (float)lineMin, (float)lineMax);
            if (!IntSize.equals-impl0((long)magnifierSize, (long)IntSize.Companion.getZero-YbymL2g()) && Math.abs(dragX - centerX) > (float)(IntSize.getWidth-impl((long)magnifierSize) / 2)) {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            float top = layoutResult2.getLineTop(line22);
            float line22 = layoutResult2.getLineBottom(line22);
            float centerY = (line22 - top) / 2.0f + var3_7;
            offset = OffsetKt.Offset((float)centerX, (float)var0_2);
            LayoutCoordinates layoutCoordinates = textLayoutState.getTextLayoutNodeCoordinates();
            if (layoutCoordinates == null) break block9;
            LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
            layoutResult2 = layoutCoordinates;
            if ((layoutCoordinates = layoutCoordinates.isAttached() ? layoutCoordinates2 : null) != null) {
                void var1_4;
                LayoutCoordinates innerCoordinates = layoutCoordinates;
                offset = TextLayoutStateKt.coerceIn-3MmeM6k(offset, SelectionManagerKt.visibleBounds((LayoutCoordinates)var1_4));
            }
        }
        return TextLayoutStateKt.fromTextLayoutToCore-Uv8p0NA((TextLayoutState)var2_5, offset);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.Cursor.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Handle.SelectionStart.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

