/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.input.internal.ToCharArray_skikoKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J2\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/text/input/internal/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "([CII)V", "buffer", "capacity", "gapEnd", "gapStart", "append", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "delete", "start", "end", "gapLength", "get", "", "index", "length", "makeSureAvailableSpace", "requestSize", "replace", "text", "", "textStart", "textEnd", "toString", "", "foundation"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/foundation/text/input/internal/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    /*
     * WARNING - void declaration
     */
    public GapBuffer(char[] initBuffer, int initGapStart, int initGapEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = var1_1;
        this.gapStart = var2_2;
        this.gapEnd = var3_3;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index2) {
        void var1_1;
        if (index2 < this.gapStart) {
            return this.buffer[index2];
        }
        return this.buffer[var1_1 - this.gapStart + this.gapEnd];
    }

    /*
     * WARNING - void declaration
     */
    private final void makeSureAvailableSpace(int requestSize) {
        void var2_3;
        void var1_2;
        void var3_4;
        if (requestSize <= this.gapLength()) {
            return;
        }
        int necessarySpace = requestSize - this.gapLength();
        int newCapacity = this.capacity << 1;
        while (newCapacity - this.capacity < necessarySpace) {
            newCapacity <<= 1;
        }
        char[] newBuffer = new char[newCapacity];
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)0, (int)0, (int)this.gapStart);
        int tailLength = this.capacity - this.gapEnd;
        int newEnd = newCapacity - tailLength;
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)newEnd, (int)this.gapEnd, (int)(this.gapEnd + var3_4));
        this.buffer = var1_2;
        this.capacity = var2_3;
        this.gapEnd = newEnd;
    }

    /*
     * WARNING - void declaration
     */
    private final void delete(int start, int end) {
        void var1_1;
        void var2_2;
        void var3_4;
        if (start < this.gapStart && end <= this.gapStart) {
            int copyLen = this.gapStart - end;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - copyLen), (int)end, (int)this.gapStart);
            this.gapStart = start;
            this.gapEnd -= copyLen;
            return;
        }
        if (start < this.gapStart && end >= this.gapStart) {
            this.gapEnd = end + this.gapLength();
            this.gapStart = start;
            return;
        }
        int startInBuffer = start + this.gapLength();
        int endInBuffer = end + this.gapLength();
        int copyLen = startInBuffer - this.gapEnd;
        ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)var3_4);
        this.gapStart += var2_2;
        this.gapEnd = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, CharSequence text, int textStart, int textEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int textLength = textEnd - textStart;
        this.makeSureAvailableSpace(textLength - (end - start));
        this.delete((int)var1_1, (int)var2_2);
        ToCharArray_skikoKt.toCharArray((CharSequence)var3_3, this.buffer, this.gapStart, textStart, textEnd);
        this.gapStart += textLength;
    }

    public static /* synthetic */ void replace$default(GapBuffer gapBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        gapBuffer.replace(n, n2, charSequence, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    public final void append(StringBuilder builder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        StringBuilder stringBuilder = builder;
        char[] cArray = this.buffer;
        int n = this.gapStart;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, 0, n), (String)"append(...)");
        stringBuilder = var1_1;
        cArray = this.buffer;
        int n2 = this.gapEnd;
        n = this.capacity;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, n2, n - n2), (String)"append(...)");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)var2_2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

