/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.input.TextHighlightType;
import androidx.compose.foundation.text.input.internal.ChangeTracker;
import androidx.compose.foundation.text.input.internal.EditingBufferKt;
import androidx.compose.foundation.text.input.internal.PartialGapBuffer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\t\b\u0000\u0018\u0000 D2\u00020\u0001:\u0001DB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002J\u0006\u00103\u001a\u000200J\u0006\u00104\u001a\u000200J\u0016\u00105\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011J\u0011\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0011H\u0086\u0002J\u0006\u00109\u001a\u00020:J\u001e\u0010;\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020<J\u0016\u0010=\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011J(\u0010\"\u001a\u0002002\u0006\u0010>\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J\u0016\u0010A\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011J\u0006\u0010B\u001a\u00020\u0007J\b\u0010C\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u0004\u0018\u00010\u00058F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u0017\u0010\u0004\u001a\u00020\u00058F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R$\u0010)\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u001aR$\u0010,\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010\u001a\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006E"}, d2={"Landroidx/compose/foundation/text/input/internal/EditingBuffer;", "", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "changeTracker", "Landroidx/compose/foundation/text/input/internal/ChangeTracker;", "getChangeTracker", "()Landroidx/compose/foundation/text/input/internal/ChangeTracker;", "composition", "getComposition-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "<set-?>", "", "compositionEnd", "getCompositionEnd", "()I", "compositionStart", "getCompositionStart", "cursor", "getCursor", "setCursor", "(I)V", "gapBuffer", "Landroidx/compose/foundation/text/input/internal/PartialGapBuffer;", "highlight", "Lkotlin/Pair;", "Landroidx/compose/foundation/text/input/TextHighlightType;", "getHighlight", "()Lkotlin/Pair;", "setHighlight", "(Lkotlin/Pair;)V", "length", "getLength", "getSelection-d9O1mEE", "()J", "value", "selectionEnd", "getSelectionEnd", "setSelectionEnd", "selectionStart", "getSelectionStart", "setSelectionStart", "checkRange", "", "start", "end", "clearHighlight", "commitComposition", "delete", "get", "", "index", "hasComposition", "", "replace", "", "setComposition", "type", "setHighlight-K7f2yys", "(III)V", "setSelection", "toAnnotatedString", "toString", "Companion", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/foundation/text/input/internal/EditingBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1#2:424\n*E\n"})
public final class EditingBuffer {
    public static final Companion Companion = new Companion(null);
    private final PartialGapBuffer gapBuffer;
    private final ChangeTracker changeTracker;
    private int selectionStart;
    private int selectionEnd;
    private Pair<TextHighlightType, TextRange> highlight;
    private int compositionStart;
    private int compositionEnd;
    public static final int $stable = 8;
    public static final int NOWHERE = -1;

    /*
     * WARNING - void declaration
     */
    private EditingBuffer(AnnotatedString text, long selection) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.gapBuffer = new PartialGapBuffer(var1_1.getText());
        this.changeTracker = new ChangeTracker(null, 1, null);
        this.selectionStart = TextRange.getStart-impl((long)selection);
        this.selectionEnd = TextRange.getEnd-impl((long)selection);
        this.compositionStart = -1;
        this.compositionEnd = -1;
        this.checkRange(TextRange.getStart-impl((long)selection), TextRange.getEnd-impl((long)var2_2));
    }

    public final ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    /*
     * WARNING - void declaration
     */
    private final void setSelectionStart(int value2) {
        void var1_1;
        if (!(value2 >= 0)) {
            String value2 = "Cannot set selectionStart to a negative value: " + value2;
            throw new IllegalArgumentException(value2.toString());
        }
        this.selectionStart = var1_1;
        this.highlight = null;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    /*
     * WARNING - void declaration
     */
    private final void setSelectionEnd(int value2) {
        void var1_1;
        if (!(value2 >= 0)) {
            String value2 = "Cannot set selectionEnd to a negative value: " + value2;
            throw new IllegalArgumentException(value2.toString());
        }
        this.selectionEnd = var1_1;
        this.highlight = null;
    }

    public final Pair<TextHighlightType, TextRange> getHighlight() {
        return this.highlight;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHighlight(Pair<TextHighlightType, TextRange> pair) {
        void var1_1;
        this.highlight = var1_1;
    }

    public final int getCompositionStart() {
        return this.compositionStart;
    }

    public final int getCompositionEnd() {
        return this.compositionEnd;
    }

    public final boolean hasComposition() {
        return this.compositionStart != -1;
    }

    public final TextRange getComposition-MzsxiRA() {
        if (this.hasComposition()) {
            return TextRange.box-impl((long)TextRangeKt.TextRange((int)this.compositionStart, (int)this.compositionEnd));
        }
        return null;
    }

    public final long getSelection-d9O1mEE() {
        return TextRangeKt.TextRange((int)this.selectionStart, (int)this.selectionEnd);
    }

    public final int getCursor() {
        if (this.selectionStart == this.selectionEnd) {
            return this.selectionEnd;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCursor(int cursor2) {
        void var1_1;
        void v0 = var1_1;
        this.setSelection((int)v0, (int)v0);
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index2) {
        void var1_1;
        return this.gapBuffer.charAt((int)var1_1);
    }

    public final int getLength() {
        return this.gapBuffer.length();
    }

    /*
     * WARNING - void declaration
     */
    private EditingBuffer(String text, long selection) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new AnnotatedString((String)var1_1, null, null, 6, null), (long)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, CharSequence text) {
        void var3_3;
        void var1_1;
        void var2_2;
        int cMax;
        int cMin;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkRange(start, end);
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        int i = 0;
        for (cMin = min; cMin < max && i < text.length() && text.charAt(i) == this.gapBuffer.charAt(cMin); ++i, ++cMin) {
        }
        int j = text.length();
        for (cMax = max; cMax > min && j > i && text.charAt(j - 1) == this.gapBuffer.charAt(cMax - 1); --j, --cMax) {
        }
        this.changeTracker.trackChange(cMin, cMax, j - var2_2);
        PartialGapBuffer.replace$default(this.gapBuffer, min, (int)var1_1, text, 0, 0, 24, null);
        this.setSelectionStart(min + text.length());
        this.setSelectionEnd(min + var3_3.length());
        this.compositionStart = -1;
        this.compositionEnd = -1;
        this.highlight = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(int start, int end) {
        void var2_2;
        void var1_1;
        this.checkRange(start, end);
        long deleteRange = TextRangeKt.TextRange((int)start, (int)end);
        this.changeTracker.trackChange((int)var1_1, (int)var2_2, 0);
        PartialGapBuffer.replace$default(this.gapBuffer, TextRange.getMin-impl((long)deleteRange), TextRange.getMax-impl((long)deleteRange), "", 0, 0, 24, null);
        long newSelection = EditingBufferKt.updateRangeAfterDelete-pWDy79M(TextRangeKt.TextRange((int)this.selectionStart, (int)this.selectionEnd), deleteRange);
        this.setSelectionStart(TextRange.getStart-impl((long)newSelection));
        this.setSelectionEnd(TextRange.getEnd-impl((long)newSelection));
        if (this.hasComposition()) {
            void var3_3;
            long l = TextRangeKt.TextRange((int)this.compositionStart, (int)this.compositionEnd);
            long newComposition = EditingBufferKt.updateRangeAfterDelete-pWDy79M(l, (long)var3_3);
            if (TextRange.getCollapsed-impl((long)newComposition)) {
                this.commitComposition();
            } else {
                this.compositionStart = TextRange.getMin-impl((long)newComposition);
                this.compositionEnd = TextRange.getMax-impl((long)newComposition);
            }
        }
        this.highlight = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSelection(int start, int end) {
        void var2_2;
        void var1_1;
        int clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)this.getLength());
        int clampedEnd = RangesKt.coerceIn((int)end, (int)0, (int)this.getLength());
        this.setSelectionStart((int)var1_1);
        this.setSelectionEnd((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setHighlight-K7f2yys(int type2, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (start >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        int clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)this.getLength());
        int clampedEnd = RangesKt.coerceIn((int)end, (int)0, (int)this.getLength());
        this.highlight = new Pair((Object)TextHighlightType.box-impl((int)var1_1), (Object)TextRange.box-impl((long)TextRangeKt.TextRange((int)var2_2, (int)var3_3)));
    }

    public final void clearHighlight() {
        this.highlight = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setComposition(int start, int end) {
        void var2_2;
        void var1_1;
        if (start < 0 || start > this.gapBuffer.length()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.length());
        }
        if (end < 0 || end > this.gapBuffer.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.length());
        }
        if (start >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        this.compositionStart = var1_1;
        this.compositionEnd = var2_2;
    }

    public final void commitComposition() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final String toString() {
        return this.gapBuffer.toString();
    }

    public final AnnotatedString toAnnotatedString() {
        return new AnnotatedString(this.toString(), null, null, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRange(int start, int end) {
        if (start < 0 || start > this.gapBuffer.length()) {
            void var1_1;
            throw new IndexOutOfBoundsException("start (" + (int)var1_1 + ") offset is outside of text region " + this.gapBuffer.length());
        }
        if (end < 0 || end > this.gapBuffer.length()) {
            void var2_2;
            throw new IndexOutOfBoundsException("end (" + (int)var2_2 + ") offset is outside of text region " + this.gapBuffer.length());
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ EditingBuffer(AnnotatedString text, long selection, DefaultConstructorMarker $constructor_marker) {
        this((AnnotatedString)var1_1, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ EditingBuffer(String text, long selection, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/compose/foundation/text/input/internal/EditingBuffer$Companion;", "", "()V", "NOWHERE", "", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

