/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.input.internal.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0015\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0018\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\u0019"}, d2={"isSurrogatePair", "", "high", "", "low", "backspace", "", "Landroidx/compose/foundation/text/input/internal/EditingBuffer;", "commitText", "text", "", "newCursorPosition", "", "deleteAll", "deleteSurroundingText", "lengthBeforeCursor", "lengthAfterCursor", "deleteSurroundingTextInCodePoints", "finishComposingText", "moveCursor", "amount", "setComposingRegion", "start", "end", "setComposingText", "foundation"})
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n+ 2 MathUtils.kt\nandroidx/compose/foundation/text/input/internal/MathUtilsKt\n*L\n1#1,304:1\n27#2,3:305\n36#2,4:308\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n*L\n156#1:305,3\n161#1:308,4\n*E\n"})
public final class EditCommandKt {
    /*
     * WARNING - void declaration
     */
    public static final void commitText(EditingBuffer $this$commitText, String text, int newCursorPosition) {
        EditingBuffer editingBuffer;
        void var1_2;
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)$this$commitText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if ($this$commitText.hasComposition()) {
            EditingBuffer editingBuffer2 = $this$commitText;
            editingBuffer2.replace(editingBuffer2.getCompositionStart(), $this$commitText.getCompositionEnd(), text);
        } else {
            EditingBuffer editingBuffer3 = $this$commitText;
            editingBuffer3.replace(editingBuffer3.getSelectionStart(), $this$commitText.getSelectionEnd(), text);
        }
        int newCursor = $this$commitText.getCursor();
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : var3_4 + var2_3 - text.length();
        $this$commitText.setCursor(RangesKt.coerceIn((int)var1_2, (int)0, (int)editingBuffer.getLength()));
    }

    /*
     * WARNING - void declaration
     */
    public static final void setComposingRegion(EditingBuffer $this$setComposingRegion, int start, int end) {
        int clampedEnd;
        int clampedStart;
        Intrinsics.checkNotNullParameter((Object)$this$setComposingRegion, (String)"<this>");
        if ($this$setComposingRegion.hasComposition()) {
            $this$setComposingRegion.commitComposition();
        }
        if ((clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)$this$setComposingRegion.getLength())) != (clampedEnd = RangesKt.coerceIn((int)end, (int)0, (int)$this$setComposingRegion.getLength()))) {
            void var1_1;
            void var2_2;
            EditingBuffer editingBuffer;
            if (clampedStart < clampedEnd) {
                $this$setComposingRegion.setComposition(clampedStart, clampedEnd);
                return;
            }
            editingBuffer.setComposition((int)var2_2, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void setComposingText(EditingBuffer $this$setComposingText, String text, int newCursorPosition) {
        EditingBuffer editingBuffer;
        void var1_2;
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)$this$setComposingText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if ($this$setComposingText.hasComposition()) {
            int compositionStart = $this$setComposingText.getCompositionStart();
            $this$setComposingText.replace(compositionStart, $this$setComposingText.getCompositionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                int n = compositionStart;
                $this$setComposingText.setComposition(n, n + text.length());
            }
        } else {
            int selectionStart = $this$setComposingText.getSelectionStart();
            $this$setComposingText.replace(selectionStart, $this$setComposingText.getSelectionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                int n = selectionStart;
                $this$setComposingText.setComposition(n, n + text.length());
            }
        }
        int newCursor = $this$setComposingText.getCursor();
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : var3_4 + var2_3 - text.length();
        $this$setComposingText.setCursor(RangesKt.coerceIn((int)var1_2, (int)0, (int)editingBuffer.getLength()));
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteSurroundingText(EditingBuffer $this$deleteSurroundingText, int lengthBeforeCursor, int lengthAfterCursor) {
        EditingBuffer editingBuffer;
        void var3_4;
        boolean start;
        void var2_2;
        void var1_1;
        int result$iv;
        Intrinsics.checkNotNullParameter((Object)$this$deleteSurroundingText, (String)"<this>");
        if (!(lengthBeforeCursor >= 0 && lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
        int $this$addExactOrElse$iv = $this$deleteSurroundingText.getSelectionEnd();
        int end = (($this$addExactOrElse$iv ^ (result$iv = $this$addExactOrElse$iv + lengthAfterCursor)) & (lengthAfterCursor ^ result$iv)) < 0 ? $this$deleteSurroundingText.getLength() : result$iv;
        EditingBuffer editingBuffer2 = $this$deleteSurroundingText;
        editingBuffer2.delete(editingBuffer2.getSelectionEnd(), Math.min(end, $this$deleteSurroundingText.getLength()));
        int $this$subtractExactOrElse$iv = $this$deleteSurroundingText.getSelectionStart();
        int result$iv2 = $this$subtractExactOrElse$iv - lengthBeforeCursor;
        start = (($this$subtractExactOrElse$iv ^ var1_1) & (var2_2 ^ result$iv2)) < 0 ? false : start;
        $this$deleteSurroundingText.delete(Math.max(0, (int)var3_4), editingBuffer.getSelectionStart());
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteSurroundingTextInCodePoints(EditingBuffer $this$deleteSurroundingTextInCodePoints, int lengthBeforeCursor, int lengthAfterCursor) {
        EditingBuffer editingBuffer;
        void var3_5;
        Intrinsics.checkNotNullParameter((Object)$this$deleteSurroundingTextInCodePoints, (String)"<this>");
        if (!(lengthBeforeCursor >= 0 && lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
        int beforeLenInChars = 0;
        for (int i = 0; i < lengthBeforeCursor; ++i) {
            if ($this$deleteSurroundingTextInCodePoints.getSelectionStart() > ++beforeLenInChars) {
                EditingBuffer editingBuffer2 = $this$deleteSurroundingTextInCodePoints;
                char lead = editingBuffer2.get(editingBuffer2.getSelectionStart() - beforeLenInChars - 1);
                EditingBuffer editingBuffer3 = $this$deleteSurroundingTextInCodePoints;
                char trail = editingBuffer3.get(editingBuffer3.getSelectionStart() - beforeLenInChars);
                if (!EditCommandKt.isSurrogatePair(lead, trail)) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = $this$deleteSurroundingTextInCodePoints.getSelectionStart();
            break;
        }
        int afterLenInChars = 0;
        for (int i = 0; i < lengthAfterCursor; ++i) {
            if ($this$deleteSurroundingTextInCodePoints.getSelectionEnd() + ++afterLenInChars < $this$deleteSurroundingTextInCodePoints.getLength()) {
                void var1_1;
                EditingBuffer editingBuffer4 = $this$deleteSurroundingTextInCodePoints;
                char lead = editingBuffer4.get(editingBuffer4.getSelectionEnd() + afterLenInChars - 1);
                EditingBuffer editingBuffer5 = $this$deleteSurroundingTextInCodePoints;
                char trail = editingBuffer5.get(editingBuffer5.getSelectionEnd() + afterLenInChars);
                if (!EditCommandKt.isSurrogatePair(lead, (char)var1_1)) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = $this$deleteSurroundingTextInCodePoints.getLength() - $this$deleteSurroundingTextInCodePoints.getSelectionEnd();
            break;
        }
        EditingBuffer editingBuffer6 = $this$deleteSurroundingTextInCodePoints;
        editingBuffer6.delete(editingBuffer6.getSelectionEnd(), $this$deleteSurroundingTextInCodePoints.getSelectionEnd() + afterLenInChars);
        EditingBuffer editingBuffer7 = $this$deleteSurroundingTextInCodePoints;
        editingBuffer7.delete(editingBuffer7.getSelectionStart() - var3_5, editingBuffer.getSelectionStart());
    }

    public static final void finishComposingText(EditingBuffer $this$finishComposingText) {
        EditingBuffer editingBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$finishComposingText, (String)"<this>");
        editingBuffer.commitComposition();
    }

    /*
     * WARNING - void declaration
     */
    public static final void backspace(EditingBuffer $this$backspace) {
        Intrinsics.checkNotNullParameter((Object)$this$backspace, (String)"<this>");
        if ($this$backspace.hasComposition()) {
            EditingBuffer editingBuffer = $this$backspace;
            editingBuffer.delete(editingBuffer.getCompositionStart(), $this$backspace.getCompositionEnd());
            return;
        }
        if ($this$backspace.getCursor() == -1) {
            void var2_3;
            int delStart = $this$backspace.getSelectionStart();
            int delEnd = $this$backspace.getSelectionEnd();
            EditingBuffer editingBuffer = $this$backspace;
            editingBuffer.setCursor(editingBuffer.getSelectionStart());
            $this$backspace.delete(delStart, (int)var2_3);
            return;
        }
        if ($this$backspace.getCursor() != 0) {
            EditingBuffer editingBuffer;
            void var1_2;
            int prevCursorPos = StringHelpers_skikoKt.findPrecedingBreak($this$backspace.toString(), $this$backspace.getCursor());
            $this$backspace.delete((int)var1_2, editingBuffer.getCursor());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void moveCursor(EditingBuffer $this$moveCursor, int amount) {
        void var2_2;
        EditingBuffer editingBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$moveCursor, (String)"<this>");
        if ($this$moveCursor.getCursor() == -1) {
            EditingBuffer editingBuffer2 = $this$moveCursor;
            editingBuffer2.setCursor(editingBuffer2.getSelectionStart());
        }
        int newCursor = $this$moveCursor.getSelectionStart();
        String bufferText = $this$moveCursor.toString();
        if (amount > 0) {
            int next;
            for (int i = 0; i < amount && (next = StringHelpers_skikoKt.findFollowingBreak(bufferText, newCursor)) != -1; ++i) {
                newCursor = next;
            }
        } else {
            int prev;
            int n = -amount;
            for (int i = 0; i < n && (prev = StringHelpers_skikoKt.findPrecedingBreak(bufferText, newCursor)) != -1; ++i) {
                void var1_1;
                newCursor = var1_1;
            }
        }
        editingBuffer.setCursor((int)var2_2);
    }

    public static final void deleteAll(EditingBuffer $this$deleteAll) {
        EditingBuffer editingBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$deleteAll, (String)"<this>");
        $this$deleteAll.replace(0, editingBuffer.getLength(), "");
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isSurrogatePair(char high, char low) {
        void var1_1;
        return Character.isHighSurrogate(high) && Character.isLowSurrogate((char)var1_1);
    }
}

