/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u0016\u0010&\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0005J\u0018\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0005H\u0002J\u000e\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-R+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "currentPage", "", "currentPageOffsetFraction", "", "state", "Landroidx/compose/foundation/pager/PagerState;", "(IFLandroidx/compose/foundation/pager/PagerState;)V", "<set-?>", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "getCurrentPageOffsetFraction", "()F", "setCurrentPageOffsetFraction", "(F)V", "currentPageOffsetFraction$delegate", "Landroidx/compose/runtime/MutableFloatState;", "hadFirstNotEmptyLayout", "", "lastKnownCurrentPageKey", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "applyScrollDelta", "", "delta", "matchPageWithKey", "itemProvider", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "index", "requestPositionAndForgetLastKnownKey", "offsetFraction", "update", "page", "updateCurrentPageOffsetFraction", "updateFromMeasureResult", "measureResult", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPositionKt\n*L\n1#1,152:1\n78#2:153\n111#2,2:154\n79#3:156\n112#3,2:157\n142#4,4:159\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n44#1:153\n44#1:154,2\n47#1:156\n47#1:157,2\n120#1:159,4\n*E\n"})
public final class PagerScrollPosition {
    private final PagerState state;
    private final MutableIntState currentPage$delegate;
    private final MutableFloatState currentPageOffsetFraction$delegate;
    private boolean hadFirstNotEmptyLayout;
    private Object lastKnownCurrentPageKey;
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PagerScrollPosition(int currentPage, float currentPageOffsetFraction, PagerState state) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = var3_3;
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)currentPage);
        this.currentPageOffsetFraction$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)var2_2);
        this.nearestRangeState = new LazyLayoutNearestRangeState((int)var1_1, 30, 100);
    }

    public /* synthetic */ PagerScrollPosition(int n, float f, PagerState pagerState, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        this(n, f, pagerState);
    }

    public final PagerState getState() {
        return this.state;
    }

    public final int getCurrentPage() {
        IntState intState = (IntState)this.currentPage$delegate;
        return intState.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPage(int n) {
        void var1_1;
        MutableIntState mutableIntState = this.currentPage$delegate;
        mutableIntState.setIntValue((int)var1_1);
    }

    public final float getCurrentPageOffsetFraction() {
        FloatState floatState = (FloatState)this.currentPageOffsetFraction$delegate;
        return floatState.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPageOffsetFraction(float f) {
        void var1_1;
        MutableFloatState mutableFloatState = this.currentPageOffsetFraction$delegate;
        mutableFloatState.setFloatValue((float)var1_1);
    }

    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateFromMeasureResult(PagerMeasureResult measureResult2) {
        Intrinsics.checkNotNullParameter((Object)measureResult2, (String)"measureResult");
        MeasuredPage measuredPage = measureResult2.getCurrentPage();
        Object object = this.lastKnownCurrentPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || !((Collection)measureResult2.getVisiblePagesInfo()).isEmpty()) {
            void var1_1;
            this.hadFirstNotEmptyLayout = true;
            MeasuredPage measuredPage2 = measureResult2.getCurrentPage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, var1_1.getCurrentPageOffsetFraction());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void requestPositionAndForgetLastKnownKey(int index2, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.update((int)var1_1, (float)var2_2);
        this.lastKnownCurrentPageKey = null;
    }

    /*
     * WARNING - void declaration
     */
    public final int matchPageWithKey(PagerLazyLayoutItemProvider itemProvider, int index2) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownCurrentPageKey, index2);
        if (index2 != newIndex) {
            void var2_3;
            this.setCurrentPage(newIndex);
            this.nearestRangeState.update((int)var2_3);
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void update(int page, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.setCurrentPage(page);
        this.nearestRangeState.update((int)var1_1);
        this.setCurrentPageOffsetFraction((float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentPageOffsetFraction(float offsetFraction) {
        void var1_1;
        this.setCurrentPageOffsetFraction((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyScrollDelta(int $i$f$debugLog) {
        void var1_2;
        float fractionUpdate = this.state.getPageSizeWithSpacing$foundation() == 0 ? 0.0f : (float)$i$f$debugLog / (float)this.state.getPageSizeWithSpacing$foundation();
        PagerScrollPosition pagerScrollPosition = this;
        pagerScrollPosition.setCurrentPageOffsetFraction(pagerScrollPosition.getCurrentPageOffsetFraction() + var1_2);
    }
}

